/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.flatfile;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.framework.spi.AbstractConfiguration;

public class FlatFileConfiguration
extends AbstractConfiguration {
    private File file;
    private String encoding = Charset.defaultCharset().name();
    private char textQualifier = (char)34;
    private char fieldDelimeter = (char)44;
    private String uniqueAttribute;

    public void setFile(File value) {
        this.file = value;
    }

    public File getFile() {
        return this.file;
    }

    public void setEncoding(String value) {
        this.encoding = value;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setTextQualifier(char value) {
        this.textQualifier = value;
    }

    public char getTextQualifier() {
        return this.textQualifier;
    }

    public void setFieldDelimiter(char value) {
        this.fieldDelimeter = value;
    }

    public char getFieldDelimiter() {
        return this.fieldDelimeter;
    }

    public void setUniqueAttributeName(String value) {
        this.uniqueAttribute = value;
    }

    public String getUniqueAttributeName() {
        return this.uniqueAttribute;
    }

    public void validate() {
        if (this.encoding == null) {
            String msg = "File encoding must not be null!";
            throw new IllegalArgumentException("File encoding must not be null!");
        }
        Charset.forName(this.encoding);
        if (this.textQualifier == this.fieldDelimeter) {
            String msg = "Field delimiter and text qualifier can not be equal!";
            throw new IllegalStateException("Field delimiter and text qualifier can not be equal!");
        }
        if (StringUtil.isBlank((String)this.uniqueAttribute)) {
            String msg = "Unique identifier must not be blank!";
            throw new IllegalArgumentException("Unique identifier must not be blank!");
        }
        if (!this.getFile().exists()) {
            String msg = "File not found: " + this.getFile().toString();
            throw new IllegalArgumentException(new FileNotFoundException(msg));
        }
        if (!this.getFile().canRead()) {
            throw new IllegalArgumentException("File not accessible!");
        }
    }

    BufferedReader newFileReader() throws IOException {
        BufferedReader rdr = null;
        FileInputStream fis = new FileInputStream(this.getFile());
        InputStreamReader ins = new InputStreamReader((InputStream)fis, this.encoding);
        rdr = new BufferedReader(ins);
        return rdr;
    }
}

