/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.provisioning.util;

import com.evolveum.midpoint.api.logging.Trace;
import com.evolveum.midpoint.logging.TraceManager;
import com.evolveum.midpoint.util.DOMUtil;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ResourceObjectIdentificationType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ResourceObjectShadowType;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ShadowUtil {
    public static final String COMMON_SCHEMA_OBJECT_ELEMENT_NAME = "object";
    public static final String JAXB_PACKAGE_NAME = "com.evolveum.midpoint.xml.ns._public.common.common_1";
    public static final String IC_BUNDLE_NAMESPACE_PREFIX = "http://midpoint.evolveum.com/xml/ns/resource/idconnector/bundle";
    public static final String IC_DEFAULT_ACCOUNT_XSD_OBJECTCLASS_LOCAL_NAME = "AccountObjectClass";
    public static final String IC_DEFAULT_GROUP_XSD_OBJECTCLASS_LOCAL_NAME = "GroupObjectClass";
    private static final Trace logger = TraceManager.getTrace(ShadowUtil.class);

    public static Document getXmlDocument() {
        return DOMUtil.getDocument();
    }

    public static String getSingleValueString(List<Object> list) {
        Object o = list.get(0);
        return (String)o;
    }

    public static String getSingleValueAttributeString(ResourceObjectShadowType.Attributes attrs, QName qname) {
        return ShadowUtil.getSingleValueAttributeString(attrs.getAny(), qname);
    }

    public static String getSingleValueAttributeString(List<Element> any, QName qname) {
        Element e = ShadowUtil.getSingleValueAttributeElement(any, qname);
        if (e == null) {
            return null;
        }
        return e.getTextContent();
    }

    public static Element getSingleValueAttributeElement(ResourceObjectShadowType.Attributes attrs, QName qname) {
        return ShadowUtil.getSingleValueAttributeElement(attrs.getAny(), qname);
    }

    public static Element getSingleValueAttributeElement(List<Element> any, QName qname) {
        Element result = null;
        for (Element o : any) {
            if (o instanceof Element) {
                Element e = o;
                if (!qname.getNamespaceURI().equals(e.getNamespaceURI()) || !qname.getLocalPart().equals(e.getLocalName())) continue;
                if (result == null) {
                    result = e;
                    continue;
                }
                throw new IllegalStateException("Multiple values found where single value expected for attribute " + qname);
            }
            throw new IllegalStateException("Unknown type genrated by JAX-B code for ResourceObjectShadow attributes: " + o);
        }
        return result;
    }

    public static void replaceSingleValueAttribute(ResourceObjectShadowType.Attributes attrs, QName qname, String newValue) throws ParserConfigurationException {
        ShadowUtil.replaceSingleValueAttribute(attrs.getAny(), qname, newValue);
    }

    public static void replaceSingleValueAttribute(List<Element> any, QName qname, String newValue) throws ParserConfigurationException {
        Element e = ShadowUtil.getXmlDocument().createElementNS(qname.getNamespaceURI(), qname.getLocalPart());
        e.setTextContent(newValue);
        ShadowUtil.replaceSingleValueAttribute(any, e);
    }

    public static void replaceSingleValueAttribute(List<Element> any, Element newElement) {
        Element found = null;
        for (Element o : any) {
            if (o instanceof Element) {
                Element e = o;
                if (!newElement.getNamespaceURI().equals(e.getNamespaceURI()) || !newElement.getLocalName().equals(e.getLocalName())) continue;
                if (found == null) {
                    found = o;
                    continue;
                }
                throw new IllegalStateException("Multiple values found where single value expected for attribute {" + newElement.getNamespaceURI() + "}" + newElement.getLocalName());
            }
            throw new IllegalStateException("Unknown type genrated by JAX-B code for ResourceObjectShadow attributes: " + o);
        }
        any.remove(found);
        any.add(newElement);
    }

    public static void replaceMultiValueAttribute(ResourceObjectShadowType.Attributes attrs, QName qname, Set<String> values) throws ParserConfigurationException {
        ShadowUtil.replaceMultiValueAttribute(attrs.getAny(), qname, values);
    }

    public static void replaceMultiValueAttribute(List<Element> any, QName qname, Set<String> values) throws ParserConfigurationException {
        Element e;
        Document xmlDocument = ShadowUtil.getXmlDocument();
        HashSet<Element> found = new HashSet<Element>();
        for (Element o : any) {
            if (o instanceof Element) {
                e = o;
                if (!qname.getNamespaceURI().equals(e.getNamespaceURI()) || !qname.getLocalPart().equals(e.getLocalName())) continue;
                found.add(o);
                continue;
            }
            throw new IllegalStateException("Unknown type genrated by JAX-B code for ResourceObjectShadow attributes: " + o);
        }
        for (Element o : found) {
            any.remove(o);
        }
        for (String value : values) {
            e = xmlDocument.createElementNS(qname.getNamespaceURI(), qname.getLocalPart());
            e.setTextContent(value);
            any.add(e);
        }
    }

    public static Set<String> getMultiValueAttributeString(ResourceObjectShadowType.Attributes attrs, QName qname) {
        return ShadowUtil.getMultiValueAttributeString(attrs.getAny(), qname);
    }

    public static Set<String> getMultiValueAttributeString(List<Element> any, QName qname) {
        Set<Element> el = ShadowUtil.getMultiValueAttributeElement(any, qname);
        HashSet<String> result = new HashSet<String>();
        for (Element e : el) {
            result.add(e.getTextContent());
        }
        return result;
    }

    public static Set<Element> getMultiValueAttributeElement(List<Element> any, QName qname) {
        HashSet<Element> result = new HashSet<Element>();
        for (Element o : any) {
            if (o instanceof Element) {
                Element e = o;
                if (!qname.getNamespaceURI().equals(e.getNamespaceURI()) || !qname.getLocalPart().equals(e.getLocalName())) continue;
                result.add(e);
                continue;
            }
            throw new IllegalStateException("Unknown type genrated by JAX-B code for ResourceObjectShadow attributes: " + o);
        }
        return result;
    }

    public static ResourceObjectIdentificationType attributesToIdentification(ResourceObjectShadowType.Attributes attrs) {
        ResourceObjectIdentificationType id = new ResourceObjectIdentificationType();
        for (Element o : attrs.getAny()) {
            id.getAny().add(o);
        }
        return id;
    }

    public static void changeAttributes(List<Element> to, List<Element> from) {
        to.clear();
        for (Element o : from) {
            to.add(o);
        }
    }

    public static void mergeAttributes(ResourceObjectShadowType.Attributes to, ResourceObjectShadowType.Attributes from) {
        HashSet<QName> toDelete = new HashSet<QName>();
        Iterator i$ = from.getAny().iterator();
        while (i$.hasNext()) {
            Element o;
            Element e = o = (Element)i$.next();
            toDelete.add(ShadowUtil.qNameFromElement(e));
        }
        Iterator it = to.getAny().iterator();
        while (it.hasNext()) {
            Element e = (Element)it.next();
            for (QName deleteQName : toDelete) {
                if (!ShadowUtil.isElementQName(e, deleteQName)) continue;
                it.remove();
            }
        }
        Iterator i$2 = from.getAny().iterator();
        while (i$2.hasNext()) {
            Element o;
            Element e = o = (Element)i$2.next();
            to.getAny().add(e);
        }
    }

    public static QName qNameFromElement(Element e) {
        return new QName(e.getNamespaceURI(), e.getLocalName());
    }

    public static boolean isElementQName(Element e, QName qname) {
        return e.getNamespaceURI().equals(qname.getNamespaceURI()) && e.getLocalName().equals(qname.getLocalPart());
    }

    public static Map<String, Set<Element>> indexElementsByName(List<Element> any) {
        return ShadowUtil.indexElementsByName(any, null);
    }

    public static Map<String, Set<Element>> indexElementsByName(List<Element> any, String namespace) {
        logger.debug("indexElementsByName begin");
        logger.debug("namespace = {}", (Object)namespace);
        HashMap<String, Set<Element>> index = new HashMap<String, Set<Element>>();
        Iterator<Element> i$ = any.iterator();
        while (i$.hasNext()) {
            Element o;
            Element e = o = i$.next();
            logger.debug("e = {}", (Object)e);
            logger.debug("e.getLocalName = {}", (Object)e.getLocalName());
            logger.debug("e.getNamespaceURI() = {}", (Object)e.getNamespaceURI());
            if (namespace != null && !namespace.equals(e.getNamespaceURI())) continue;
            String name = e.getLocalName();
            HashSet<Element> elements = (HashSet<Element>)index.get(name);
            if (elements == null) {
                elements = new HashSet<Element>();
                index.put(name, elements);
            }
            elements.add(e);
        }
        logger.debug("indexElementsByName end");
        return index;
    }

    public static QName squeezeSingleQname(List<Element> any) {
        String resultNs = null;
        String resultName = null;
        for (Element o : any) {
            if (o instanceof Element) {
                Element e = o;
                if (resultName == null) {
                    resultNs = e.getNamespaceURI();
                    resultName = e.getLocalName();
                    continue;
                }
                if (resultName.equals(e.getLocalName()) && resultNs.equals(e.getNamespaceURI())) continue;
                throw new IllegalStateException("Multiple QNames found where single element was expected");
            }
            throw new IllegalStateException("Unknown type genrated by JAX-B code for ResourceObjectShadow attributes: " + o);
        }
        return new QName(resultNs, resultName);
    }

    public static Set<String> squeezeSingleStringValues(List<Element> any) {
        HashSet<String> result = new HashSet<String>();
        String resultNs = null;
        String resultName = null;
        for (Element o : any) {
            if (o instanceof Element) {
                Element e = o;
                if (resultName == null) {
                    resultNs = e.getNamespaceURI();
                    resultName = e.getLocalName();
                    result.add(e.getTextContent());
                    continue;
                }
                if (resultName.equals(e.getLocalName()) && resultNs.equals(e.getNamespaceURI())) {
                    result.add(e.getTextContent());
                    continue;
                }
                throw new IllegalStateException("Multiple QNames found where single element was expected");
            }
            throw new IllegalStateException("Unknown type genrated by JAX-B code for ResourceObjectShadow attributes: " + o);
        }
        return result;
    }
}

