/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.provisioning.synchronization;

import com.evolveum.midpoint.api.logging.Trace;
import com.evolveum.midpoint.logging.TraceManager;
import com.evolveum.midpoint.provisioning.synchronization.SynchronizationProcess;
import com.evolveum.midpoint.xml.ns._public.provisioning.provisioning_1.ProvisioningPortType;

public class SynchronizationProcessManager {
    private static final String THREAD_NAME = "midpoint-synchronization";
    private SynchronizationProcess thread = null;
    private ProvisioningPortType provisioningService;
    private static final transient Trace logger = TraceManager.getTrace(SynchronizationProcessManager.class);
    private long JOIN_TIMEOUT = 5000L;

    public void setProvisioningService(ProvisioningPortType provisioningService) {
        this.provisioningService = provisioningService;
    }

    public void init() {
        logger.info("Synchronization Manager initialization");
        this.startThread();
    }

    public void shutdown() {
        logger.info("Synchronization Manager shutdown");
        this.stopThread();
    }

    private void startThread() {
        if (this.thread == null) {
            this.thread = new SynchronizationProcess(this.provisioningService);
            this.thread.setName(THREAD_NAME);
        }
        if (this.thread.isAlive()) {
            logger.warn("Attempt to start syncronization thread that is already running");
        } else {
            this.thread.start();
        }
    }

    private void stopThread() {
        if (this.thread == null) {
            logger.warn("Attempt to stop non-existing synchronization thread");
        } else if (this.thread.isAlive()) {
            this.thread.disable();
            this.thread.interrupt();
            try {
                this.thread.join(this.JOIN_TIMEOUT);
            }
            catch (InterruptedException ex) {
                logger.warn("Wait to thread join in SynchronizationManager was interrupted");
            }
        } else {
            logger.warn("Attempt to stop a synchronization thread that is not alive");
        }
    }
}

