/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.provisioning.synchronization;

import com.evolveum.midpoint.api.logging.Trace;
import com.evolveum.midpoint.logging.TraceManager;
import com.evolveum.midpoint.util.QNameUtil;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ObjectListType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ObjectType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.PagingType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ResourceType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.SynchronizationType;
import com.evolveum.midpoint.xml.ns._public.provisioning.provisioning_1.FaultMessage;
import com.evolveum.midpoint.xml.ns._public.provisioning.provisioning_1.ProvisioningPortType;
import com.evolveum.midpoint.xml.schema.SchemaConstants;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.ws.Holder;

public class SynchronizationProcess
extends Thread {
    private static final long SLEEP_INTERVAL = 60000L;
    ProvisioningPortType provisioning;
    private boolean enabled = true;
    private long lastLoopRun = 0L;
    private Map<String, Long> lastResourceRun;
    private static final transient Trace logger = TraceManager.getTrace(SynchronizationProcess.class);

    public SynchronizationProcess(ProvisioningPortType provisioningService) {
        this.provisioning = provisioningService;
        this.lastResourceRun = new HashMap<String, Long>();
    }

    @Override
    public void run() {
        logger.info("Synchronization thread starting");
        while (this.enabled) {
            logger.trace("Synchronization thread loop: start");
            this.lastLoopRun = System.currentTimeMillis();
            PagingType paging = new PagingType();
            Holder resultHolder = new Holder();
            ObjectListType listObjects = null;
            try {
                listObjects = this.provisioning.listObjects(QNameUtil.qNameToUri((QName)SchemaConstants.I_RESOURCE_TYPE), paging, resultHolder);
            }
            catch (FaultMessage ex) {
                logger.error("Synchronizatoin thread got provisioning fault (listObjects):" + (Object)((Object)ex));
            }
            if (listObjects != null) {
                List objectList = listObjects.getObject();
                for (ObjectType o : objectList) {
                    if (o instanceof ResourceType) {
                        ResourceType resource = (ResourceType)o;
                        logger.trace("Synchronization thread: Start processing resource " + resource.getName() + " (OID: " + resource.getOid() + ")");
                        SynchronizationType synchronization = resource.getSynchronization();
                        if (synchronization == null) {
                            logger.trace("Synchronization thread: skipping resource " + resource.getName() + " because it does not have synchronization section");
                        } else if (synchronization.isEnabled() == null || synchronization.isEnabled().booleanValue()) {
                            String oid = resource.getOid();
                            long pollingInterval = 0L;
                            if (synchronization.getPollingInterval() != null) {
                                pollingInterval = synchronization.getPollingInterval().longValue() * 1000L;
                            }
                            if (this.lastResourceRun.get(oid) == null || this.lastResourceRun.get(oid) + pollingInterval < System.currentTimeMillis()) {
                                long startTime = System.currentTimeMillis();
                                try {
                                    logger.debug("Synchronization Thread: calling synchronize() for resource " + resource.getName() + " oid: " + oid);
                                    this.provisioning.synchronize(oid);
                                    this.lastResourceRun.put(oid, startTime);
                                }
                                catch (FaultMessage ex) {
                                    logger.error("Synchronizatoin thread got provisioning fault (synchronize): {} : {}", new Object[]{((Object)((Object)ex)).getClass().getSimpleName(), ex.getMessage(), ex});
                                }
                                catch (RuntimeException ex) {
                                    logger.error("Synchronizatoin thread got runtime exception (synchronize): {} : {}", new Object[]{ex.getClass().getSimpleName(), ex.getMessage(), ex});
                                }
                            }
                        } else {
                            logger.trace("Synchronization thread: skipping resource " + resource.getName() + " because it is not enabled");
                        }
                        logger.trace("Synchronization thread: End processing resource " + resource.getName() + " (OID: " + resource.getOid() + ")");
                        continue;
                    }
                    logger.error("Synchronization thread got unexpected object type in listObjects: " + o.getClass().getName());
                }
            }
            if (this.lastLoopRun + 60000L > System.currentTimeMillis()) {
                logger.trace("Synchronization thread loop: going to sleep");
                try {
                    Thread.sleep(60000L - (System.currentTimeMillis() - this.lastLoopRun));
                }
                catch (InterruptedException ex) {
                    logger.trace("Synchronization thread got InterruptedException: " + ex);
                }
            }
            logger.trace("Synchronization thread loop: end");
        }
        logger.info("Synchronization thread stopping");
    }

    public void disable() {
        this.enabled = false;
    }

    public void enable() {
        this.enabled = true;
    }
}

