/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.provisioning.service;

import com.evolveum.midpoint.provisioning.schema.ResourceSchema;
import com.evolveum.midpoint.provisioning.schema.util.DOMToSchemaParser;
import com.evolveum.midpoint.provisioning.service.BaseResourceIntegration;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ResourceType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.SchemaHandlingType;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;

public abstract class ResourceConnector<C> {
    public static final String code_id = "$Id$";
    public static final QName QN_SCHEMA = new QName("http://www.w3.org/2001/XMLSchema", "schema");
    protected ResourceType _resource;
    private final ResourceSchema _resourceSchema;

    public ResourceConnector() {
        this._resourceSchema = null;
    }

    public ResourceConnector(ResourceType resourceType) {
        DOMToSchemaParser parser = new DOMToSchemaParser();
        Element resourceSchema = null;
        SchemaHandlingType schemaHandling = null;
        if (null != resourceType.getSchema() && !resourceType.getSchema().getAny().isEmpty()) {
            for (Element e : resourceType.getSchema().getAny()) {
                if (!"http://www.w3.org/2001/XMLSchema".equals(e.getNamespaceURI()) || !"schema".equals(e.getLocalName())) continue;
                resourceSchema = e;
                break;
            }
        }
        schemaHandling = resourceType.getSchemaHandling();
        this._resourceSchema = parser.getSchema(resourceSchema, schemaHandling);
        this._resource = resourceType;
    }

    public ResourceConnector(BaseResourceIntegration res) {
        this(res.getResource());
    }

    public abstract C getConfiguration();

    public String getOid() {
        return this._resource.getOid();
    }

    public String getNamespace() {
        return this._resource.getNamespace();
    }

    public boolean isAccountNameIsUid() {
        return true;
    }

    public ResourceSchema getSchema() {
        return this._resourceSchema;
    }

    public ResourceType getResource() {
        return this._resource;
    }
}

