/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.provisioning.service;

import com.evolveum.midpoint.api.logging.Trace;
import com.evolveum.midpoint.logging.TraceManager;
import com.evolveum.midpoint.provisioning.exceptions.InitialisationException;
import com.evolveum.midpoint.provisioning.pool.ResourceAccessPoolFactory;
import com.evolveum.midpoint.provisioning.service.ResourceAccessInterface;
import com.evolveum.midpoint.provisioning.service.ResourceConnector;
import com.evolveum.midpoint.provisioning.service.ResourceFactory;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ResourceAccessConfigurationType;
import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.apache.commons.pool.impl.GenericKeyedObjectPool;

public class DefaultResourceFactory
implements ResourceFactory {
    private static final Trace logger = TraceManager.getTrace(DefaultResourceFactory.class);
    private ResourceAccessPoolFactory factory = new ResourceAccessPoolFactory();
    private GenericKeyedObjectPool pool = new GenericKeyedObjectPool((KeyedPoolableObjectFactory)this.factory, -1);

    @Override
    public <T extends ResourceAccessInterface<?>> void checkin(T resourceAccessInterface) {
        try {
            this.pool.returnObject(resourceAccessInterface.getClass(), resourceAccessInterface);
        }
        catch (Exception ex) {
            logger.error("Pool Checkin Exception", (Throwable)ex);
        }
    }

    @Override
    public <T extends ResourceAccessInterface<C>, C extends ResourceConnector<?>> T checkout(Class<T> c, C resource, ResourceAccessConfigurationType configuration) throws InitialisationException {
        try {
            ResourceAccessInterface rai = (ResourceAccessInterface)this.pool.borrowObject(c);
            if (rai.configure(configuration)) {
                return rai.initialise(c, resource);
            }
        }
        catch (Exception ex) {
            logger.error("Pool Checkout Exception", (Throwable)ex);
            throw new InitialisationException("ResourceAccessInterface for '" + resource.getOid() + "' can not be initialised, reason: " + ex.getMessage(), ex);
        }
        throw new InitialisationException("ResourceAccessInterface for '" + resource.getOid() + "' can not be initialised, unknown reason.");
    }
}

