/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.provisioning.schema;

import com.evolveum.midpoint.api.exceptions.MidPointException;
import com.evolveum.midpoint.provisioning.conversion.Converter;
import com.evolveum.midpoint.provisioning.conversion.ConverterFactory;
import com.evolveum.midpoint.provisioning.conversion.DefaultConverterFactory;
import com.evolveum.midpoint.provisioning.schema.ResourceObjectDefinition;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;

public class ResourceSchema {
    private List<ResourceObjectDefinition> objectclasses;
    private String resourceNamespace;
    private Set<String> importList;
    private DefaultConverterFactory converterFactory = new DefaultConverterFactory();

    public ResourceSchema(String resourceNamespace) {
        this.resourceNamespace = resourceNamespace;
    }

    public Iterator<ResourceObjectDefinition> getObjectClassesIterator() {
        return this.getObjectClasses().iterator();
    }

    public List<ResourceObjectDefinition> getObjectClassesCopy() {
        return new ArrayList<ResourceObjectDefinition>(this.getObjectClasses());
    }

    protected List<ResourceObjectDefinition> getObjectClasses() {
        if (this.objectclasses == null) {
            this.objectclasses = new ArrayList<ResourceObjectDefinition>();
        }
        return this.objectclasses;
    }

    public void addObjectClass(ResourceObjectDefinition def) {
        this.getObjectClasses().add(def);
        def.setParentSchema(this);
    }

    public Set<String> getImportList() {
        if (this.importList == null) {
            this.importList = new HashSet<String>();
        }
        return this.importList;
    }

    public String getResourceNamespace() {
        return this.resourceNamespace;
    }

    public ResourceObjectDefinition getObjectDefinition(QName objectType) {
        if (objectType == null) {
            throw new IllegalArgumentException("Object type qname must not be null.");
        }
        for (ResourceObjectDefinition def : this.objectclasses) {
            if (!def.getQName().equals(objectType)) continue;
            return def;
        }
        throw new MidPointException("Unsupported ObjectType in resource schema: " + objectType);
    }

    public void addConverter(Converter conveter) {
        this.converterFactory.addConverter(conveter);
    }

    public ConverterFactory getConverterFactory() {
        return this.converterFactory;
    }
}

