/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.provisioning.schema;

import com.evolveum.midpoint.provisioning.schema.Operation;
import com.evolveum.midpoint.provisioning.schema.ResourceAttributeDefinition;
import com.evolveum.midpoint.provisioning.schema.ResourceSchema;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;

public class ResourceObjectDefinition {
    private final QName qname;
    private String name;
    private final String nativeObjectClass;
    private Map<QName, ResourceAttributeDefinition> attributes = new HashMap<QName, ResourceAttributeDefinition>();
    private List<ResourceObjectDefinition> superclasses;
    private final boolean container;
    private List<Operation> operations = null;
    private ResourceSchema parentSchema;

    public ResourceObjectDefinition(QName qname) {
        this(qname, qname.getLocalPart(), false);
    }

    public ResourceObjectDefinition(QName qname, String nativeObjectClass) {
        this(qname, nativeObjectClass, false);
    }

    public ResourceObjectDefinition(QName qname, boolean container) {
        this(qname, qname.getLocalPart(), container);
    }

    public ResourceObjectDefinition(QName qname, String nativeObjectClass, boolean container) {
        if (qname == null) {
            throw new IllegalArgumentException("Qname can't be null.");
        }
        if (nativeObjectClass == null) {
            throw new IllegalArgumentException("Native object class can't be null.");
        }
        this.qname = qname;
        this.nativeObjectClass = nativeObjectClass;
        this.container = container;
    }

    public String getNativeObjectClass() {
        return this.nativeObjectClass;
    }

    public List getSuperclasses() {
        if (this.superclasses == null) {
            this.superclasses = new ArrayList<ResourceObjectDefinition>();
        }
        return this.superclasses;
    }

    public Collection<ResourceAttributeDefinition> getAttributesCopy() {
        return new ArrayList<ResourceAttributeDefinition>(this.attributes.values());
    }

    protected Collection<ResourceAttributeDefinition> getAttributes() {
        return this.attributes.values();
    }

    public ResourceAttributeDefinition getAttributeDefinition(QName qname) {
        return this.attributes.get(qname);
    }

    public QName getQName() {
        return this.qname;
    }

    public String getName() {
        if (this.name == null) {
            return this.qname.getLocalPart();
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isContainer() {
        return this.container;
    }

    public List<Operation> getOperations() {
        if (this.operations == null) {
            this.operations = new ArrayList<Operation>();
        }
        return this.operations;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.qname);
        return builder.toString();
    }

    public void addAttribute(ResourceAttributeDefinition raf) {
        this.attributes.put(raf.getQName(), raf);
        raf.setParentDefinition(this);
    }

    public Collection<ResourceAttributeDefinition> getRequiredAttributes() {
        ArrayList<ResourceAttributeDefinition> result = new ArrayList<ResourceAttributeDefinition>();
        for (ResourceAttributeDefinition a : this.getAttributes()) {
            if (!a.isRequired()) continue;
            result.add(a);
        }
        return Collections.unmodifiableCollection(result);
    }

    public Collection<ResourceAttributeDefinition> getRequiredAttributsForCreate() {
        ArrayList<ResourceAttributeDefinition> result = new ArrayList<ResourceAttributeDefinition>();
        ArrayList identifiers = new ArrayList();
        boolean hasSecondaryIdentifier = false;
        for (ResourceAttributeDefinition a : this.getAttributes()) {
            if (!a.isRequired()) continue;
            result.add(a);
        }
        result.addAll(identifiers);
        return Collections.unmodifiableCollection(result);
    }

    public ResourceAttributeDefinition getPrimaryIdentifier() {
        ResourceAttributeDefinition id = null;
        for (ResourceAttributeDefinition a : this.getAttributes()) {
            if (!a.isIdentifier()) continue;
            return a;
        }
        return id;
    }

    public ResourceAttributeDefinition getSecondaryIdentifier() {
        ResourceAttributeDefinition id = null;
        for (ResourceAttributeDefinition a : this.getAttributes()) {
            if (a.isSecondaryIdentifier()) {
                return a;
            }
            if (!a.isIdentifier()) continue;
            id = a;
        }
        return id;
    }

    public ResourceSchema getParentSchema() {
        return this.parentSchema;
    }

    public void setParentSchema(ResourceSchema parentSchema) {
        this.parentSchema = parentSchema;
    }
}

