/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.provisioning.integration.identityconnector.schema;

import com.evolveum.midpoint.api.exceptions.MidPointException;
import com.evolveum.midpoint.api.logging.Trace;
import com.evolveum.midpoint.logging.TraceManager;
import com.evolveum.midpoint.provisioning.integration.identityconnector.converter.ICFConverterFactory;
import com.evolveum.midpoint.provisioning.objects.ResourceAttribute;
import com.evolveum.midpoint.provisioning.objects.ResourceObject;
import com.evolveum.midpoint.provisioning.schema.AttributeFlag;
import com.evolveum.midpoint.provisioning.schema.ResourceAttributeDefinition;
import com.evolveum.midpoint.provisioning.schema.ResourceObjectDefinition;
import com.evolveum.midpoint.provisioning.schema.ResourceSchema;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.identityconnectors.common.security.GuardedByteArray;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeBuilder;
import org.identityconnectors.framework.common.objects.AttributeInfo;
import org.identityconnectors.framework.common.objects.AttributeUtil;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.Name;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.ObjectClassInfo;
import org.identityconnectors.framework.common.objects.ObjectClassUtil;
import org.identityconnectors.framework.common.objects.OperationalAttributes;
import org.identityconnectors.framework.common.objects.PredefinedAttributes;
import org.identityconnectors.framework.common.objects.Schema;
import org.identityconnectors.framework.common.objects.Uid;

public class ResourceUtils {
    public static final String code_id = "$Id$";
    private static final Trace logger = TraceManager.getTrace(ResourceUtils.class);
    public static final String NS_ICF_RESOURCE = "http://midpoint.evolveum.com/xml/ns/public/resource/idconnector/resource-schema-1.xsd";
    public static final String NS_ICF_CONFIGURATION = "http://midpoint.evolveum.com/xml/ns/public/resource/idconnector/configuration-1.xsd";
    public static final QName ATTRIBUTE_NAME = new QName("http://midpoint.evolveum.com/xml/ns/public/resource/idconnector/resource-schema-1.xsd", Name.NAME);
    public static final QName ATTRIBUTE_UID = new QName("http://midpoint.evolveum.com/xml/ns/public/resource/idconnector/resource-schema-1.xsd", Uid.NAME);
    public static final QName ATTRIBUTE_PASSWORD = new QName("http://midpoint.evolveum.com/xml/ns/public/resource/idconnector/resource-schema-1.xsd", OperationalAttributes.PASSWORD_NAME);
    public static final String OBJECT_CLASS_ACCOUNT = "AccountObjectClass";
    public static final String OBJECT_CLASS_GROUP = "GroupObjectClass";
    public static final String OBJECT_CLASS_CUSTOM = "CustomObjectClass";
    private static final Map<Class, QName> types = new HashMap<Class, QName>();
    private Map<String, QName> attributeTypeConversion = new HashMap<String, QName>();
    private static ResourceUtils instance = new ResourceUtils();

    private ResourceUtils() {
        this.attributeTypeConversion.put(Name.NAME, ATTRIBUTE_NAME);
        this.attributeTypeConversion.put(Uid.NAME, ATTRIBUTE_UID);
        for (String name : OperationalAttributes.getOperationalAttributeNames()) {
            this.attributeTypeConversion.put(name, new QName(NS_ICF_RESOURCE, name));
        }
        for (String name : new String[]{PredefinedAttributes.SHORT_NAME, PredefinedAttributes.DESCRIPTION, PredefinedAttributes.GROUPS_NAME, PredefinedAttributes.LAST_LOGIN_DATE_NAME, PredefinedAttributes.LAST_PASSWORD_CHANGE_DATE_NAME, PredefinedAttributes.PASSWORD_CHANGE_INTERVAL_NAME}) {
            this.attributeTypeConversion.put(name, new QName(NS_ICF_RESOURCE, name));
        }
    }

    public static ResourceUtils getInstance() {
        return instance;
    }

    public ObjectClass mapObjectClass(ResourceObjectDefinition def) {
        if (ObjectClassUtil.namesEqual((String)ObjectClass.ACCOUNT_NAME, (String)def.getNativeObjectClass())) {
            return ObjectClass.ACCOUNT;
        }
        if (ObjectClassUtil.namesEqual((String)ObjectClass.GROUP_NAME, (String)def.getNativeObjectClass())) {
            return ObjectClass.GROUP;
        }
        return new ObjectClass(def.getNativeObjectClass());
    }

    public Set<Attribute> convertAttributes(ResourceObject resourceObject, Set<Attribute> attributes) {
        for (ResourceAttribute attribute : resourceObject.getValues()) {
            this.addConnectorAttribute(attributes, attribute);
        }
        return attributes;
    }

    @Deprecated
    public Set<Attribute> buildConnectorObject(ResourceObject resourceObject) {
        HashSet<Attribute> result = new HashSet<Attribute>(2);
        for (ResourceAttribute attribute : resourceObject.getValues()) {
            this.addConnectorAttribute(result, attribute);
        }
        return result;
    }

    protected void addConnectorAttribute(Set<Attribute> result, ResourceAttribute attr) {
        Attribute a = AttributeUtil.find((String)attr.getDefinition().getQName().getLocalPart(), result);
        if (null != a) {
            result.remove(a);
        }
        result.add(this.resourceAttributeToIcfAttribute(attr, a));
    }

    public Attribute resourceAttributeToIcfAttribute(ResourceAttribute attr, Attribute a) {
        if (ATTRIBUTE_UID.equals(attr.getDefinition().getQName())) {
            return new Uid(attr.getSingleJavaValue(String.class));
        }
        if (ATTRIBUTE_NAME.equals(attr.getDefinition().getQName())) {
            return new Name(attr.getSingleJavaValue(String.class));
        }
        if (ATTRIBUTE_PASSWORD.equals(attr.getDefinition().getQName())) {
            String password = attr.getSingleJavaValue(String.class);
            return AttributeBuilder.buildPassword((GuardedString)((GuardedString)ICFConverterFactory.getInstance().getConverter(GuardedString.class, password).convert((Object)password)));
        }
        if (attr.getDefinition().isMultivalue()) {
            ArrayList value = new ArrayList();
            if (a != null) {
                value.addAll(a.getValue());
            }
            value.addAll(attr.getJavaValues());
            return AttributeBuilder.build((String)attr.getDefinition().getQName().getLocalPart(), value);
        }
        return AttributeBuilder.build((String)attr.getDefinition().getQName().getLocalPart(), (Collection)attr.getJavaValues());
    }

    public ResourceObject buildResourceObject(ConnectorObject connectorObject, ResourceObjectDefinition resourceObjectDefinition) throws MidPointException {
        ResourceObject result = new ResourceObject(resourceObjectDefinition);
        Set<String> specialAttribute = this.attributeTypeConversion.keySet();
        for (Attribute connectorAttribute : connectorObject.getAttributes()) {
            ResourceAttribute resourceAttr;
            ResourceAttributeDefinition def;
            QName qname;
            String attributeName = connectorAttribute.getName();
            if (specialAttribute.contains(attributeName)) {
                qname = this.attributeTypeConversion.get(attributeName);
                def = resourceObjectDefinition.getAttributeDefinition(qname);
                if (def == null) continue;
                resourceAttr = new ResourceAttribute(def);
                for (Object value : connectorAttribute.getValue()) {
                    resourceAttr.addJavaValue(value);
                }
                result.addValue(resourceAttr);
                continue;
            }
            qname = new QName(resourceObjectDefinition.getQName().getNamespaceURI(), attributeName);
            def = resourceObjectDefinition.getAttributeDefinition(qname);
            if (def == null) continue;
            resourceAttr = new ResourceAttribute(def);
            for (Object value : connectorAttribute.getValue()) {
                resourceAttr.addJavaValue(value);
            }
            result.addValue(resourceAttr);
        }
        return result;
    }

    public ResourceSchema parse(Schema schema, String resourceNamespace) {
        ResourceSchema resSchema = new ResourceSchema(resourceNamespace);
        Set ocInfo = schema.getObjectClassInfo();
        if (ocInfo == null) {
            return resSchema;
        }
        for (ObjectClassInfo info : ocInfo) {
            QName qname = ObjectClass.ACCOUNT_NAME.equals(info.getType()) ? new QName(resourceNamespace, OBJECT_CLASS_ACCOUNT) : (ObjectClass.GROUP_NAME.equals(info.getType()) ? new QName(resourceNamespace, OBJECT_CLASS_GROUP) : new QName(resourceNamespace, OBJECT_CLASS_CUSTOM));
            ResourceObjectDefinition objClass = new ResourceObjectDefinition(qname, info.getType());
            ResourceAttributeDefinition uid = new ResourceAttributeDefinition(new QName(NS_ICF_RESOURCE, "uid"));
            uid.setType(new QName(NS_ICF_RESOURCE, "uid"));
            uid.setIdentifier(true);
            objClass.addAttribute(uid);
            Set attributeInfoSet = info.getAttributeInfo();
            if (attributeInfoSet != null) {
                for (AttributeInfo attributeInfo : attributeInfoSet) {
                    if (attributeInfo.getName() == null) continue;
                    ResourceAttributeDefinition attribute = this.createResourceAttribute(attributeInfo, resourceNamespace);
                    objClass.addAttribute(attribute);
                }
            }
            resSchema.addObjectClass(objClass);
        }
        return resSchema;
    }

    private ResourceAttributeDefinition createResourceAttribute(AttributeInfo info, String resourceNamespace) {
        QName attributeQName = new QName(resourceNamespace, info.getName());
        ResourceAttributeDefinition attribute = new ResourceAttributeDefinition(attributeQName);
        if (ATTRIBUTE_PASSWORD.equals(attributeQName)) {
            attribute.setType(new QName(NS_ICF_RESOURCE, "password"));
        } else {
            attribute.setType(this.translateClassName(info.getType()));
        }
        attribute.setRestriction(null);
        attribute.setMinOccurs(0);
        Set flagsSet = info.getFlags();
        ArrayList<AttributeFlag> flagList = new ArrayList<AttributeFlag>();
        for (AttributeInfo.Flags flags : flagsSet) {
            switch (flags) {
                case MULTIVALUED: {
                    attribute.setMaxOccurs(-1);
                    break;
                }
                case NOT_CREATABLE: {
                    flagList.add(AttributeFlag.NOT_CREATABLE);
                    break;
                }
                case NOT_READABLE: {
                    flagList.add(AttributeFlag.NOT_READABLE);
                    break;
                }
                case NOT_RETURNED_BY_DEFAULT: {
                    flagList.add(AttributeFlag.NOT_RETURNED_BY_DEFAULT);
                    break;
                }
                case NOT_UPDATEABLE: {
                    flagList.add(AttributeFlag.NOT_UPDATEABLE);
                    break;
                }
                case REQUIRED: {
                    attribute.setMinOccurs(1);
                }
            }
        }
        attribute.setAttributeFlag(flagList);
        return attribute;
    }

    public QName translateClassName(Class clazz) {
        return types.get(clazz);
    }

    static {
        types.put(String.class, new QName("http://www.w3.org/2001/XMLSchema", "string"));
        types.put(Long.class, new QName("http://www.w3.org/2001/XMLSchema", "long"));
        types.put(Long.TYPE, new QName("http://www.w3.org/2001/XMLSchema", "long"));
        types.put(Character.TYPE, new QName("http://www.w3.org/2001/XMLSchema", "string"));
        types.put(Character.class, new QName("http://www.w3.org/2001/XMLSchema", "string"));
        types.put(Double.TYPE, new QName("http://www.w3.org/2001/XMLSchema", "string"));
        types.put(Double.class, new QName("http://www.w3.org/2001/XMLSchema", "string"));
        types.put(Float.TYPE, new QName("http://www.w3.org/2001/XMLSchema", "string"));
        types.put(Float.class, new QName("http://www.w3.org/2001/XMLSchema", "string"));
        types.put(Integer.TYPE, new QName("http://www.w3.org/2001/XMLSchema", "int"));
        types.put(Integer.class, new QName("http://www.w3.org/2001/XMLSchema", "int"));
        types.put(Boolean.TYPE, new QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        types.put(Boolean.class, new QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        types.put(byte[].class, new QName("http://www.w3.org/2001/XMLSchema", "base64Binary"));
        types.put(BigDecimal.class, new QName("http://www.w3.org/2001/XMLSchema", "long"));
        types.put(BigInteger.class, new QName("http://www.w3.org/2001/XMLSchema", "long"));
        types.put(GuardedByteArray.class, new QName("http://www.w3.org/2001/XMLSchema", "base64Binary"));
        types.put(GuardedString.class, new QName("http://midpoint.evolveum.com/xml/ns/public/common/common-1.xsd", "PasswordType"));
    }
}

