/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.provisioning.integration.identityconnector;

import com.evolveum.midpoint.api.exceptions.MidPointException;
import com.evolveum.midpoint.api.logging.Trace;
import com.evolveum.midpoint.logging.TraceManager;
import com.evolveum.midpoint.provisioning.integration.identityconnector.ConnectorUtil;
import com.evolveum.midpoint.provisioning.integration.identityconnector.converter.ICFConverterFactory;
import com.evolveum.midpoint.provisioning.integration.identityconnector.script.ConnectorScript;
import com.evolveum.midpoint.provisioning.integration.identityconnector.script.ConnectorScriptBuilder;
import com.evolveum.midpoint.provisioning.integration.identityconnector.script.ConnectorScriptExecutor;
import com.evolveum.midpoint.util.MidPointResult;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ResourceObjectShadowType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.framework.api.ConnectorFacade;
import org.identityconnectors.framework.api.operations.APIOperation;
import org.identityconnectors.framework.api.operations.CreateApiOp;
import org.identityconnectors.framework.api.operations.DeleteApiOp;
import org.identityconnectors.framework.api.operations.GetApiOp;
import org.identityconnectors.framework.api.operations.ScriptOnConnectorApiOp;
import org.identityconnectors.framework.api.operations.ScriptOnResourceApiOp;
import org.identityconnectors.framework.api.operations.SearchApiOp;
import org.identityconnectors.framework.api.operations.SyncApiOp;
import org.identityconnectors.framework.api.operations.UpdateApiOp;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeBuilder;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.OperationOptions;
import org.identityconnectors.framework.common.objects.OperationOptionsBuilder;
import org.identityconnectors.framework.common.objects.OperationalAttributes;
import org.identityconnectors.framework.common.objects.ResultsHandler;
import org.identityconnectors.framework.common.objects.ScriptContext;
import org.identityconnectors.framework.common.objects.ScriptContextBuilder;
import org.identityconnectors.framework.common.objects.SyncDelta;
import org.identityconnectors.framework.common.objects.SyncResultsHandler;
import org.identityconnectors.framework.common.objects.SyncToken;
import org.identityconnectors.framework.common.objects.Uid;
import org.springframework.core.convert.converter.Converter;
import org.w3c.dom.Element;

public class IdentityConnectorService {
    private Trace logger = TraceManager.getTrace(IdentityConnectorService.class);

    public Uid doCreateConnectorObject(ConnectorFacade connector, ObjectClass objectClass, Set<Attribute> attrs, MidPointResult result) throws MidPointException {
        this.logger.debug("Entry Create Operation: {}", (Object)objectClass.getObjectClassValue());
        CreateApiOp createOp = this.createOperation(connector, CreateApiOp.class);
        Uid uid = createOp.create(objectClass, attrs, new OperationOptionsBuilder().build());
        this.logger.debug("Exit Create Operation: {}", (Object)uid.getUidValue());
        return uid;
    }

    public ConnectorObject doGetConnectorObject(ConnectorFacade connector, ObjectClass objectClass, Uid uid, Set<Attribute> attrsToGet, MidPointResult result) throws MidPointException {
        return this.createOperation(connector, GetApiOp.class).getObject(objectClass, uid, this.createOperationOptions(attrsToGet));
    }

    public Uid doModifyReplaceConnectorObject(ConnectorFacade connector, ObjectClass objectClass, Uid uid, Set<Attribute> attrs, MidPointResult result) throws MidPointException {
        UpdateApiOp updateOp = (UpdateApiOp)connector.getOperation(UpdateApiOp.class);
        return updateOp.update(objectClass, uid, attrs, new OperationOptionsBuilder().build());
    }

    public Uid doModifyAddConnectorObject(ConnectorFacade connector, ObjectClass objectClass, Uid uid, Set<Attribute> attrs, MidPointResult result) throws MidPointException {
        UpdateApiOp updateOp = (UpdateApiOp)connector.getOperation(UpdateApiOp.class);
        return updateOp.addAttributeValues(objectClass, uid, attrs, new OperationOptionsBuilder().build());
    }

    public Uid doModifyDeleteConnectorObject(ConnectorFacade connector, ObjectClass objectClass, Uid uid, Set<Attribute> attrs, MidPointResult result) throws MidPointException {
        UpdateApiOp updateOp = (UpdateApiOp)connector.getOperation(UpdateApiOp.class);
        return updateOp.removeAttributeValues(objectClass, uid, attrs, new OperationOptionsBuilder().build());
    }

    public void doDeleteConnectorObject(ConnectorFacade connector, ObjectClass objectClass, Uid uid, MidPointResult result) throws MidPointException {
        DeleteApiOp deleteOp = this.createOperation(connector, DeleteApiOp.class);
        deleteOp.delete(objectClass, uid, new OperationOptionsBuilder().build());
    }

    public Collection<ConnectorObject> doListAllConnectorObject(ConnectorFacade connector, ObjectClass objectClass, MidPointResult result) throws MidPointException {
        SearchApiOp op = this.createOperation(connector, SearchApiOp.class);
        final ArrayList<ConnectorObject> resultList = new ArrayList<ConnectorObject>();
        ResultsHandler handler = new ResultsHandler(){

            public boolean handle(ConnectorObject arg0) {
                return resultList.add(arg0);
            }
        };
        op.search(objectClass, null, handler, new OperationOptionsBuilder().build());
        return resultList;
    }

    public void doIterativeListAllConnectorObjects(ConnectorFacade connector, ObjectClass objectClass, MidPointResult result, ResultsHandler handler) throws MidPointException {
        SearchApiOp op = this.createOperation(connector, SearchApiOp.class);
        op.search(objectClass, null, handler, new OperationOptionsBuilder().build());
    }

    protected Collection<SyncDelta> doSyncronization(ConnectorFacade connector, ObjectClass objectClass, Object syncToken) {
        OperationOptionsBuilder oob = new OperationOptionsBuilder();
        final HashSet<SyncDelta> result = new HashSet<SyncDelta>();
        SyncApiOp syncOp = (SyncApiOp)connector.getOperation(SyncApiOp.class);
        syncOp.sync(objectClass, syncToken == null ? null : new SyncToken(syncToken), new SyncResultsHandler(){

            public boolean handle(SyncDelta sd) {
                result.add(sd);
                return true;
            }
        }, oob.build());
        return result;
    }

    public void doCreateAction(ResourceObjectShadowType shadow, String timing, ConnectorFacade connector, Set<Attribute> attrs, MidPointResult result) {
        String defExecMode = ConnectorUtil.getDefaultExecMode(connector);
        List<ConnectorScript> connScripts = ConnectorScriptBuilder.buildAll(null, shadow, defExecMode, "create", timing);
        if (connScripts != null && connScripts.size() > 0) {
            ConnectorScriptExecutor executor = new ConnectorScriptExecutor();
            for (ConnectorScript connScript : connScripts) {
                ScriptContextBuilder ctxBuilder = connScript.getScriptContextBuilder();
                OperationOptionsBuilder ooBuilder = connScript.getOperationOptionsBuilder();
                Object scriptResult = executor.execute(connector, connScript);
            }
        }
    }

    public void doExecuteScript(ConnectorFacade connector, ConnectorScript script, MidPointResult result) {
        ScriptContext ctxt = new ScriptContext(script.getScriptContextBuilder().getScriptLanguage(), script.getScriptContextBuilder().getScriptText(), script.getScriptContextBuilder().getScriptArguments());
        if ("connector".equals(script.getExecMode())) {
            ScriptOnConnectorApiOp scriptOnConnector = this.createOperation(connector, ScriptOnConnectorApiOp.class);
            scriptOnConnector.runScriptOnConnector(ctxt, new OperationOptionsBuilder().build());
        } else if ("resource".equals(script.getExecMode())) {
            ScriptOnResourceApiOp scriptOnResource = this.createOperation(connector, ScriptOnResourceApiOp.class);
            scriptOnResource.runScriptOnResource(ctxt, new OperationOptionsBuilder().build());
        }
    }

    private QName nameToQName(String name, String connectorNamespace) {
        return new QName(name, connectorNamespace);
    }

    public Set<Attribute> convertAnyElementsToConnectorAttributes(Map<String, Set<Element>> index) {
        HashSet<Attribute> attributes = new HashSet<Attribute>();
        this.logger.debug("[Provisioning] index = {}", index);
        for (String attributeName : index.keySet()) {
            this.logger.debug("[Provisioning] attributeName = {}", (Object)attributeName);
            ArrayList<Object> values = new ArrayList<Object>();
            for (Element e : index.get(attributeName)) {
                this.logger.debug("[Provisioning] index.get(attributeName) = {}", index.get(attributeName));
                this.logger.debug("[Provisioning] e.getTextContent() = {}", (Object)e.getTextContent());
                if (OperationalAttributes.PASSWORD_NAME.equals(attributeName)) {
                    Converter<String, GuardedString> converter = ICFConverterFactory.getInstance().getConverter(GuardedString.class, e.getTextContent());
                    values.add(converter.convert((Object)e.getTextContent()));
                    continue;
                }
                values.add(e.getTextContent());
            }
            Attribute a = AttributeBuilder.build((String)attributeName, values);
            attributes.add(a);
        }
        return attributes;
    }

    protected <T extends APIOperation> T createOperation(ConnectorFacade connector, Class<T> t) {
        APIOperation op = connector.getOperation(t);
        if (op == null) {
            throw new MidPointException("Unsupported opeation " + t + " on connector " + connector);
        }
        return (T)op;
    }

    protected OperationOptions createOperationOptions(Set<Attribute> attributes) {
        OperationOptionsBuilder oob = new OperationOptionsBuilder();
        OperationOptions operOpts = oob.build();
        return operOpts;
    }
}

