/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.provisioning.converter;

import com.evolveum.midpoint.annotations.CustomValueConverter;
import com.evolveum.midpoint.api.logging.Trace;
import com.evolveum.midpoint.logging.TraceManager;
import com.evolveum.midpoint.provisioning.converter.ConverterFactory;
import com.evolveum.midpoint.provisioning.converter.DefaultConverterFactory;
import com.evolveum.midpoint.provisioning.converter.NoSuchConverterException;
import com.evolveum.midpoint.provisioning.converter.Pair;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.scannotation.AnnotationDB;
import org.scannotation.ClasspathUrlFinder;
import org.springframework.core.convert.converter.Converter;

public class BasicConverterFactory
implements ConverterFactory {
    private static final Trace TRACE = TraceManager.getTrace(DefaultConverterFactory.class);
    private final Map<Pair<?, ?>, Converter<?, ?>> _converters = new HashMap();

    @Override
    public <S, T> Converter<S, T> getConverter(Class<T> targetClass, S value) {
        Pair<Class<?>, Class<T>> key;
        Converter<?, ?> converter;
        if (null != targetClass && null != value && null != (converter = this._converters.get(key = Pair.of(value.getClass(), targetClass)))) {
            return converter;
        }
        String msg = "There is no converter registered to " + (null != targetClass ? targetClass.getCanonicalName() : null) + " from " + null != value ? value.getClass().getCanonicalName() : "null";
        TRACE.error(msg);
        throw new NoSuchConverterException(msg);
    }

    public void addConverter(Pair of, Converter stringToIntegerConverter) {
        this._converters.put(of, stringToIntegerConverter);
    }

    @Deprecated
    public void scanForCustomValueConverter(Class location) {
        AnnotationDB db = new AnnotationDB();
        db.setScanClassAnnotations(true);
        db.setScanFieldAnnotations(false);
        db.setScanMethodAnnotations(false);
        db.setScanParameterAnnotations(false);
        try {
            URL url = ClasspathUrlFinder.findClassBase((Class)location);
            db.scanArchives(new URL[]{url});
        }
        catch (IOException ex) {
            throw new RuntimeException("Unable to scan for resources", ex);
        }
        Set classes = (Set)db.getAnnotationIndex().get(CustomValueConverter.class.getName());
        if (null != classes) {
            for (String className : classes) {
                try {
                    Class<?> clazz = Class.forName(className);
                    if (!Converter.class.isAssignableFrom(clazz)) continue;
                    Converter converter = (Converter)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                    this.registerConverter(converter);
                }
                catch (NoSuchMethodException ex) {
                    TRACE.error("Unable to register CustomValueConverter for class: {}", (Object)className, (Object)ex);
                }
                catch (SecurityException ex) {
                    TRACE.error("Unable to register CustomValueConverter for class: {}", (Object)className, (Object)ex);
                }
                catch (ClassNotFoundException ex) {
                    TRACE.error("Unable to load class: {}", (Object)className, (Object)ex);
                }
                catch (InstantiationException ex) {
                    TRACE.error("Unable to register CustomValueConverter for class: {}", (Object)className, (Object)ex);
                }
                catch (IllegalAccessException ex) {
                    TRACE.error("Unable to register CustomValueConverter for class: {}", (Object)className, (Object)ex);
                }
                catch (IllegalArgumentException ex) {
                    TRACE.error("Unable to register CustomValueConverter for class: {}", (Object)className, (Object)ex);
                }
                catch (InvocationTargetException ex) {
                    TRACE.error("Unable to register CustomValueConverter for class: {}", (Object)className, (Object)ex);
                }
            }
        }
    }

    public <F, S> boolean registerConverter(Converter<F, S> converter) {
        if (null != converter) {
            Type[] o = converter.getClass().getGenericInterfaces();
            for (int i = 0; i < o.length; ++i) {
                Class second;
                ParameterizedType t;
                if (!(o[i] instanceof ParameterizedType) || !Converter.class.equals((Object)((Class)(t = (ParameterizedType)o[i]).getRawType()))) continue;
                Class first = (Class)t.getActualTypeArguments()[0];
                Pair<Class, Class> key = Pair.of(first, second = (Class)t.getActualTypeArguments()[1]);
                if (null != this._converters.get(key)) break;
                TRACE.debug("Type converter registered: {} to {}", (Object)first, (Object)second);
                return null != this._converters.put(key, converter);
            }
        }
        return false;
    }
}

