/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.provisioning.conversion;

import com.evolveum.midpoint.provisioning.conversion.Converter;
import com.evolveum.midpoint.util.DOMUtil;
import com.evolveum.midpoint.xml.common.Pair;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.commons.lang.Validate;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SyncTokenConverter
implements Converter {
    private static final String PREFIX = "xsd";
    private static final Map<QName, Class> map = new HashMap<QName, Class>();
    private static final Collection types;

    @Override
    public QName getXmlType() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Collection<Class> getJavaTypes() {
        return types;
    }

    @Override
    public Object convertToJava(Node node) {
        Validate.notNull((Object)node, (String)"Couldn't convert null node.");
        if (node.getNodeType() != 1) {
            throw new IllegalArgumentException("Node '" + node.getLocalName() + "' is not element.");
        }
        Element element = (Element)node;
        String type = element.getAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "type");
        QName qname = this.createQName(element, type);
        Class clazz = map.get(qname);
        if (clazz == null) {
            throw new IllegalArgumentException("Can't convert node of type '" + type + "', unsupported.");
        }
        try {
            Constructor constructor = clazz.getConstructor(String.class);
            return constructor.newInstance(element.getTextContent());
        }
        catch (Exception ex) {
            throw new UnsupportedOperationException("Couldn't convert node '" + node.getLocalName() + "', reason: couldn't create instance of class '" + clazz.getName() + "', reason: " + ex.getMessage());
        }
    }

    @Override
    public Node convertToXML(QName name, Object o) {
        Validate.notNull((Object)o, (String)"Couldn't convert. Object can't be null");
        Validate.notNull((Object)name, (String)"Couldn't convert. QName can't be null.");
        Document document = DOMUtil.getDocument();
        Element syncToken = null;
        syncToken = name.getNamespaceURI() != null && name.getPrefix() != null ? document.createElementNS(name.getNamespaceURI(), name.getPrefix() + ":" + name.getLocalPart()) : document.createElement(name.getLocalPart());
        Pair<String, String> pair = this.convertObject(o);
        if (pair == null) {
            throw new IllegalArgumentException("Couldn't transform object '" + o + "', unknown type.");
        }
        syncToken.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:type", (String)pair.getFirst());
        syncToken.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsd", "http://www.w3.org/2001/XMLSchema");
        syncToken.setTextContent((String)pair.getSecond());
        return syncToken;
    }

    private QName createQName(Element element, String type) {
        String namespace = null;
        String localName = null;
        int index = type.indexOf(":");
        if (index == -1) {
            namespace = element.getNamespaceURI();
            localName = type;
        } else {
            namespace = element.lookupNamespaceURI(type.substring(0, index));
            localName = type.substring(index + 1);
        }
        return new QName(namespace, localName);
    }

    private Pair<String, String> convertObject(Object o) {
        Set<Map.Entry<QName, Class>> set = map.entrySet();
        for (Map.Entry<QName, Class> entry : set) {
            if (!entry.getValue().equals(o.getClass())) continue;
            return new Pair((Object)("xsd:" + entry.getKey().getLocalPart()), (Object)o.toString());
        }
        return null;
    }

    static {
        map.put(new QName("http://www.w3.org/2001/XMLSchema", "string"), String.class);
        map.put(new QName("http://www.w3.org/2001/XMLSchema", "integer"), Integer.class);
        map.put(new QName("http://www.w3.org/2001/XMLSchema", "double"), Double.class);
        map.put(new QName("http://www.w3.org/2001/XMLSchema", "boolean"), Boolean.class);
        map.put(new QName("http://www.w3.org/2001/XMLSchema", "float"), Float.class);
        map.put(new QName("http://www.w3.org/2001/XMLSchema", "long"), Long.class);
        map.put(new QName("http://www.w3.org/2001/XMLSchema", "short"), Short.class);
        types = map.values();
    }
}

