/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.provisioning.conversion;

import com.evolveum.midpoint.api.exceptions.MidPointException;
import com.evolveum.midpoint.provisioning.conversion.Converter;
import com.evolveum.midpoint.provisioning.util.ShadowUtil;
import java.util.Arrays;
import java.util.Collection;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class JAXBConverter
implements Converter {
    private Document d;
    private JAXBContext context;
    private Class type;
    private String namespace;

    public JAXBConverter(String namespace, Class type) {
        this.namespace = namespace;
        this.type = type;
        try {
            this.d = ShadowUtil.getXmlDocument();
            this.context = JAXBContext.newInstance((Class[])new Class[]{type, Container.class});
        }
        catch (JAXBException ex) {
            throw new MidPointException("Error on creating JAXBContext", (Throwable)ex);
        }
    }

    @Override
    public QName getXmlType() {
        return new QName(this.namespace, this.type.getSimpleName());
    }

    @Override
    public Collection<Class> getJavaTypes() {
        return Arrays.asList(this.type);
    }

    @Override
    public Object convertToJava(Node node) {
        try {
            Object o = this.context.createUnmarshaller().unmarshal(node);
            if (o instanceof JAXBElement) {
                return ((JAXBElement)o).getValue();
            }
            return o;
        }
        catch (JAXBException ex) {
            throw new MidPointException("Error on convertion object " + node, (Throwable)ex);
        }
    }

    @Override
    public Node convertToXML(QName name, Object o) {
        try {
            Element n = this.d.createElement("container");
            this.context.createMarshaller().marshal((Object)new Container(o), (Node)n);
            return n.getFirstChild().getFirstChild();
        }
        catch (JAXBException ex) {
            throw new MidPointException("Error on convertion object " + o, (Throwable)ex);
        }
    }

    @XmlRootElement
    public static class Container {
        private Object child;

        public Container() {
        }

        public Container(Object child) {
            this.child = child;
        }

        public Object getChild() {
            return this.child;
        }

        public void setChild(Object child) {
            this.child = child;
        }
    }
}

