/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.common.objects;

import java.util.LinkedHashMap;
import java.util.Map;
import org.identityconnectors.common.CollectionUtil;
import org.identityconnectors.framework.common.serializer.SerializerUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ScriptContext {
    private final String _scriptLanguage;
    private final String _scriptText;
    private final Map<String, Object> _scriptArguments;

    public ScriptContext(String scriptLanguage, String scriptText, Map<String, Object> scriptArguments) {
        if (scriptLanguage == null) {
            throw new IllegalArgumentException("Argument 'scriptLanguage' must be specified");
        }
        if (scriptText == null) {
            throw new IllegalArgumentException("Argument 'scriptText' must be specified");
        }
        Map scriptArgumentsClone = (Map)SerializerUtil.cloneObject(scriptArguments);
        this._scriptLanguage = scriptLanguage;
        this._scriptText = scriptText;
        this._scriptArguments = CollectionUtil.asReadOnlyMap(scriptArgumentsClone);
    }

    public String getScriptLanguage() {
        return this._scriptLanguage;
    }

    public String getScriptText() {
        return this._scriptText;
    }

    public Map<String, Object> getScriptArguments() {
        return this._scriptArguments;
    }

    public String toString() {
        StringBuilder bld = new StringBuilder();
        bld.append("ScriptContext: ");
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("Languge", this.getScriptLanguage());
        map.put("Text", this.getScriptText());
        map.put("Arguments", this.getScriptArguments());
        bld.append(((Object)map).toString());
        return bld.toString();
    }
}

