/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.db2;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import org.identityconnectors.common.IOUtil;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.db2.DB2AuthorityTable;
import org.identityconnectors.db2.DB2Configuration;
import org.identityconnectors.db2.Type2ConnectionInfo;
import org.identityconnectors.db2.Type4ConnectionInfo;
import org.identityconnectors.dbcommon.SQLUtil;
import org.identityconnectors.framework.common.exceptions.ConnectorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class DB2Specifics {
    static final String JCC_DRIVER = "com.ibm.db2.jcc.DB2Driver";
    static final String CLI_LEGACY_DRIVER = "COM.ibm.db2.jdbc.app.DB2Driver";
    static final String DEFAULT_TYPE4_PORT = "50000";
    static final int MAX_NAME_SIZE = 30;
    private static final Collection<String> excludedNamePrefixes = Arrays.asList("SQL", "SYS", "IBM");
    static final String AUTH_TYPE_DATABASE = "database";
    static final String AUTH_TYPE_INDEX = "index";
    static final String AUTH_TYPE_PACKAGE = "package";
    static final String AUTH_TYPE_SCHEMA = "schema";
    static final String AUTH_TYPE_SERVER = "server";
    static final String AUTH_TYPE_TABLE = "table";
    static final String AUTH_TYPE_TABLESPACE = "tablespace";
    private static final Map<String, DB2AuthorityTable> databaseAuthTableMap = new HashMap<String, DB2AuthorityTable>();
    private static volatile Collection<String> excludeNames;

    private DB2Specifics() {
    }

    static DB2AuthorityTable authType2DB2AuthorityTable(String authType) {
        return databaseAuthTableMap.get(authType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Collection<String> readExcludeNames() {
        if (excludeNames != null) return excludeNames;
        Class<DB2Configuration> clazz = DB2Configuration.class;
        synchronized (DB2Configuration.class) {
            if (excludeNames != null) return excludeNames;
            String names = IOUtil.getResourceAsString(DB2Configuration.class, (String)"exclude.names");
            if (names == null) {
                throw new IllegalStateException("Cannot load exclude names for DB2 connector");
            }
            excludeNames = new HashSet<String>();
            StringTokenizer tokenizer = new StringTokenizer(names, ",\n", false);
            while (tokenizer.hasMoreTokens()) {
                excludeNames.add(tokenizer.nextToken());
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return excludeNames;
        }
    }

    static Collection<String> getExcludeNames() {
        return Collections.unmodifiableCollection(DB2Specifics.readExcludeNames());
    }

    static Collection<String> getExcludedNamePrefixes() {
        return Collections.unmodifiableCollection(excludedNamePrefixes);
    }

    static boolean isReservedName(String name) {
        return DB2Specifics.getExcludeNames().contains(name) || DB2Specifics.includesPrefix(name, excludedNamePrefixes);
    }

    private static boolean includesPrefix(String target, Collection<String> prefixes) {
        for (String prefix : prefixes) {
            if (!target.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    static boolean containsIllegalDB2Chars(char[] target) {
        for (int i = 0; i < target.length; ++i) {
            boolean charOk;
            char c = target[i];
            boolean bl = charOk = c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '@' || c == '#' || c == '$';
            if (charOk) continue;
            return true;
        }
        return false;
    }

    static void testConnection(Connection connection, String testSQL) {
        PreparedStatement st = null;
        ResultSet rs = null;
        try {
            st = connection.prepareStatement(testSQL);
            rs = st.executeQuery();
        }
        catch (SQLException e) {
            try {
                if ("08001".equals(e.getSQLState()) && -4499 == e.getErrorCode()) {
                    throw new IllegalStateException("DB2 connection is stale", e);
                }
                throw new IllegalStateException("Unknown DB2 error while testing connection " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                SQLUtil.closeQuietly(rs);
                SQLUtil.closeQuietly((Statement)st);
                throw throwable;
            }
        }
        SQLUtil.closeQuietly((ResultSet)rs);
        SQLUtil.closeQuietly((Statement)st);
    }

    static String findTestSQL(Connection connection) {
        String s;
        String[] testSQL = new String[]{"select 1 from sysibm.dual", "select 1 from sysibm.SYSDUMMY1", "select 1 from syscat.SCHEMATA where schemaname = 'DUMMY'"};
        Statement st = null;
        String sql = null;
        try {
            st = connection.createStatement();
        }
        catch (SQLException e) {
            throw new IllegalStateException("Cannot create statement", e);
        }
        String[] arr$ = testSQL;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && (sql = DB2Specifics.testTestSQL(st, s = arr$[i$])) == null; ++i$) {
        }
        SQLUtil.closeQuietly((Statement)st);
        if (sql == null) {
            throw new ConnectorException("Cannot find valid test SQL for DB2");
        }
        return sql;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String testTestSQL(Statement st, String sql) {
        ResultSet rs = null;
        try {
            rs = st.executeQuery(sql);
            String string = sql;
            return string;
        }
        catch (SQLException e) {
            String string = null;
            return string;
        }
        finally {
            SQLUtil.closeQuietly((ResultSet)rs);
        }
    }

    static Connection createType4Connection(Type4ConnectionInfo info) {
        StringBuilder urlBuilder = new StringBuilder();
        urlBuilder.append("jdbc:").append(info.getSubprotocol());
        if (info.getHost() != null && info.getHost().length() > 0) {
            urlBuilder.append("://").append(info.getHost());
        }
        if (info.getPort() != null) {
            urlBuilder.append(":").append(info.getPort());
        }
        urlBuilder.append("/").append(info.getDatabase());
        return SQLUtil.getDriverMangerConnection((String)info.getDriver(), (String)urlBuilder.toString(), (String)info.getUser(), (GuardedString)info.getPassword());
    }

    static Connection createType2Connection(Type2ConnectionInfo info) {
        StringBuilder urlBuilder = new StringBuilder();
        urlBuilder.append("jdbc:").append(info.getSubprotocol()).append(':');
        urlBuilder.append(info.getAliasName());
        return SQLUtil.getDriverMangerConnection((String)info.getDriver(), (String)urlBuilder.toString(), (String)info.getUser(), (GuardedString)info.getPassword());
    }

    static Connection createDataSourceConnection(String dsName, Hashtable<?, ?> env) {
        return SQLUtil.getDatasourceConnection((String)dsName, env);
    }

    static Connection createDataSourceConnection(String dsName, String user, GuardedString password, Hashtable<?, ?> env) {
        return SQLUtil.getDatasourceConnection((String)dsName, (String)user, (GuardedString)password, env);
    }

    static boolean hasInvalidPrefix(String name) {
        char firstChar = name.charAt(0);
        if (Character.isDigit(firstChar)) {
            return true;
        }
        if ('.' == firstChar) {
            return true;
        }
        return ',' == firstChar;
    }

    static {
        databaseAuthTableMap.put(AUTH_TYPE_DATABASE, new DB2AuthorityTable("ON DATABASE"));
        databaseAuthTableMap.put(AUTH_TYPE_INDEX, new DB2AuthorityTable("ON INDEX"));
        databaseAuthTableMap.put(AUTH_TYPE_PACKAGE, new DB2AuthorityTable("ON PACKAGE"));
        databaseAuthTableMap.put(AUTH_TYPE_SCHEMA, new DB2AuthorityTable("ON SCHEMA"));
        databaseAuthTableMap.put(AUTH_TYPE_SERVER, new DB2AuthorityTable("ON SERVER"));
        databaseAuthTableMap.put(AUTH_TYPE_TABLESPACE, new DB2AuthorityTable("OF TABLESPACE"));
        databaseAuthTableMap.put(AUTH_TYPE_TABLE, new DB2AuthorityTable("ON"));
    }
}

