/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.db2;

import java.util.ArrayList;
import java.util.List;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.db2.DB2Configuration;
import org.identityconnectors.dbcommon.LocalizedAssert;
import org.identityconnectors.framework.common.exceptions.ConnectorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DB2ConfigurationValidator {
    private DB2Configuration cfg;
    private LocalizedAssert asserts;
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");

    DB2ConfigurationValidator(DB2Configuration cfg) {
        this.cfg = cfg;
        this.asserts = new LocalizedAssert(cfg.getConnectorMessages(), true);
    }

    private void runCheck(List<RuntimeException> reqEx, ConfigChecker reqChecker, ConfigChecker ... emptyCheckers) {
        if (this.cfg.getConnType() != null) {
            return;
        }
        try {
            reqChecker.checkRequired();
            this.cfg.setConnType(reqChecker.getType());
        }
        catch (RuntimeException e) {
            reqEx.add(e);
        }
        if (this.cfg.getConnType() != null) {
            for (ConfigChecker emptyChecker : emptyCheckers) {
                emptyChecker.checkEmpty(reqChecker);
            }
        }
    }

    void validate() {
        ArrayList<RuntimeException> reqChecksEx = new ArrayList<RuntimeException>(2);
        this.runCheck(reqChecksEx, new DataSourceChecker(), new URLChecker(), new Type4DriverChecker(), new Type2DriverChecker());
        this.runCheck(reqChecksEx, new URLChecker(), new DataSourceChecker(), new Type4DriverChecker(), new Type2DriverChecker());
        this.runCheck(reqChecksEx, new Type4DriverChecker(), new DataSourceChecker(), new URLChecker(), new Type2DriverChecker());
        this.runCheck(reqChecksEx, new Type2DriverChecker(), new DataSourceChecker(), new URLChecker(), new Type4DriverChecker());
        if (this.cfg.getConnType() == null) {
            StringBuilder stackBuilder = new StringBuilder();
            StringBuilder msgBuilder = new StringBuilder();
            stackBuilder.append(LINE_SEPARATOR);
            for (RuntimeException ex : reqChecksEx) {
                stackBuilder.append(LINE_SEPARATOR);
                stackBuilder.append(ex.getMessage());
                stackBuilder.append(LINE_SEPARATOR);
                if (msgBuilder.length() > 0) {
                    msgBuilder.append(" | ");
                }
                msgBuilder.append(ex.getMessage());
                for (StackTraceElement el : ex.getStackTrace()) {
                    stackBuilder.append(el);
                    stackBuilder.append(LINE_SEPARATOR);
                }
            }
            ConnectorException connectorException = new ConnectorException(this.cfg.getConnectorMessages().format("db2.validate.fail", null, new Object[]{msgBuilder}), (Throwable)new Exception(stackBuilder.toString()));
            throw connectorException;
        }
        if (this.cfg.getPort() != null) {
            Integer.parseInt(this.cfg.getPort());
        }
    }

    private class Type2DriverChecker
    implements ConfigChecker {
        private Type2DriverChecker() {
        }

        public void checkRequired() {
            DB2ConfigurationValidator.this.asserts.assertNotBlank(DB2ConfigurationValidator.this.cfg.getDatabaseName(), "db2.databaseName.display");
            DB2ConfigurationValidator.this.asserts.assertNotBlank(DB2ConfigurationValidator.this.cfg.getAdminAccount(), "db2.adminAccount.display");
            DB2ConfigurationValidator.this.asserts.assertNotNull((Object)DB2ConfigurationValidator.this.cfg.getAdminPassword(), "db2.adminPassword.display");
            DB2ConfigurationValidator.this.asserts.assertNotBlank(DB2ConfigurationValidator.this.cfg.getJdbcDriver(), "db2.jdbcDriver.display");
            DB2ConfigurationValidator.this.asserts.assertNotBlank(DB2ConfigurationValidator.this.cfg.getJdbcSubProtocol(), "db2.jdbcSubProtocol.display");
            try {
                Class.forName(DB2ConfigurationValidator.this.cfg.getJdbcDriver());
            }
            catch (ClassNotFoundException e) {
                throw new ConnectorException(DB2ConfigurationValidator.this.cfg.getConnectorMessages().format("db2.jdbcDriverClassNotFound", null, new Object[]{DB2ConfigurationValidator.this.cfg.getJdbcDriver()}), (Throwable)e);
            }
        }

        public void checkEmpty(ConfigChecker reqChecker) {
            if (!(reqChecker instanceof Type4DriverChecker)) {
                DB2ConfigurationValidator.this.asserts.assertBlank(DB2ConfigurationValidator.this.cfg.getDatabaseName(), "db2.databaseName.display");
                DB2ConfigurationValidator.this.asserts.assertBlank(DB2ConfigurationValidator.this.cfg.getJdbcSubProtocol(), "db2.jdbcSubProtocol.display");
            }
            if (!(reqChecker instanceof Type4DriverChecker) && !(reqChecker instanceof URLChecker)) {
                DB2ConfigurationValidator.this.asserts.assertBlank(DB2ConfigurationValidator.this.cfg.getJdbcDriver(), "db2.jdbcDriver.display");
            }
        }

        public DB2Configuration.ConnectionType getType() {
            return DB2Configuration.ConnectionType.TYPE2;
        }
    }

    private class Type4DriverChecker
    implements ConfigChecker {
        private Type4DriverChecker() {
        }

        public void checkRequired() {
            DB2ConfigurationValidator.this.asserts.assertNotBlank(DB2ConfigurationValidator.this.cfg.getHost(), "db2.host.display");
            DB2ConfigurationValidator.this.asserts.assertNotBlank(DB2ConfigurationValidator.this.cfg.getPort(), "db2.port.display");
            DB2ConfigurationValidator.this.asserts.assertNotBlank(DB2ConfigurationValidator.this.cfg.getAdminAccount(), "db2.adminAccount.display");
            DB2ConfigurationValidator.this.asserts.assertNotNull((Object)DB2ConfigurationValidator.this.cfg.getAdminPassword(), "db2.adminPassword.display");
            DB2ConfigurationValidator.this.asserts.assertNotBlank(DB2ConfigurationValidator.this.cfg.getJdbcDriver(), "db2.jdbcDriver.display");
            DB2ConfigurationValidator.this.asserts.assertNotBlank(DB2ConfigurationValidator.this.cfg.getDatabaseName(), "db2.databaseName.display");
            DB2ConfigurationValidator.this.asserts.assertNotBlank(DB2ConfigurationValidator.this.cfg.getJdbcSubProtocol(), "db2.jdbcSubProtocol.display");
            try {
                Class.forName(DB2ConfigurationValidator.this.cfg.getJdbcDriver());
            }
            catch (ClassNotFoundException e) {
                throw new ConnectorException(DB2ConfigurationValidator.this.cfg.getConnectorMessages().format("db2.jdbcDriverClassNotFound", null, new Object[]{DB2ConfigurationValidator.this.cfg.getJdbcDriver()}), (Throwable)e);
            }
        }

        public void checkEmpty(ConfigChecker reqChecker) {
            if (!(reqChecker instanceof Type2DriverChecker)) {
                DB2ConfigurationValidator.this.asserts.assertBlank(DB2ConfigurationValidator.this.cfg.getDatabaseName(), "db2.databaseName.display");
                DB2ConfigurationValidator.this.asserts.assertBlank(DB2ConfigurationValidator.this.cfg.getJdbcSubProtocol(), "db2.jdbcSubProtocol.display");
            }
            if (!(reqChecker instanceof Type2DriverChecker) && !(reqChecker instanceof URLChecker)) {
                DB2ConfigurationValidator.this.asserts.assertBlank(DB2ConfigurationValidator.this.cfg.getJdbcDriver(), "db2.jdbcDriver.display");
            }
            DB2ConfigurationValidator.this.asserts.assertBlank(DB2ConfigurationValidator.this.cfg.getHost(), "db2.host.display");
            DB2ConfigurationValidator.this.asserts.assertBlank(DB2ConfigurationValidator.this.cfg.getPort(), "db2.port.display");
        }

        public DB2Configuration.ConnectionType getType() {
            return DB2Configuration.ConnectionType.TYPE4;
        }
    }

    private class URLChecker
    implements ConfigChecker {
        private URLChecker() {
        }

        public void checkRequired() {
            DB2ConfigurationValidator.this.asserts.assertNotBlank(DB2ConfigurationValidator.this.cfg.getUrl(), "db2.url.display");
            DB2ConfigurationValidator.this.asserts.assertNotBlank(DB2ConfigurationValidator.this.cfg.getAdminAccount(), "db2.adminAccount.display");
            DB2ConfigurationValidator.this.asserts.assertNotNull((Object)DB2ConfigurationValidator.this.cfg.getAdminPassword(), "db2.adminPassword.display");
            DB2ConfigurationValidator.this.asserts.assertNotBlank(DB2ConfigurationValidator.this.cfg.getJdbcDriver(), "db2.jdbcDriver.display");
            try {
                Class.forName(DB2ConfigurationValidator.this.cfg.getJdbcDriver());
            }
            catch (ClassNotFoundException e) {
                throw new ConnectorException(DB2ConfigurationValidator.this.cfg.getConnectorMessages().format("db2.jdbcDriverClassNotFound", null, new Object[]{DB2ConfigurationValidator.this.cfg.getJdbcDriver()}), (Throwable)e);
            }
        }

        public void checkEmpty(ConfigChecker reqChecker) {
            DB2ConfigurationValidator.this.asserts.assertBlank(DB2ConfigurationValidator.this.cfg.getUrl(), "db2.url.display");
            if (!(reqChecker instanceof Type4DriverChecker) && !(reqChecker instanceof Type2DriverChecker)) {
                DB2ConfigurationValidator.this.asserts.assertBlank(DB2ConfigurationValidator.this.cfg.getJdbcDriver(), "db2.jdbcDriver.display");
            }
        }

        public DB2Configuration.ConnectionType getType() {
            return DB2Configuration.ConnectionType.URL;
        }
    }

    private class DataSourceChecker
    implements ConfigChecker {
        public void checkRequired() {
            DB2ConfigurationValidator.this.asserts.assertNotBlank(DB2ConfigurationValidator.this.cfg.getDataSource(), "db2.dataSource.display");
            if (StringUtil.isNotEmpty((String)DB2ConfigurationValidator.this.cfg.getAdminAccount())) {
                DB2ConfigurationValidator.this.asserts.assertNotNull((Object)DB2ConfigurationValidator.this.cfg.getAdminPassword(), "db2.adminAccount.display");
            }
        }

        public void checkEmpty(ConfigChecker reqChecker) {
            DB2ConfigurationValidator.this.asserts.assertBlank(DB2ConfigurationValidator.this.cfg.getDataSource(), "db2.dataSource.display");
        }

        public DB2Configuration.ConnectionType getType() {
            return DB2Configuration.ConnectionType.DATASOURCE;
        }

        DataSourceChecker() {
        }
    }

    private static interface ConfigChecker {
        public void checkRequired();

        public void checkEmpty(ConfigChecker var1);

        public DB2Configuration.ConnectionType getType();
    }
}

