/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.db2;

import java.sql.Connection;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.db2.DB2ConfigurationValidator;
import org.identityconnectors.db2.DB2Specifics;
import org.identityconnectors.db2.Type2ConnectionInfo;
import org.identityconnectors.db2.Type4ConnectionInfo;
import org.identityconnectors.dbcommon.JNDIUtil;
import org.identityconnectors.dbcommon.SQLUtil;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.common.objects.ConnectorMessages;
import org.identityconnectors.framework.spi.AbstractConfiguration;
import org.identityconnectors.framework.spi.ConfigurationProperty;

public class DB2Configuration
extends AbstractConfiguration
implements Cloneable {
    private String adminAccount;
    private GuardedString adminPassword;
    private String jdbcSubProtocol = "db2";
    private String databaseName;
    private String dataSource;
    private String jdbcDriver = "com.ibm.db2.jcc.DB2Driver";
    private String host;
    private String port = "50000";
    private ConnectionType connType;
    private String[] dsJNDIEnv;
    private boolean replaceAllGrantsOnUpdate = true;
    private String url;

    public DB2Configuration clone() throws ConnectorException {
        try {
            return (DB2Configuration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new ConnectorException("Clone of DB2Configuration super class failed", (Throwable)e);
        }
    }

    @ConfigurationProperty(order=0, displayMessageKey="db2.adminAccount.display", helpMessageKey="db2.adminAccount.help")
    public String getAdminAccount() {
        return this.adminAccount;
    }

    public void setAdminAccount(String account) {
        this.adminAccount = account;
    }

    @ConfigurationProperty(order=1, displayMessageKey="db2.adminPassword.display", helpMessageKey="db2.adminPassword.help", confidential=true)
    public GuardedString getAdminPassword() {
        return this.adminPassword;
    }

    public void setAdminPassword(GuardedString adminPassword) {
        this.adminPassword = adminPassword;
    }

    @ConfigurationProperty(order=2, displayMessageKey="db2.jdbcSubProtocol.display", helpMessageKey="db2.jdbcSubProtocol.help")
    public String getJdbcSubProtocol() {
        return this.jdbcSubProtocol;
    }

    @ConfigurationProperty(order=3, displayMessageKey="db2.databaseName.display", helpMessageKey="db2.databaseName.help")
    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setJdbcSubProtocol(String subProtocol) {
        this.jdbcSubProtocol = subProtocol;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    @ConfigurationProperty(order=4, displayMessageKey="db2.jdbcDriver.display", helpMessageKey="db2.jdbcDriver.help")
    public String getJdbcDriver() {
        return this.jdbcDriver;
    }

    public void setJdbcDriver(String jdbcDriver) {
        this.jdbcDriver = jdbcDriver;
    }

    @ConfigurationProperty(order=5, displayMessageKey="db2.host.display", helpMessageKey="db2.host.help")
    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    @ConfigurationProperty(order=6, displayMessageKey="db2.port.display", helpMessageKey="db2.port.help")
    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    @ConfigurationProperty(order=7, displayMessageKey="db2.url.display", helpMessageKey="db2.url.help")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    @ConfigurationProperty(order=8, displayMessageKey="db2.dataSource.display", helpMessageKey="db2.dataSource.help")
    public String getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(String dataSource) {
        this.dataSource = dataSource;
    }

    @ConfigurationProperty(order=9, displayMessageKey="db2.dsJNDIEnv.display", helpMessageKey="db2.dsJNDIEnv.help")
    public String[] getDsJNDIEnv() {
        if (this.dsJNDIEnv == null) {
            return new String[0];
        }
        String[] res = new String[this.dsJNDIEnv.length];
        System.arraycopy(this.dsJNDIEnv, 0, res, 0, this.dsJNDIEnv.length);
        return res;
    }

    public void setDsJNDIEnv(String[] dsJNDIEnv) {
        if (dsJNDIEnv == null) {
            this.dsJNDIEnv = null;
        } else {
            this.dsJNDIEnv = new String[dsJNDIEnv.length];
            System.arraycopy(dsJNDIEnv, 0, this.dsJNDIEnv, 0, dsJNDIEnv.length);
        }
    }

    @ConfigurationProperty(order=10, displayMessageKey="db2.replaceAllGrantsOnUpdate.display", helpMessageKey="db2.replaceAllGrantsOnUpdate.help")
    public boolean isReplaceAllGrantsOnUpdate() {
        return this.replaceAllGrantsOnUpdate;
    }

    public void setReplaceAllGrantsOnUpdate(boolean replaceAllGrantsOnUpdate) {
        this.replaceAllGrantsOnUpdate = replaceAllGrantsOnUpdate;
    }

    ConnectionType getConnType() {
        return this.connType;
    }

    void setConnType(ConnectionType connType) {
        this.connType = connType;
    }

    public void validate() {
        this.setConnType(null);
        new DB2ConfigurationValidator(this).validate();
    }

    Connection createAdminConnection() {
        return this.createConnection(this.adminAccount, this.adminPassword);
    }

    Connection createConnection(String user, GuardedString password) {
        this.validate();
        if (ConnectionType.DATASOURCE.equals((Object)this.connType)) {
            if (user != null) {
                return DB2Specifics.createDataSourceConnection(this.dataSource, user, password, JNDIUtil.arrayToHashtable((String[])this.dsJNDIEnv, (ConnectorMessages)this.getConnectorMessages()));
            }
            return DB2Specifics.createDataSourceConnection(this.dataSource, JNDIUtil.arrayToHashtable((String[])this.dsJNDIEnv, (ConnectorMessages)this.getConnectorMessages()));
        }
        if (ConnectionType.TYPE4.equals((Object)this.connType)) {
            return DB2Specifics.createType4Connection(new Type4ConnectionInfo.Type4ConnectionInfoBuilder().setDriver(this.jdbcDriver).setHost(this.host).setPort(this.port).setSubprotocol(this.jdbcSubProtocol).setDatabase(this.databaseName).setUser(user).setPassword(password).build());
        }
        if (ConnectionType.TYPE2.equals((Object)this.connType)) {
            return DB2Specifics.createType2Connection(new Type2ConnectionInfo.Type2ConnectionInfoBuilder().setDriver(this.jdbcDriver).setAliasName(this.databaseName).setSubprotocol(this.jdbcSubProtocol).setUser(user).setPassword(password).build());
        }
        if (ConnectionType.URL.equals((Object)this.connType)) {
            return SQLUtil.getDriverMangerConnection((String)this.jdbcDriver, (String)this.url, (String)user, (GuardedString)password);
        }
        throw new IllegalStateException("Invalid state of DB2Configuration");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ConnectionType {
        DATASOURCE,
        TYPE4,
        TYPE2,
        URL;

    }
}

