/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.db2;

import com.sun.rowset.CachedRowSetImpl;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import org.identityconnectors.common.Assertions;
import org.identityconnectors.db2.DB2Authority;
import org.identityconnectors.dbcommon.SQLUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DB2AuthorityReader {
    private Connection conn;

    DB2AuthorityReader(Connection adminConn) {
        Assertions.nullCheck((Object)adminConn, (String)"adminConn");
        this.conn = adminConn;
    }

    Collection<DB2Authority> readDatabaseAuthorities(String user) throws SQLException {
        String accountIDUC = user.toUpperCase();
        String sql = "SELECT * FROM SYSIBM.SYSDBAUTH WHERE GRANTEE = '" + accountIDUC + "' AND GRANTEETYPE = 'U'";
        ArrayList<DB2Authority> grants = new ArrayList<DB2Authority>();
        ResultSet rs = this.executeQuery(sql);
        while (rs.next()) {
            if (rs.getString("DBADMAUTH").equals("Y")) {
                grants.add(new DB2Authority("database", "DBADM", "", accountIDUC));
            }
            if (rs.getString("CREATETABAUTH").equals("Y")) {
                grants.add(new DB2Authority("database", "CREATETAB", "", accountIDUC));
            }
            if (rs.getString("BINDADDAUTH").equals("Y")) {
                grants.add(new DB2Authority("database", "BINDADD", "", accountIDUC));
            }
            if (rs.getString("CONNECTAUTH").equals("Y")) {
                grants.add(new DB2Authority("database", "CONNECT", "", accountIDUC));
            }
            if (rs.getString("NOFENCEAUTH").equals("Y")) {
                grants.add(new DB2Authority("database", "CREATE_NOT_FENCED", "", accountIDUC));
            }
            if (rs.getString("IMPLSCHEMAAUTH").equals("Y")) {
                grants.add(new DB2Authority("database", "IMPLICIT_SCHEMA", "", accountIDUC));
            }
            if (!rs.getString("LOADAUTH").equals("Y")) continue;
            grants.add(new DB2Authority("database", "LOAD", "", accountIDUC));
        }
        return grants;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultSet executeQuery(String sql) throws SQLException {
        CachedRowSetImpl cachedRowSetImpl;
        Statement statement = null;
        ResultSet rs = null;
        try {
            statement = this.conn.createStatement();
            rs = statement.executeQuery(sql);
            CachedRowSetImpl cr = new CachedRowSetImpl();
            cr.populate(rs);
            cachedRowSetImpl = cr;
        }
        catch (Throwable throwable) {
            SQLUtil.closeQuietly((Statement)statement);
            SQLUtil.closeQuietly(rs);
            throw throwable;
        }
        SQLUtil.closeQuietly((Statement)statement);
        SQLUtil.closeQuietly((ResultSet)rs);
        return cachedRowSetImpl;
    }

    Collection<DB2Authority> readAllAuthorities(String user) throws SQLException {
        ArrayList<DB2Authority> allAuths = new ArrayList<DB2Authority>();
        allAuths.addAll(this.readIndexAuthorities(user));
        allAuths.addAll(this.readSchemaAuthorities(user));
        allAuths.addAll(this.readServerAuthorities(user));
        allAuths.addAll(this.readTableAuthorities(user));
        allAuths.addAll(this.readTablespaceAuthorities(user));
        allAuths.addAll(this.readPackageAuthorities(user));
        allAuths.addAll(this.readDatabaseAuthorities(user));
        return allAuths;
    }

    Collection<DB2Authority> readIndexAuthorities(String user) throws SQLException {
        String accountIDUC = user.toUpperCase();
        String sql = "SELECT * FROM SYSIBM.SYSINDEXAUTH WHERE GRANTEE = '" + accountIDUC + "' AND GRANTEETYPE = 'U'";
        ArrayList<DB2Authority> grants = new ArrayList<DB2Authority>();
        ResultSet rs = this.executeQuery(sql);
        while (rs.next()) {
            if (!rs.getString("CONTROLAUTH").equals("Y")) continue;
            grants.add(new DB2Authority("index", "CONTROL", rs.getString("CREATOR").trim() + "." + rs.getString("NAME"), accountIDUC));
        }
        return grants;
    }

    Collection<DB2Authority> readPackageAuthorities(String user) throws SQLException {
        String accountIDUC = user.toUpperCase();
        String sql = "SELECT * FROM SYSIBM.SYSPLANAUTH WHERE GRANTEE = '" + accountIDUC + "' AND GRANTEETYPE = 'U'";
        ArrayList<DB2Authority> grants = new ArrayList<DB2Authority>();
        ResultSet rs = this.executeQuery(sql);
        while (rs.next()) {
            String creator = rs.getString("CREATOR").trim();
            String packageName = creator + "." + rs.getString("NAME");
            if (rs.getString("CONTROLAUTH").equals("Y")) {
                grants.add(new DB2Authority("package", "CONTROL", packageName, accountIDUC));
            }
            if (rs.getString("BINDAUTH").equals("Y")) {
                grants.add(new DB2Authority("package", "BIND", packageName, accountIDUC));
            }
            if (!rs.getString("EXECUTEAUTH").equals("Y")) continue;
            grants.add(new DB2Authority("package", "EXECUTE", packageName, accountIDUC));
        }
        return grants;
    }

    Collection<DB2Authority> readSchemaAuthorities(String user) throws SQLException {
        String accountIDUC = user.toUpperCase();
        String sql = "SELECT * FROM SYSIBM.SYSSCHEMAAUTH WHERE GRANTEE = '" + accountIDUC + "' AND GRANTEETYPE = 'U'";
        ArrayList<DB2Authority> grants = new ArrayList<DB2Authority>();
        ResultSet rs = this.executeQuery(sql);
        while (rs.next()) {
            if (rs.getString("CREATEINAUTH").equals("Y") || rs.getString("CREATEINAUTH").equals("G")) {
                grants.add(new DB2Authority("schema", "CREATEIN", rs.getString("SCHEMANAME"), accountIDUC));
            }
            if (rs.getString("ALTERINAUTH").equals("Y") || rs.getString("ALTERINAUTH").equals("G")) {
                grants.add(new DB2Authority("schema", "ALTERIN", rs.getString("SCHEMANAME"), accountIDUC));
            }
            if (!rs.getString("DROPINAUTH").equals("Y") && !rs.getString("DROPINAUTH").equals("G")) continue;
            grants.add(new DB2Authority("schema", "DROPIN", rs.getString("SCHEMANAME"), accountIDUC));
        }
        return grants;
    }

    Collection<DB2Authority> readServerAuthorities(String user) throws SQLException {
        String accountIDUC = user.toUpperCase();
        String sql = "SELECT * FROM SYSIBM.SYSPASSTHRUAUTH WHERE GRANTEE = '" + accountIDUC + "' AND GRANTEETYPE = 'U'";
        ArrayList<DB2Authority> grants = new ArrayList<DB2Authority>();
        ResultSet rs = this.executeQuery(sql);
        while (rs.next()) {
            grants.add(new DB2Authority("server", "PASSTHRU", rs.getString("SERVERNAME"), accountIDUC));
        }
        return grants;
    }

    Collection<DB2Authority> readTableAuthorities(String user) throws SQLException {
        String accountIDUC = user.toUpperCase();
        String sql = "SELECT * FROM SYSIBM.SYSTABAUTH WHERE GRANTEE = '" + accountIDUC + "' AND GRANTEETYPE = 'U'";
        ArrayList<DB2Authority> grants = new ArrayList<DB2Authority>();
        ResultSet rs = this.executeQuery(sql);
        while (rs.next()) {
            if (rs.getString("CONTROLAUTH").equals("Y")) {
                grants.add(new DB2Authority("table", "CONTROL", rs.getString("TCREATOR").trim() + "." + rs.getString("TTNAME").trim(), accountIDUC));
            }
            if (rs.getString("ALTERAUTH").equals("Y") || rs.getString("ALTERAUTH").equals("G")) {
                grants.add(new DB2Authority("table", "ALTER", rs.getString("TCREATOR").trim() + "." + rs.getString("TTNAME").trim(), accountIDUC));
            }
            if (rs.getString("DELETEAUTH").equals("Y") || rs.getString("DELETEAUTH").equals("G")) {
                grants.add(new DB2Authority("table", "DELETE", rs.getString("TCREATOR").trim() + "." + rs.getString("TTNAME").trim(), accountIDUC));
            }
            if (rs.getString("INDEXAUTH").equals("Y") || rs.getString("INDEXAUTH").equals("G")) {
                grants.add(new DB2Authority("table", "INDEX", rs.getString("TCREATOR").trim() + "." + rs.getString("TTNAME").trim(), accountIDUC));
            }
            if (rs.getString("INSERTAUTH").equals("Y") || rs.getString("INSERTAUTH").equals("G")) {
                grants.add(new DB2Authority("table", "INSERT", rs.getString("TCREATOR").trim() + "." + rs.getString("TTNAME").trim(), accountIDUC));
            }
            if (rs.getString("SELECTAUTH").equals("Y") || rs.getString("SELECTAUTH").equals("G")) {
                grants.add(new DB2Authority("table", "SELECT", rs.getString("TCREATOR").trim() + "." + rs.getString("TTNAME").trim(), accountIDUC));
            }
            if (rs.getString("UPDATEAUTH").equals("Y") || rs.getString("UPDATEAUTH").equals("G")) {
                grants.add(new DB2Authority("table", "UPDATE", rs.getString("TCREATOR").trim() + "." + rs.getString("TTNAME").trim(), accountIDUC));
            }
            if (!rs.getString("REFAUTH").equals("Y") && !rs.getString("REFAUTH").equals("G")) continue;
            grants.add(new DB2Authority("table", "REFERENCES", rs.getString("TCREATOR").trim() + "." + rs.getString("TTNAME").trim(), accountIDUC));
        }
        return grants;
    }

    Collection<DB2Authority> readTablespaceAuthorities(String user) throws SQLException {
        String accountIDUC = user.toUpperCase();
        String sql = "SELECT * FROM SYSIBM.SYSTBSPACEAUTH, SYSIBM.SYSTABLESPACES WHERE SYSIBM.SYSTBSPACEAUTH.GRANTEE = '" + accountIDUC + "' AND SYSIBM.SYSTBSPACEAUTH.GRANTEETYPE = 'U' " + "AND (SYSIBM.SYSTBSPACEAUTH.USEAUTH = 'Y' OR SYSIBM.SYSTBSPACEAUTH.USEAUTH = 'G') " + "AND SYSIBM.SYSTBSPACEAUTH.TBSPACEID = SYSIBM.SYSTABLESPACES.TBSPACEID";
        ArrayList<DB2Authority> grants = new ArrayList<DB2Authority>();
        ResultSet rs = this.executeQuery(sql);
        while (rs.next()) {
            grants.add(new DB2Authority("tablespace", "USE", rs.getString("TBSPACE"), accountIDUC));
        }
        return grants;
    }
}

