/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.xml.schema;

import com.evolveum.midpoint.xml.ns._public.common.common_1.AccountShadowType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ObjectReferenceType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.UserType;
import com.evolveum.midpoint.xml.schema.SchemaConstants;

public class UserTypeUtil {
    public static ObjectReferenceType findAccountRef(UserType user, String resourceOid) {
        ObjectReferenceType res = null;
        for (ObjectReferenceType ref : user.getAccountRef()) {
            if (!resourceOid.equals(ref.getOid())) continue;
            if (res == null) {
                res = ref;
                continue;
            }
            throw new IllegalStateException("User " + user.getOid() + " has more than one account for resource " + resourceOid);
        }
        for (AccountShadowType acc : user.getAccount()) {
            if (!resourceOid.equals(acc.getOid())) continue;
            if (res == null) {
                res = new ObjectReferenceType();
                res.setOid(resourceOid);
                res.setType(SchemaConstants.I_ACCOUNT_TYPE);
                continue;
            }
            throw new IllegalStateException("User " + user.getOid() + " has more than one account for resource " + resourceOid);
        }
        return res;
    }
}

