/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.schema.processor;

import com.evolveum.midpoint.api.logging.Trace;
import com.evolveum.midpoint.logging.TraceManager;
import java.text.MessageFormat;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SchemaErrorHandler
implements ErrorHandler {
    private static final Trace TRACE = TraceManager.getTrace(SchemaErrorHandler.class);

    @Override
    public void warning(SAXParseException e) throws SAXException {
        this.print("[Warning]", e);
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        this.print("[Error]", e);
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        this.print("[Fatal]", e);
    }

    private void print(String header, SAXParseException e) {
        StringBuilder builder = new StringBuilder();
        builder.append("Error occured during schema parsing: ");
        builder.append(header);
        builder.append(" ");
        builder.append(MessageFormat.format("on line {0} at {1}", Integer.toString(e.getLineNumber()), e.getSystemId()));
        builder.append(" ");
        builder.append(e.getMessage());
        TRACE.error(builder.toString());
        TRACE.trace(builder.toString(), (Throwable)e);
    }
}

