/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.repo.spring;

import com.evolveum.midpoint.model.IdentifiableBase;
import com.evolveum.midpoint.model.Property;
import com.evolveum.midpoint.model.SimpleDomainObject;
import com.evolveum.midpoint.repo.PagingRepositoryType;
import java.lang.reflect.ParameterizedType;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceException;
import javax.persistence.Query;
import org.springframework.orm.jpa.JpaCallback;
import org.springframework.orm.jpa.support.JpaDaoSupport;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public abstract class JpaDao<K, E extends SimpleDomainObject>
extends JpaDaoSupport {
    protected Class<E> entityClass;

    public JpaDao() {
        ParameterizedType genericSuperclass = (ParameterizedType)((Object)((Object)this)).getClass().getGenericSuperclass();
        this.entityClass = (Class)genericSuperclass.getActualTypeArguments()[1];
    }

    public void persist(E entity) {
        this.getJpaTemplate().persist(entity);
    }

    public void remove(E entity) {
        this.getJpaTemplate().remove(this.getJpaTemplate().getReference(entity.getClass(), (Object)((IdentifiableBase)entity).getOid()));
    }

    public E merge(E entity) {
        return (E)((SimpleDomainObject)this.getJpaTemplate().merge(entity));
    }

    public void refresh(E entity) {
        this.getJpaTemplate().refresh(entity);
    }

    public E findById(K id) {
        SimpleDomainObject entity = (SimpleDomainObject)this.getJpaTemplate().find(this.entityClass, id);
        if (null != entity && null != entity.getProperties()) {
            for (Property property : entity.getProperties()) {
                property.getPropertyName();
                property.getPropertyValue();
            }
        }
        return (E)entity;
    }

    public E flush(E entity) {
        this.getJpaTemplate().flush();
        return entity;
    }

    public List<E> findAllOfType(final String dtype) {
        Object res = this.getJpaTemplate().execute(new JpaCallback(){

            public Object doInJpa(EntityManager em) throws PersistenceException {
                Query q = em.createQuery("SELECT h FROM " + JpaDao.this.entityClass.getName() + " h where dtype = '" + dtype + "'");
                List entities = q.getResultList();
                for (SimpleDomainObject entity : entities) {
                    if (null == entity || null == entity.getProperties()) continue;
                    for (Property property : entity.getProperties()) {
                        property.getPropertyName();
                        property.getPropertyValue();
                    }
                }
                return entities;
            }
        });
        return (List)res;
    }

    public List<E> findRangeUsers(final String dtype, final PagingRepositoryType paging) {
        Object res = this.getJpaTemplate().execute(new JpaCallback(){

            public Object doInJpa(EntityManager em) throws PersistenceException {
                if (paging.getOffset() == -1) {
                    Query g = em.createQuery("SELECT count(*) FROM " + JpaDao.this.entityClass.getName() + " h where dtype = '" + dtype + "'");
                    List resultSet = g.getResultList();
                    if (resultSet != null && resultSet.size() > 0) {
                        Long recordCount = (Long)resultSet.get(0);
                        paging.setOffset(recordCount.intValue() - recordCount.intValue() % paging.getMaxSize());
                    }
                    System.out.println("offset " + paging.getOffset());
                }
                Query q = em.createQuery("SELECT h FROM " + JpaDao.this.entityClass.getName() + " h where dtype = '" + dtype + "' ORDER BY " + paging.getOrderBy() + " " + paging.getOrderDirection());
                q.setFirstResult(paging.getOffset());
                q.setMaxResults(paging.getMaxSize());
                List entities = q.getResultList();
                for (SimpleDomainObject entity : entities) {
                    if (null == entity || null == entity.getProperties()) continue;
                    for (Property property : entity.getProperties()) {
                        property.getPropertyName();
                        property.getPropertyValue();
                    }
                }
                return entities;
            }
        });
        return (List)res;
    }

    public List<E> findAll() {
        Object res = this.getJpaTemplate().execute(new JpaCallback(){

            public Object doInJpa(EntityManager em) throws PersistenceException {
                Query q = em.createQuery("SELECT h FROM " + JpaDao.this.entityClass.getName() + " h");
                return q.getResultList();
            }
        });
        return (List)res;
    }

    public Integer removeAll() {
        return (Integer)this.getJpaTemplate().execute(new JpaCallback(){

            public Object doInJpa(EntityManager em) throws PersistenceException {
                Query q = em.createQuery("DELETE FROM " + JpaDao.this.entityClass.getName() + " h");
                return q.executeUpdate();
            }
        });
    }

    public Object execute(final String query) {
        return this.getJpaTemplate().execute(new JpaCallback(){

            public Object doInJpa(EntityManager em) throws PersistenceException {
                Query q = em.createQuery(query);
                return q.getResultList();
            }
        });
    }
}

