/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.model;

import com.evolveum.midpoint.model.BooleanProperty;
import com.evolveum.midpoint.model.DateProperty;
import com.evolveum.midpoint.model.Domain;
import com.evolveum.midpoint.model.IdentifiableBase;
import com.evolveum.midpoint.model.IntegerProperty;
import com.evolveum.midpoint.model.Property;
import com.evolveum.midpoint.model.StringProperty;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.PrePersist;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.persistence.Version;
import org.hibernate.annotations.AnyMetaDef;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.IndexColumn;
import org.hibernate.annotations.ManyToAny;
import org.hibernate.annotations.MetaValue;

@Entity
@Table(catalog="midPoint", name="Objects")
@Inheritance(strategy=InheritanceType.SINGLE_TABLE)
@DiscriminatorColumn(name="dtype", length=45)
public abstract class SimpleDomainObject
extends IdentifiableBase {
    public static final String code_id = "$Id$";
    public static final String DDL_CATALOG = "midPoint";
    public static final String DDL_TABLE_DOMAINOBJECT = "Objects";
    private static final long serialVersionUID = 3407043276308745632L;
    protected String name;
    private Integer version;
    private Boolean unsaved = Boolean.TRUE;
    private List<Property> properties = new ArrayList<Property>(0);
    private Date modificationDate = new Date();
    private Domain domain;

    @Transient
    public Boolean isTransient() {
        return this.unsaved;
    }

    void setTransient(Boolean unsaved) {
        this.unsaved = unsaved;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Version
    @Column(name="version")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="repomod", nullable=false, length=19)
    public Date getModificationDate() {
        return SimpleDomainObject.cloneDate(this.modificationDate);
    }

    public void setModificationDate(Date modificationDate) {
        this.modificationDate = SimpleDomainObject.cloneDate(modificationDate);
    }

    @Transient
    public Domain getDomain() {
        return this.domain;
    }

    public void setDomain(Domain domain) {
        this.domain = domain;
    }

    @ManyToAny(fetch=FetchType.EAGER, metaDef="Property", metaColumn=@Column(name="property_type"))
    @AnyMetaDef(name="Property", metaType="string", idType="com.evolveum.midpoint.hibernate.usertype.UUIDType", metaValues={@MetaValue(value="B", targetEntity=BooleanProperty.class), @MetaValue(value="I", targetEntity=IntegerProperty.class), @MetaValue(value="S", targetEntity=StringProperty.class), @MetaValue(value="D", targetEntity=DateProperty.class)})
    @Cascade(value={CascadeType.ALL})
    @JoinTable(name="Objects_Properties", joinColumns={@JoinColumn(name="object_uuid")}, inverseJoinColumns={@JoinColumn(name="property_uuid")})
    @IndexColumn(name="property_index")
    public List<Property> getProperties() {
        return this.properties;
    }

    public void setProperties(List<Property> properties) {
        this.properties = properties;
    }

    protected static final Date cloneDate(Date date) {
        if (date == null) {
            return null;
        }
        return (Date)date.clone();
    }

    @PrePersist
    public void initialise() {
        this.setModificationDate(new Date());
    }
}

