/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.model;

import com.evolveum.midpoint.model.Resource;
import com.evolveum.midpoint.model.SimpleDomainObject;
import com.evolveum.midpoint.model.User;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.SecondaryTable;
import org.hibernate.annotations.CollectionOfElements;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.MapKey;

@Entity
@SecondaryTable(catalog="midPoint", name="Accounts", pkJoinColumns={@PrimaryKeyJoinColumn(name="uuid", referencedColumnName="uuid")})
@NamedQueries(value={@NamedQuery(name="Account.findAll", query="SELECT m FROM Account m"), @NamedQuery(name="Account.findByUname", query="SELECT m FROM Account m WHERE m.name = ?0")})
public class Account
extends SimpleDomainObject {
    public static final String code_id = "$Id$";
    public static final String DDL_TABLE_ACCOUNT = "Accounts";
    public static final String QUERY_ACCOUNT_FIND_BY_NAME = "Account.findByUname";
    public static final String QUERY_ACCOUNT_FIND_ALL = "Account.findAll";
    private Resource resource;
    private User user;
    private Map<String, String> attributes = new HashMap<String, String>(0);
    private String objectClass;

    @Column(table="Accounts", name="object_class", unique=false, nullable=false, length=256)
    public String getObjectClass() {
        return this.objectClass;
    }

    public void setObjectClass(String objectClass) {
        this.objectClass = objectClass;
    }

    @Column(table="Accounts", name="name", unique=false, nullable=false, length=250)
    public String getName() {
        return this.name;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(table="Accounts", name="resource_uuid", nullable=false, updatable=false)
    @ForeignKey(name="none")
    public Resource getResource() {
        return this.resource;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(table="Accounts", name="user_uuid")
    @ForeignKey(name="none")
    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    @CollectionOfElements(fetch=FetchType.EAGER)
    @JoinTable(name="AccountAttributes", joinColumns={@JoinColumn(name="uuid")})
    @Column(name="attrvalue", nullable=false)
    @MapKey(columns={@Column(name="attrname")})
    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, String> resourceAttributes) {
        this.attributes = resourceAttributes;
    }

    @Override
    public String toString() {
        return "Account [attributes " + this.attributes + " " + "resource " + this.resource + " " + "user " + this.user + " " + "name " + this.name + "]";
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Account other = (Account)obj;
        if (!(this.resource == other.resource || this.resource != null && this.resource.equals(other.resource))) {
            return false;
        }
        if (!(this.user == other.user || this.user != null && this.user.equals(other.user))) {
            return false;
        }
        if (!(this.attributes == other.attributes || this.attributes != null && ((Object)this.attributes).equals(other.attributes))) {
            return false;
        }
        return !(this.objectClass == null ? other.objectClass != null : !this.objectClass.equals(other.objectClass));
    }

    @Override
    public int hashCode() {
        int hash = 3;
        hash = 29 * hash + (this.resource != null ? this.resource.hashCode() : 0);
        hash = 29 * hash + (this.user != null ? this.user.hashCode() : 0);
        hash = 29 * hash + (this.attributes != null ? ((Object)this.attributes).hashCode() : 0);
        hash = 29 * hash + (this.objectClass != null ? this.objectClass.hashCode() : 0);
        return hash;
    }
}

