/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.openicf.flat.util;

import com.forgerock.openicf.flat.FlatConfiguration;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.common.objects.ObjectClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    public static void isAccount(ObjectClass oc) {
        if (oc == null) {
            throw new IllegalArgumentException("Object class must not be null.");
        }
        if (!ObjectClass.ACCOUNT.is(oc.getObjectClassValue())) {
            throw new ConnectorException("Can't work with resource object different than account.");
        }
    }

    public static void notNull(Object object, String message) {
        if (object == null) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void notNullArgument(Object object, String arg) {
        Utils.notNull(object, "Argument '" + arg + "' can't be null.");
    }

    public static void notEmpty(String value, String message) {
        Utils.notNull(value, message);
        if (value.isEmpty()) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void notEmptyArgument(String value, String arg) {
        Utils.notEmpty(value, "Argument '" + arg + "' can't be empty.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyAndReplace(File from, File to) throws IOException {
        if (to.exists()) {
            to.delete();
        }
        to.createNewFile();
        FileChannel inChannel = new FileInputStream(from).getChannel();
        FileChannel outChannel = new FileOutputStream(to).getChannel();
        try {
            inChannel.transferTo(0L, inChannel.size(), outChannel);
        }
        finally {
            if (inChannel != null) {
                inChannel.close();
            }
            if (outChannel != null) {
                outChannel.close();
            }
        }
    }

    public static BufferedReader createReader(FlatConfiguration configuration) throws IOException {
        return Utils.createReader(configuration.getFilePath(), configuration);
    }

    public static BufferedReader createReader(String path, FlatConfiguration configuration) throws IOException {
        FileInputStream fis = new FileInputStream(path);
        InputStreamReader in = new InputStreamReader((InputStream)fis, configuration.getEncoding());
        return new BufferedReader(in);
    }

    public static void closeReader(Reader reader, FileLock lock) {
        try {
            if (reader != null) {
                reader.close();
            }
            Utils.unlock(lock);
        }
        catch (IOException ex) {
            throw new ConnectorException("Couldn't close reader, reason: " + ex.getMessage(), (Throwable)ex);
        }
    }

    public static void unlock(FileLock lock) {
        if (lock != null && lock.isValid()) {
            try {
                lock.release();
            }
            catch (IOException ex) {
                throw new ConnectorException("Couldn't release file lock, reason: " + ex.getMessage(), (Throwable)ex);
            }
        }
    }

    public static List<String> parseValues(String line, Pattern linePattern, FlatConfiguration configuration) {
        ArrayList<String> values = new ArrayList<String>();
        if (line == null || line.isEmpty()) {
            return values;
        }
        if (line.matches("^" + configuration.getFieldDelimiter() + ".*$")) {
            StringBuilder builder = new StringBuilder();
            builder.append(configuration.getValueQualifier());
            builder.append(configuration.getValueQualifier());
            builder.append(line);
            line = builder.toString();
        }
        Matcher matcher = linePattern.matcher(line);
        while (matcher.find()) {
            String value = matcher.group(1).trim().replace(configuration.getValueQualifier(), "");
            values.add(value);
        }
        return values;
    }

    public static List<String> readHeader(BufferedReader reader, Pattern linePattern, FlatConfiguration configuration) throws IOException {
        String line = null;
        while ((line = reader.readLine()) != null && Utils.isEmptyOrComment(line)) {
        }
        if (line == null) {
            throw new ConnectorException("Csv file '" + configuration.getFilePath() + "' doesn't contain header.");
        }
        return Utils.parseValues(line, linePattern, configuration);
    }

    public static boolean isEmptyOrComment(String line) {
        if (line == null) {
            throw new IllegalArgumentException("Test line can't be null. It's must be a record, commend or empty line.");
        }
        return line.isEmpty() || line.startsWith("#");
    }
}

