/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.openicf.flat;

import com.forgerock.openicf.flat.FlatConfiguration;
import com.forgerock.openicf.flat.sync.Change;
import com.forgerock.openicf.flat.sync.DiffException;
import com.forgerock.openicf.flat.sync.InMemoryDiff;
import com.forgerock.openicf.flat.util.CsvItem;
import com.forgerock.openicf.flat.util.Utils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.channels.FileLock;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.framework.common.exceptions.AlreadyExistsException;
import org.identityconnectors.framework.common.exceptions.ConfigurationException;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.common.exceptions.InvalidCredentialException;
import org.identityconnectors.framework.common.exceptions.InvalidPasswordException;
import org.identityconnectors.framework.common.exceptions.UnknownUidException;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeInfo;
import org.identityconnectors.framework.common.objects.AttributeInfoBuilder;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.ConnectorObjectBuilder;
import org.identityconnectors.framework.common.objects.Name;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.ObjectClassInfoBuilder;
import org.identityconnectors.framework.common.objects.OperationOptions;
import org.identityconnectors.framework.common.objects.ResultsHandler;
import org.identityconnectors.framework.common.objects.Schema;
import org.identityconnectors.framework.common.objects.SchemaBuilder;
import org.identityconnectors.framework.common.objects.SyncDelta;
import org.identityconnectors.framework.common.objects.SyncDeltaBuilder;
import org.identityconnectors.framework.common.objects.SyncDeltaType;
import org.identityconnectors.framework.common.objects.SyncResultsHandler;
import org.identityconnectors.framework.common.objects.SyncToken;
import org.identityconnectors.framework.common.objects.Uid;
import org.identityconnectors.framework.common.objects.filter.AbstractFilterTranslator;
import org.identityconnectors.framework.common.objects.filter.FilterTranslator;
import org.identityconnectors.framework.spi.Configuration;
import org.identityconnectors.framework.spi.Connector;
import org.identityconnectors.framework.spi.ConnectorClass;
import org.identityconnectors.framework.spi.operations.AuthenticateOp;
import org.identityconnectors.framework.spi.operations.CreateOp;
import org.identityconnectors.framework.spi.operations.DeleteOp;
import org.identityconnectors.framework.spi.operations.ResolveUsernameOp;
import org.identityconnectors.framework.spi.operations.SchemaOp;
import org.identityconnectors.framework.spi.operations.SearchOp;
import org.identityconnectors.framework.spi.operations.SyncOp;
import org.identityconnectors.framework.spi.operations.TestOp;
import org.identityconnectors.framework.spi.operations.UpdateAttributeValuesOp;
import org.identityconnectors.framework.spi.operations.UpdateOp;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ConnectorClass(displayNameKey="UI_CONNECTOR_NAME", configurationClass=FlatConfiguration.class)
public class FlatConnector
implements Connector,
AuthenticateOp,
ResolveUsernameOp,
SchemaOp,
SearchOp<String>,
SyncOp,
TestOp,
CreateOp,
DeleteOp,
UpdateOp,
UpdateAttributeValuesOp {
    public static final String TMP_EXTENSION = ".tmp";
    private static final String ATTRIBUTE_NAME = "__NAME__";
    private static final String ATTRIBUTE_PASSWORD = "__PASSWORD__";
    private static final String ATTRIBUTE_UID = "__UID__";
    private static final Log log = Log.getLog(FlatConnector.class);
    private FlatConfiguration configuration;
    private static final Object lock = new Object();
    private Pattern linePattern;

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void init(Configuration configuration) {
        Utils.notNullArgument(configuration, "configuration");
        this.configuration = (FlatConfiguration)configuration;
        StringBuilder builder = new StringBuilder();
        builder.append("(?:^|");
        builder.append(this.configuration.getFieldDelimiter());
        builder.append(")(");
        builder.append(this.configuration.getValueQualifier());
        builder.append("(?:[^");
        builder.append(this.configuration.getValueQualifier());
        builder.append("]+|");
        builder.append(this.configuration.getValueQualifier());
        builder.append(this.configuration.getValueQualifier());
        builder.append(")*");
        builder.append(this.configuration.getValueQualifier());
        builder.append("|[^");
        builder.append(this.configuration.getFieldDelimiter());
        builder.append("]*)");
        this.linePattern = Pattern.compile(builder.toString());
    }

    public void dispose() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void test() {
        log.info("test::begin", new Object[0]);
        log.info("Validating configuration.", new Object[0]);
        this.configuration.validate();
        BufferedReader reader = null;
        Object object = lock;
        synchronized (object) {
            try {
                log.info("Openin input stream to file {0}.", new Object[]{this.configuration.getFilePath()});
                reader = Utils.createReader(this.configuration);
                List<String> headers = Utils.readHeader(reader, this.linePattern, this.configuration);
                this.testHeader(headers);
            }
            catch (IOException ex) {
                try {
                    log.error("Test configuration was unsuccessful, reason: {0}.", new Object[]{ex.getMessage()});
                    throw new ConnectorException("I/O error occured, reason: " + ex.getMessage(), (Throwable)ex);
                    catch (ConnectorException ex2) {
                        log.error("Connector exception occured, reason: {0}.", new Object[]{ex2.getMessage()});
                        throw ex2;
                    }
                    catch (Exception ex3) {
                        log.error("Test configuration was unsuccessful, reason: {0}.", new Object[]{ex3.getMessage()});
                        throw new ConnectorException("Uknown error occured during test connection, reason: " + ex3.getMessage(), (Throwable)ex3);
                    }
                }
                catch (Throwable throwable) {
                    log.info("Closing file input stream.", new Object[0]);
                    lock.notify();
                    Utils.closeReader(reader, null);
                    throw throwable;
                }
            }
            log.info("Closing file input stream.", new Object[0]);
            lock.notify();
            Utils.closeReader(reader, null);
        }
        log.info("Test configuration was successful.", new Object[0]);
        log.info("test::end", new Object[0]);
    }

    public Uid authenticate(ObjectClass objectClass, String username, GuardedString pwd, OperationOptions oo) {
        log.info("authenticate::begin", new Object[0]);
        Uid uid = this.realAuthenticate(objectClass, username, pwd, true);
        log.info("authenticate::end", new Object[0]);
        return uid;
    }

    public Uid resolveUsername(ObjectClass objectClass, String username, OperationOptions oo) {
        log.info("resolveUsername::begin", new Object[0]);
        Uid uid = this.realAuthenticate(objectClass, username, null, false);
        log.info("resolveUsername::end", new Object[0]);
        return uid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Schema schema() {
        log.info("schema::begin", new Object[0]);
        List<String> headers = null;
        BufferedReader reader = null;
        Object object = lock;
        synchronized (object) {
            try {
                reader = Utils.createReader(this.configuration);
                headers = Utils.readHeader(reader, this.linePattern, this.configuration);
                this.testHeader(headers);
            }
            catch (ConnectorException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new ConnectorException("Couldn't read csv file header, reason: " + ex.getMessage(), (Throwable)ex);
            }
            finally {
                lock.notify();
                Utils.closeReader(reader, null);
            }
        }
        if (headers == null || headers.isEmpty()) {
            throw new ConnectorException("Schema can't be generated, header is null (proably not defined in file - first line in csv).");
        }
        ObjectClassInfoBuilder objClassBuilder = new ObjectClassInfoBuilder();
        objClassBuilder.addAllAttributeInfo(this.createAttributeInfo(headers));
        SchemaBuilder builder = new SchemaBuilder(FlatConnector.class);
        builder.defineObjectClass(objClassBuilder.build());
        log.info("schema::end", new Object[0]);
        return builder.build();
    }

    public FilterTranslator<String> createFilterTranslator(ObjectClass objectClass, OperationOptions oo) {
        log.info("createFilterTranslator::begin", new Object[0]);
        Utils.isAccount(objectClass);
        log.info("createFilterTranslator::end", new Object[0]);
        return new AbstractFilterTranslator<String>(){};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeQuery(ObjectClass objectClass, String query, ResultsHandler results, OperationOptions oo) {
        log.info("executeQuery::begin", new Object[0]);
        Utils.isAccount(objectClass);
        Utils.notNull(results, "Results handled object can't be null.");
        BufferedReader reader = null;
        Object object = lock;
        synchronized (object) {
            try {
                reader = Utils.createReader(this.configuration);
                List<String> header = Utils.readHeader(reader, this.linePattern, this.configuration);
                String line = null;
                CsvItem item = null;
                while ((line = reader.readLine()) != null) {
                    ConnectorObject object2;
                    if (Utils.isEmptyOrComment(line) || results.handle(object2 = this.createConnectorObject(header, item = this.createCsvItem(line)))) continue;
                    break;
                }
            }
            catch (ConnectorException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new ConnectorException("Can't execute query, reason: " + ex.getMessage(), (Throwable)ex);
            }
            finally {
                lock.notify();
                Utils.closeReader(reader, null);
            }
        }
        log.info("executeQuery::end", new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Uid create(ObjectClass objectClass, Set<Attribute> set, OperationOptions oo) {
        log.info("create::begin", new Object[0]);
        Utils.isAccount(objectClass);
        Utils.notNull(set, "Attribute set must not be null.");
        Attribute uidAttr = this.getAttribute(this.configuration.getUniqueAttribute(), set);
        if (uidAttr == null || uidAttr.getValue().isEmpty() || uidAttr.getValue().get(0) == null) {
            throw new UnknownUidException("Unique attribute not defined or is empty.");
        }
        Uid uid = new Uid(uidAttr.getValue().get(0).toString());
        BufferedReader reader = null;
        BufferedWriter writer = null;
        Object object = lock;
        synchronized (object) {
            try {
                reader = Utils.createReader(this.configuration);
                List<String> header = Utils.readHeader(reader, this.linePattern, this.configuration);
                CsvItem account = this.findAccount(reader, header, uid.getUidValue());
                Utils.closeReader(reader, null);
                if (account != null) {
                    throw new AlreadyExistsException("Account already exists '" + uid.getUidValue() + "'.");
                }
                StringBuilder record = this.createRecord(header, set);
                if (record.length() == 0) {
                    throw new ConnectorException("Can't insert empty record.");
                }
                File file = new File(this.configuration.getFilePath());
                reader = Utils.createReader(this.configuration);
                reader.skip(file.length() - 1L);
                char[] chars = new char[1];
                reader.read(chars);
                writer = this.createWriter(true);
                if (chars[0] != '\n') {
                    writer.write(10);
                }
                writer.append(record);
                writer.append('\n');
                lock.notify();
                this.closeWriter(writer, null);
            }
            catch (ConnectorException ex) {
                try {
                    throw ex;
                    catch (Exception ex2) {
                        throw new ConnectorException("Couldn't create account, reason: " + ex2.getMessage(), (Throwable)ex2);
                    }
                }
                catch (Throwable throwable) {
                    lock.notify();
                    this.closeWriter(writer, null);
                    throw throwable;
                }
            }
        }
        log.info("create::end", new Object[0]);
        return uid;
    }

    public void delete(ObjectClass objectClass, Uid uid, OperationOptions oo) {
        log.info("delete::begin", new Object[0]);
        this.doUpdate(Operation.DELETE, objectClass, uid, null, oo);
        log.info("delete::end", new Object[0]);
    }

    public Uid update(ObjectClass objectClass, Uid uid, Set<Attribute> set, OperationOptions oo) {
        log.info("update::begin", new Object[0]);
        uid = this.doUpdate(Operation.UPDATE, objectClass, uid, set, oo);
        log.info("update::end", new Object[0]);
        return uid;
    }

    public Uid addAttributeValues(ObjectClass objectClass, Uid uid, Set<Attribute> set, OperationOptions oo) {
        log.info("addAttributeValues::begin", new Object[0]);
        uid = this.doUpdate(Operation.ADD_ATTR_VALUE, objectClass, uid, set, oo);
        log.info("addAttributeValues::end", new Object[0]);
        return uid;
    }

    public Uid removeAttributeValues(ObjectClass objectClass, Uid uid, Set<Attribute> set, OperationOptions oo) {
        log.info("removeAttributeValues::begin", new Object[0]);
        uid = this.doUpdate(Operation.REMOVE_ATTR_VALUE, objectClass, uid, set, oo);
        log.info("removeAttributeValues::end", new Object[0]);
        return uid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sync(ObjectClass objectClass, SyncToken token, SyncResultsHandler handler, OperationOptions oo) {
        log.info("sync::begin", new Object[0]);
        Utils.isAccount(objectClass);
        Utils.notNull(handler, "Sync results handler must not be null.");
        if (token == null || token.getValue() == null) {
            token = new SyncToken((Object)"-1");
        }
        String tokenValue = this.getTokenValue(token);
        long tokenLongValue = Long.parseLong(tokenValue);
        File csv = new File(this.configuration.getFilePath());
        boolean hasFileChanged = false;
        SimpleDateFormat df = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z");
        if (csv.lastModified() > tokenLongValue) {
            hasFileChanged = true;
            log.info("Csv file has changed on {0} which is after time {1}, based on token value {2}", new Object[]{df.format(new Date(csv.lastModified())), df.format(new Date(tokenLongValue)), tokenLongValue});
        }
        if (hasFileChanged) {
            long timestamp = csv.lastModified();
            log.info("Next last sync token value will be {0} ({1}).", new Object[]{timestamp, df.format(new Date(timestamp))});
            File syncFile = new File(csv.getParentFile(), csv.getName() + "." + timestamp + TMP_EXTENSION);
            Object object = lock;
            synchronized (object) {
                try {
                    Utils.copyAndReplace(csv, syncFile);
                }
                catch (ConnectorException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    throw new ConnectorException("Could not create file copy for sync, reason: " + ex.getMessage(), (Throwable)ex);
                }
                finally {
                    lock.notify();
                }
            }
            File oldFile = null;
            if (!"-1".equals(tokenValue)) {
                oldFile = new File(csv.getParent(), csv.getName() + "." + tokenValue);
            }
            InMemoryDiff memoryDiff = new InMemoryDiff(oldFile, syncFile, this.linePattern, this.configuration);
            try {
                Change change;
                SyncDelta delta;
                List<Change> changes = memoryDiff.diff();
                log.info("Found {0} differences.", new Object[]{changes.size()});
                SyncToken newToken = new SyncToken((Object)Long.toString(timestamp));
                Iterator<Change> i$ = changes.iterator();
                while (i$.hasNext() && handler.handle(delta = this.createSyncDelta(change = i$.next(), newToken))) {
                }
                syncFile.renameTo(new File(csv.getParent(), csv.getName() + "." + timestamp));
            }
            catch (DiffException ex) {
                throw new ConnectorException("Could not create csv diff, reason: " + ex.getMessage(), (Throwable)ex);
            }
            catch (Exception ex) {
                throw new ConnectorException("Could not finish sync operation, reason: " + ex.getMessage(), (Throwable)ex);
            }
            finally {
                if (syncFile.exists()) {
                    syncFile.delete();
                }
            }
        }
        String date = "Unknown";
        if (tokenLongValue != -1L) {
            date = df.format(new Date(tokenLongValue));
        }
        log.info("File has not changed after {0} (token value {1}), diff will be skippend.", new Object[]{date, tokenValue});
        log.info("sync::end", new Object[0]);
    }

    public SyncToken getLatestSyncToken(ObjectClass objectClass) {
        log.info("getLatestSyncToken::begin", new Object[0]);
        Utils.isAccount(objectClass);
        File csvFile = new File(this.configuration.getFilePath());
        if (!csvFile.exists()) {
            throw new ConnectorException("Csv file '" + this.configuration.getFilePath() + "' not found.");
        }
        File parentFolder = csvFile.getParentFile();
        if (!parentFolder.exists() || !parentFolder.isDirectory()) {
            throw new ConnectorException("Parent folder for '" + this.configuration.getFilePath() + "' doesn't exist, or is not a directory.");
        }
        final String csvFileName = csvFile.getName();
        Object[] oldCsvFiles = parentFolder.list(new FilenameFilter(){

            public boolean accept(File parent, String fileName) {
                File file = new File(parent, fileName);
                if (file.isDirectory()) {
                    return false;
                }
                return fileName.matches(csvFileName.replaceAll("\\.", "\\\\.") + "\\.[0-9]{13}$");
            }
        });
        String token = "-1";
        if (oldCsvFiles.length != 0) {
            Arrays.sort(oldCsvFiles);
            Object latestCsvFile = oldCsvFiles[oldCsvFiles.length - 1];
            token = ((String)latestCsvFile).replaceFirst(csvFileName + ".", "");
        } else {
            log.info("Old csv files was not found, returning default token '-1'.", new Object[0]);
        }
        log.info("getLatestSyncToken::end, returning token {0}.", new Object[]{token});
        return new SyncToken((Object)token);
    }

    private BufferedWriter createWriter(boolean append) throws IOException {
        return this.createWriter(this.configuration.getFilePath(), append);
    }

    private BufferedWriter createWriter(String path, boolean append) throws IOException {
        log.info("Creating writer.", new Object[0]);
        FileOutputStream fos = new FileOutputStream(path, append);
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)fos, this.configuration.getEncoding());
        return new BufferedWriter(out);
    }

    private void closeWriter(Writer writer, FileLock lock) {
        try {
            if (writer != null) {
                writer.flush();
                writer.close();
            }
            Utils.unlock(lock);
        }
        catch (IOException ex) {
            throw new ConnectorException("Couldn't close writer, reason: " + ex.getMessage(), (Throwable)ex);
        }
    }

    private void createTempFile() {
        File file = new File(this.configuration.getFilePath() + TMP_EXTENSION);
        try {
            if (file.exists() && !file.delete()) {
                throw new ConnectorException("Couldn't delete old tmp file '" + file.getAbsolutePath() + "'.");
            }
            file.createNewFile();
        }
        catch (IOException ex) {
            throw new ConnectorException("Couldn't create tmp file '" + file.getAbsolutePath() + "', reason: " + ex.getMessage(), (Throwable)ex);
        }
    }

    private void writeHeader(Writer writer, List<String> headers) throws IOException {
        StringBuilder builder = new StringBuilder();
        for (String header : headers) {
            if (headers.indexOf(header) != 0) {
                builder.append(this.configuration.getFieldDelimiter());
            }
            builder.append(this.configuration.getValueQualifier());
            builder.append(header);
            builder.append(this.configuration.getValueQualifier());
        }
        writer.write(builder.toString());
        writer.write(10);
    }

    private CsvItem findAccount(BufferedReader reader, List<String> header, String username) throws IOException {
        String line = null;
        while ((line = reader.readLine()) != null) {
            int fieldIndex;
            CsvItem item;
            String value;
            if (Utils.isEmptyOrComment(line) || StringUtil.isEmpty((String)(value = (item = this.createCsvItem(line)).getAttribute(fieldIndex = header.indexOf(this.configuration.getUniqueAttribute())))) || !value.equals(username)) continue;
            return item;
        }
        return null;
    }

    private CsvItem createCsvItem(String line) {
        CsvItem item = new CsvItem(Utils.parseValues(line, this.linePattern, this.configuration));
        return item;
    }

    private StringBuilder createRecord(List<String> header, Set<Attribute> attributes) {
        StringBuilder builder = new StringBuilder();
        for (String name : header) {
            String value;
            if (header.indexOf(name) != 0) {
                builder.append(this.configuration.getFieldDelimiter());
            }
            Attribute attribute = this.getAttribute(name, attributes);
            if (this.configuration.getUniqueAttribute().equals(name) && (attribute == null || attribute.getValue().isEmpty())) {
                throw new ConnectorException("Unique attribute for record is not defined.");
            }
            if (attribute == null || !StringUtil.isNotEmpty((String)(value = this.appendValues(name, attribute.getValue())))) continue;
            builder.append(this.configuration.getValueQualifier());
            builder.append(value);
            builder.append(this.configuration.getValueQualifier());
        }
        return builder;
    }

    private Attribute getAttribute(String name, Set<Attribute> attributes) {
        if (name.equals(this.configuration.getPasswordAttribute())) {
            name = ATTRIBUTE_PASSWORD;
        }
        if (name.equals(this.configuration.getNameAttribute())) {
            name = ATTRIBUTE_NAME;
        }
        for (Attribute attribute : attributes) {
            if (!attribute.getName().equals(name)) continue;
            return attribute;
        }
        return null;
    }

    private List<AttributeInfo> createAttributeInfo(List<String> names) {
        ArrayList<AttributeInfo> infos = new ArrayList<AttributeInfo>();
        for (String name : names) {
            AttributeInfoBuilder builder = new AttributeInfoBuilder(name);
            if (name.equals(this.configuration.getPasswordAttribute())) {
                builder.setType(GuardedString.class);
            } else {
                builder.setType(String.class);
            }
            infos.add(builder.build());
        }
        return infos;
    }

    private ConnectorObject createConnectorObject(List<String> header, CsvItem item) {
        ConnectorObjectBuilder builder = new ConnectorObjectBuilder();
        for (int i = 0; i < header.size(); ++i) {
            if (StringUtil.isEmpty((String)item.getAttribute(i))) continue;
            String name = header.get(i);
            if (name.equals(this.configuration.getUniqueAttribute())) {
                builder.setUid(item.getAttribute(i));
                builder.addAttribute(name, new Object[]{item.getAttribute(i)});
                if (!this.configuration.isUniqueAndNameAttributeEqual()) continue;
            }
            if (name.equals(this.configuration.getNameAttribute())) {
                builder.setName(new Name(item.getAttribute(i)));
                continue;
            }
            if (name.equals(this.configuration.getPasswordAttribute())) {
                builder.addAttribute(ATTRIBUTE_PASSWORD, new Object[]{new GuardedString(item.getAttribute(i).toCharArray())});
                continue;
            }
            builder.addAttribute(name, new Object[]{item.getAttribute(i)});
        }
        return builder.build();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Uid realAuthenticate(ObjectClass objectClass, String username, GuardedString pwd, boolean testPassword) {
        log.info("realAuthenticate::begin", new Object[0]);
        Utils.isAccount(objectClass);
        if (username == null) {
            throw new InvalidCredentialException("Username can't be null.");
        }
        if (testPassword && StringUtil.isEmpty((String)this.configuration.getPasswordAttribute())) {
            throw new ConfigurationException("Password attribute not defined in configuration.");
        }
        if (testPassword && pwd == null) {
            throw new InvalidPasswordException("Password can't be null.");
        }
        BufferedReader reader = null;
        Object object = lock;
        synchronized (object) {
            try {
                String uidAttribute;
                int index;
                reader = Utils.createReader(this.configuration);
                List<String> header = Utils.readHeader(reader, this.linePattern, this.configuration);
                CsvItem account = this.findAccount(reader, header, username);
                if (account == null) {
                    String message;
                    if (testPassword) {
                        message = "Invalid username and/or password.";
                        throw new InvalidCredentialException(message);
                    }
                    message = "Invalid username.";
                    throw new InvalidCredentialException(message);
                }
                if (testPassword) {
                    index = header.indexOf(this.configuration.getPasswordAttribute());
                    final String password = account.getAttribute(index);
                    if (StringUtil.isEmpty((String)password)) {
                        throw new InvalidPasswordException("Invalid username and/or password.");
                    }
                    pwd.access(new GuardedString.Accessor(){

                        public void access(char[] chars) {
                            if (!new String(chars).equals(password)) {
                                throw new InvalidPasswordException("Invalid username and/or password.");
                            }
                        }
                    });
                }
                if (StringUtil.isEmpty((String)(uidAttribute = account.getAttribute(index = header.indexOf(this.configuration.getUniqueAttribute()))))) {
                    throw new UnknownUidException("Unique atribute doesn't have value for account '" + username + "'.");
                }
                Uid uid = new Uid(uidAttribute);
                return uid;
            }
            catch (ConnectorException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new ConnectorException("Can't authenticate '" + username + "', reason: " + ex.getMessage(), (Throwable)ex);
            }
            finally {
                lock.notify();
                Utils.closeReader(reader, null);
                log.info("realAuthenticate::end", new Object[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Uid doUpdate(Operation operation, ObjectClass objectClass, Uid uid, Set<Attribute> attributes, OperationOptions oo) {
        log.info("doUpdate::begin", new Object[0]);
        Utils.isAccount(objectClass);
        Utils.notNull(uid, "Uid must not be null.");
        if (attributes == null && Operation.DELETE != operation) {
            throw new IllegalArgumentException("Attribute set can't be null.");
        }
        BufferedReader reader = null;
        BufferedWriter writer = null;
        Object object = lock;
        synchronized (object) {
            File tmpFile;
            this.createTempFile();
            try {
                reader = Utils.createReader(this.configuration);
                tmpFile = new File(this.configuration.getFilePath() + TMP_EXTENSION);
                writer = this.createWriter(tmpFile.getPath(), true);
                List<String> header = Utils.readHeader(reader, this.linePattern, this.configuration);
                this.writeHeader(writer, header);
                boolean found = false;
                String line = null;
                CsvItem item = null;
                while ((line = reader.readLine()) != null) {
                    item = this.createCsvItem(line);
                    if (Utils.isEmptyOrComment(line)) {
                        writer.write(line);
                        writer.write(10);
                        continue;
                    }
                    int fieldIndex = header.indexOf(this.configuration.getUniqueAttribute());
                    String value = item.getAttribute(fieldIndex);
                    if (!StringUtil.isEmpty((String)value) && value.equals(uid.getUidValue())) {
                        switch (operation) {
                            case UPDATE: 
                            case ADD_ATTR_VALUE: 
                            case REMOVE_ATTR_VALUE: {
                                line = this.updateLine(operation, header, item, attributes);
                                break;
                            }
                        }
                        found = true;
                    }
                    if (operation == Operation.DELETE) continue;
                    writer.write(line);
                    writer.write(10);
                }
                if (!found) {
                    throw new UnknownUidException("Uid '" + uid.getUidValue() + "' not found in file.");
                }
                Utils.closeReader(reader, null);
                this.closeWriter(writer, null);
                reader = null;
                writer = null;
                File oldFile = new File(this.configuration.getFilePath());
                if (!oldFile.delete()) throw new ConnectorException("Couldn't delete old file '" + oldFile.getAbsolutePath() + "' and replace it by new file '" + tmpFile.getAbsolutePath() + "'.");
                tmpFile.renameTo(oldFile);
                lock.notify();
            }
            catch (ConnectorException ex) {
                try {
                    throw ex;
                    catch (Exception ex2) {
                        throw new ConnectorException("Couldn't do " + (Object)((Object)operation) + " on account '" + uid.getUidValue() + "', reason: " + ex2.getMessage(), (Throwable)ex2);
                    }
                }
                catch (Throwable throwable) {
                    lock.notify();
                    Utils.closeReader(reader, null);
                    this.closeWriter(writer, null);
                    try {
                        File tmpFile2 = new File(this.configuration.getFilePath() + TMP_EXTENSION);
                        if (!tmpFile2.exists()) throw throwable;
                        tmpFile2.delete();
                        throw throwable;
                    }
                    catch (Exception ex3) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
            Utils.closeReader(reader, null);
            this.closeWriter(writer, null);
            try {
                tmpFile = new File(this.configuration.getFilePath() + TMP_EXTENSION);
                if (tmpFile.exists()) {
                    tmpFile.delete();
                }
            }
            catch (Exception ex) {}
        }
        log.info("doUpdate::end", new Object[0]);
        return uid;
    }

    private String appendValues(String attributeName, List<Object> values) {
        final StringBuilder builder = new StringBuilder();
        if (values == null || values.isEmpty()) {
            return null;
        }
        for (int i = 0; i < values.size(); ++i) {
            Object object = values.get(i);
            if (object == null) {
                return null;
            }
            if (this.configuration.getUniqueAttribute().equals(attributeName)) {
                builder.append(object.toString());
                break;
            }
            if (i != 0) {
                builder.append(this.configuration.getMultivalueDelimiter());
            }
            if (object instanceof GuardedString) {
                GuardedString pwd = (GuardedString)object;
                pwd.access(new GuardedString.Accessor(){

                    public void access(char[] chars) {
                        builder.append(chars);
                    }
                });
                continue;
            }
            builder.append(object);
        }
        return builder.toString();
    }

    private String appendMergedValues(String attributeName, List<String> oldValues, List<Object> newValues, Operation operation) {
        List<Object> values = new ArrayList<Object>();
        if (!this.configuration.isUsingMultivalue()) {
            switch (operation) {
                case ADD_ATTR_VALUE: {
                    return this.appendValues(attributeName, newValues);
                }
                case REMOVE_ATTR_VALUE: {
                    values = this.removeOldValues(oldValues, newValues);
                }
            }
        } else {
            if (operation == Operation.REMOVE_ATTR_VALUE && (newValues == null || newValues.isEmpty())) {
                return null;
            }
            if (operation == Operation.REMOVE_ATTR_VALUE) {
                values = this.removeOldValues(oldValues, newValues);
            } else {
                values.addAll(oldValues);
                values.addAll(newValues);
            }
        }
        String value = this.appendValues(attributeName, values);
        if (StringUtil.isNotEmpty((String)value)) {
            return value;
        }
        return "";
    }

    private List<Object> removeOldValues(List<String> oldValues, List<Object> newValues) {
        final ArrayList<Object> values = new ArrayList<Object>();
        values.addAll(oldValues);
        for (Object object : newValues) {
            if (object instanceof String) {
                values.remove((String)object);
                continue;
            }
            if (!(object instanceof GuardedString)) continue;
            GuardedString guarded = (GuardedString)object;
            guarded.access(new GuardedString.Accessor(){

                public void access(char[] chars) {
                    values.remove(new String(chars));
                }
            });
        }
        return values;
    }

    private String updateLine(Operation operation, List<String> headers, CsvItem item, Set<Attribute> attributes) {
        StringBuilder builder = new StringBuilder();
        String value = null;
        for (String header : headers) {
            Attribute attribute;
            int index = headers.indexOf(header);
            if (index != 0) {
                builder.append(this.configuration.getFieldDelimiter());
            }
            if ((attribute = this.getAttribute(header, attributes)) != null) {
                switch (operation) {
                    case UPDATE: {
                        value = this.appendValues(header, attribute.getValue());
                        break;
                    }
                    case ADD_ATTR_VALUE: 
                    case REMOVE_ATTR_VALUE: {
                        ArrayList<String> oldValues = new ArrayList<String>();
                        String oldValuesStr = item.getAttribute(index);
                        if (StringUtil.isNotEmpty((String)value)) {
                            if (this.configuration.isUsingMultivalue()) {
                                String[] array = oldValuesStr.split(String.valueOf(this.configuration.getMultivalueDelimiter()));
                                oldValues.addAll(Arrays.asList(array));
                            } else {
                                oldValues.add(oldValuesStr);
                            }
                        }
                        value = this.appendMergedValues(header, oldValues, attribute.getValue(), operation);
                    }
                }
            } else {
                value = item.getAttribute(index);
            }
            if (!StringUtil.isNotEmpty((String)value)) continue;
            builder.append(this.configuration.getValueQualifier());
            builder.append(value);
            builder.append(this.configuration.getValueQualifier());
        }
        return builder.toString();
    }

    private void testHeader(List<String> headers) {
        boolean uniqueFound = false;
        boolean passwordFound = false;
        HashMap<String, Integer> headerCount = new HashMap<String, Integer>();
        for (String header : headers) {
            if (!headerCount.containsKey(header)) {
                headerCount.put(header, 0);
            }
            headerCount.put(header, (Integer)headerCount.get(header) + 1);
        }
        for (String header : headers) {
            int count;
            int n = count = headerCount.containsKey(header) ? (Integer)headerCount.get(header) : 0;
            if (count != 1) {
                throw new ConfigurationException("Column header '" + header + "' occurs more than once (" + count + ").");
            }
            if (header.equals(this.configuration.getUniqueAttribute())) {
                uniqueFound = true;
                continue;
            }
            if (StringUtil.isNotEmpty((String)this.configuration.getPasswordAttribute()) && header.equals(this.configuration.getPasswordAttribute())) {
                passwordFound = true;
            }
            if (!uniqueFound || !passwordFound) continue;
            break;
        }
        if (!uniqueFound) {
            throw new ConfigurationException("Header in csv file doesn't contain unique attribute name as defined in configuration.");
        }
        if (StringUtil.isNotEmpty((String)this.configuration.getPasswordAttribute()) && !passwordFound) {
            throw new ConfigurationException("Header in csv file doesn't contain password attribute name as defined in configuration.");
        }
    }

    private String getTokenValue(SyncToken token) {
        if (token == null || token.getValue() == null) {
            return "-1";
        }
        String object = token.getValue().toString();
        if (!object.matches("[0-9]{13}")) {
            return "-1";
        }
        return object;
    }

    private SyncDelta createSyncDelta(Change change, SyncToken token) {
        SyncDeltaBuilder builder = new SyncDeltaBuilder();
        builder.setUid(new Uid(change.getUid()));
        builder.setToken(token);
        if (Change.Type.DELETE.equals((Object)change.getType())) {
            builder.setDeltaType(SyncDeltaType.DELETE);
        } else {
            builder.setDeltaType(SyncDeltaType.CREATE_OR_UPDATE);
            CsvItem item = new CsvItem(change.getAttributes());
            ConnectorObject object = this.createConnectorObject(change.getHeader(), item);
            builder.setObject(object);
        }
        return builder.build();
    }

    @Deprecated
    Pattern getLinePattern() {
        return this.linePattern;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Operation {
        DELETE,
        UPDATE,
        ADD_ATTR_VALUE,
        REMOVE_ATTR_VALUE;

    }
}

