/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.ldap;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContextException;
import org.springframework.core.Ordered;
import org.springframework.util.ClassUtils;

class ContextSourceSettingPostProcessor
implements BeanFactoryPostProcessor,
Ordered {
    private static final String REQUIRED_CONTEXT_SOURCE_CLASS_NAME = "org.springframework.ldap.core.support.BaseLdapPathContextSource";
    private boolean defaultNameRequired;

    ContextSourceSettingPostProcessor() {
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory bf) throws BeansException {
        Class contextSourceClass;
        try {
            contextSourceClass = ClassUtils.forName((String)REQUIRED_CONTEXT_SOURCE_CLASS_NAME, (ClassLoader)ClassUtils.getDefaultClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new ApplicationContextException("Couldn't locate: org.springframework.ldap.core.support.BaseLdapPathContextSource.  If you are using LDAP with Spring Security, please ensure that you include the spring-ldap jar file in your application", (Throwable)e);
        }
        String[] sources = bf.getBeanNamesForType(contextSourceClass);
        if (sources.length == 0) {
            throw new ApplicationContextException("No BaseLdapPathContextSource instances found. Have you added an <ldap-server /> element to your application context?");
        }
        if (!bf.containsBean("org.springframework.security.securityContextSource") && this.defaultNameRequired) {
            if (sources.length > 1) {
                throw new ApplicationContextException("More than one BaseLdapPathContextSource instance found. Please specify a specific server id using the 'server-ref' attribute when configuring your <ldap-authentication-provider> or <ldap-user-service>.");
            }
            bf.registerAlias(sources[0], "org.springframework.security.securityContextSource");
        }
    }

    public void setDefaultNameRequired(boolean defaultNameRequired) {
        this.defaultNameRequired = defaultNameRequired;
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }
}

