/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.ws;

import com.evolveum.midpoint.logging.TraceManager;
import com.evolveum.midpoint.ws.MessageLoggerHandler;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.jws.WebService;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.handler.Handler;
import org.slf4j.Logger;

public class WSClientTool {
    Logger logger = TraceManager.getTrace(WSClientTool.class);
    private static WSClientTool instance = new WSClientTool();
    private File configFile;

    protected WSClientTool() {
        String userHome = System.getProperty("user.home");
        this.configFile = new File(userHome, ".openidm.dev");
    }

    public static WSClientTool getInstance() {
        return instance;
    }

    public static void setInstance(WSClientTool instance) {
        WSClientTool.instance = instance;
    }

    public void addHandler(BindingProvider port, Handler handler) {
        List handlerList = port.getBinding().getHandlerChain();
        handlerList.add(handler);
        port.getBinding().setHandlerChain(handlerList);
    }

    public void setEndpoint(BindingProvider port, String endpointURL) {
        port.getRequestContext().put("javax.xml.ws.service.endpoint.address", endpointURL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties loadProperties() {
        Properties p = new Properties();
        InputStreamReader reader = null;
        try {
            reader = new FileReader(this.configFile);
            p.load(reader);
        }
        catch (IOException ex) {
            this.logger.error("Error on loading properties file " + this.configFile.getAbsolutePath(), (Throwable)ex);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException ex) {
                this.logger.error("Error on closing developer properties file", (Throwable)ex);
            }
        }
        return p;
    }

    public Object fixWebServicePort(Object port) {
        if (port instanceof BindingProvider) {
            BindingProvider provider = (BindingProvider)port;
            if (this.configFile.exists()) {
                Properties p = this.loadProperties();
                if (p.getProperty("ws.debug") != null) {
                    this.addHandler(provider, (Handler)new MessageLoggerHandler());
                }
                if ("standalone".equals(p.getProperty("endpoint.strategy"))) {
                    String endpoint = "http://localhost:8080/" + this.getPortName(port);
                    this.logger.info("Setting endpoint to " + endpoint);
                    this.setEndpoint(provider, endpoint);
                }
            }
        }
        return port;
    }

    public String getPortName(Object port) {
        HashMap<String, String> urlMapping = new HashMap<String, String>();
        urlMapping.put("ModelPortType", "modelService/ModelService");
        urlMapping.put("ProvisioningPortType", "provisioningService/ProvisioningService");
        urlMapping.put("RepositoryPortType", "repositoryService/RepositoryService");
        for (Class<?> interFace : port.getClass().getInterfaces()) {
            if (!interFace.isAnnotationPresent(WebService.class)) continue;
            this.logger.info("Finding endpoint for interface " + interFace.getSimpleName());
            return (String)urlMapping.get(interFace.getSimpleName());
        }
        return null;
    }
}

