/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.ws;

import com.evolveum.midpoint.api.exceptions.MidPointException;
import com.evolveum.midpoint.logging.TraceManager;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.slf4j.Logger;

public class MessageLoggerHandler
implements SOAPHandler<SOAPMessageContext> {
    private boolean writeToFile = true;
    Logger logger = TraceManager.getTrace(MessageLoggerHandler.class);

    public Set<QName> getHeaders() {
        return new HashSet<QName>();
    }

    public boolean handleMessage(SOAPMessageContext messageContext) {
        SOAPMessage msg = messageContext.getMessage();
        try {
            ByteArrayOutputStream bas = new ByteArrayOutputStream();
            msg.writeTo((OutputStream)bas);
            this.logger.info(bas.toString());
            if (this.writeToFile) {
                Date d = new Date();
                File outDir = new File(System.getProperties().getProperty("java.io.tmpdir"), "openidm.log");
                if (!outDir.exists()) {
                    outDir.mkdirs();
                }
                File outFile = new File(outDir, "" + d.getTime() + ".xml");
                FileOutputStream out = new FileOutputStream(outFile);
                out.write(bas.toByteArray());
                out.close();
            }
        }
        catch (Exception ex) {
            throw new MidPointException("Error on logging WS message", ex);
        }
        return true;
    }

    public boolean handleFault(SOAPMessageContext context) {
        return true;
    }

    public void close(MessageContext context) {
    }
}

