/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.util.diff;

import com.evolveum.midpoint.logging.TraceManager;
import com.evolveum.midpoint.util.diff.DiffConstants;
import org.custommonkey.xmlunit.Difference;
import org.custommonkey.xmlunit.DifferenceConstants;
import org.custommonkey.xmlunit.DifferenceListener;
import org.slf4j.Logger;
import org.w3c.dom.Node;

public class MidPointDifferenceListener
implements DifferenceListener {
    private static final Logger logger = TraceManager.getTrace(MidPointDifferenceListener.class);

    public int differenceFound(Difference difference) {
        if (DiffConstants.isForReplaceProperty(difference)) {
            return 0;
        }
        if (difference.equals((Object)DifferenceConstants.TEXT_VALUE) && DiffConstants.isForContainerProperty(difference)) {
            return 1;
        }
        if (difference.equals((Object)DifferenceConstants.TEXT_VALUE) && !DiffConstants.isForContainerProperty(difference)) {
            return 0;
        }
        Node controlNode = difference.getControlNodeDetail().getNode();
        if (difference.equals((Object)DifferenceConstants.CHILD_NODE_NOT_FOUND) && null != controlNode && controlNode.getNodeType() == 3) {
            return 1;
        }
        return DiffConstants.IGNORE_DIFFERENCES.contains(difference) ? 1 : 0;
    }

    public void skippedComparison(Node nodeControl, Node nodeTest) {
        logger.warn("Skipped comparison for " + nodeControl + " " + nodeTest);
    }
}

