/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.logging;

import com.evolveum.midpoint.api.logging.Trace;
import com.evolveum.midpoint.logging.LogInfo;
import com.evolveum.midpoint.logging.LoggerMXBean;
import com.evolveum.midpoint.logging.TraceManager;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class LoggerMXBeanImpl
implements LoggerMXBean {
    private static Trace TRACE = TraceManager.getTrace(LoggerMXBeanImpl.class);
    private static final String DEFAULT_LOG_PATTERN = "%d{HH:mm:ss,SSS} %-5p [%c] - %m%n";
    private static final int DEFAULT_LOG_LEVEL = 30000;
    private static final String APPENDER_NAME = "LoggerMXBeanControllerAppender";
    private int moduleLogLevel = 30000;
    private String name;
    private String displayName;
    private String logPattern;
    private String rootPackage;
    private List<LogInfo> logInfoList;

    public LoggerMXBeanImpl(String name, String rootPackage) {
        this.name = name;
        this.rootPackage = rootPackage;
        TRACE.debug("Constructor::Initialising Logger MXBean instance: " + name);
        this.updateRootLogger();
    }

    @Override
    public List<LogInfo> getLogInfoList() {
        if (this.logInfoList == null) {
            this.logInfoList = new ArrayList<LogInfo>();
        }
        return this.logInfoList;
    }

    @Override
    public void setLogInfoList(List<LogInfo> logInfoList) {
        if (!this.getLogInfoList().isEmpty()) {
            for (LogInfo logInfo : this.getLogInfoList()) {
                logInfo.setLevel(this.getModuleLogLevel());
            }
            this.updateLoggingSettings(this.getLogInfoList());
        }
        this.logInfoList = logInfoList;
        this.updateLoggingSettings(logInfoList);
    }

    @Override
    public String getLogPattern() {
        if (this.logPattern == null) {
            this.logPattern = DEFAULT_LOG_PATTERN;
        }
        return this.logPattern;
    }

    @Override
    public void setLogPattern(String pattern) {
        if (pattern == null) {
            pattern = DEFAULT_LOG_PATTERN;
        }
        if (!pattern.equals(this.logPattern)) {
            TRACE.info("Updating log pattern '{}' for logger {}.", new Object[]{pattern, this.logPattern});
            this.logPattern = pattern;
            this.updateRootLogger();
        }
    }

    @Override
    public LogInfo getLogInfo(String packageName) {
        List<LogInfo> list = this.getLogInfoList();
        LogInfo logInfo = null;
        for (LogInfo info : list) {
            if (!info.getPackageName().equals(packageName)) continue;
            logInfo = info;
        }
        if (logInfo == null) {
            logInfo = new LogInfo(packageName, this.getLoggerLevel(packageName));
        }
        return logInfo;
    }

    @Override
    public void setLogInfo(LogInfo logInfo) {
        List<LogInfo> list = this.getLogInfoList();
        boolean found = false;
        for (LogInfo info : list) {
            if (!logInfo.getPackageName().equals(info.getPackageName())) continue;
            info.setLevel(logInfo.getLevel());
            found = true;
            break;
        }
        if (!found) {
            list.add(logInfo);
        }
        this.updateLoggingSettings(logInfo);
    }

    @Override
    public void setLogInfo(String packageName, int level) {
        this.setLogInfo(new LogInfo(packageName, level));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDisplayName() {
        if (this.displayName == null || this.displayName.isEmpty()) {
            return this.name;
        }
        return this.displayName;
    }

    @Override
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    private void updateLoggingSettings(LogInfo info) {
        ArrayList<LogInfo> list = new ArrayList<LogInfo>();
        list.add(info);
        this.updateLoggingSettings(list);
    }

    private void updateLoggingSettings(List<LogInfo> infoList) {
        if (infoList == null) {
            return;
        }
        Logger rootLogger = Logger.getRootLogger();
        for (LogInfo info : infoList) {
            if (info == null || info.getPackageName() == null) continue;
            Logger pkgLogger = rootLogger.getLoggerRepository().getLogger(info.getPackageName());
            if (pkgLogger == null) {
                TRACE.warn("Can't change logger level, reason: logger for package '" + info.getPackageName() + "' is null.");
                continue;
            }
            TRACE.info("Log4J root logger: {} Module: {}. Updating logger '{}' to level: {}", new Object[]{rootLogger, this.name, info.getPackageName(), Level.toLevel((int)info.getLevel())});
            pkgLogger.setLevel(Level.toLevel((int)info.getLevel()));
        }
    }

    private int getLoggerLevel(String packageName) {
        int level = Integer.MAX_VALUE;
        Logger rootLogger = Logger.getRootLogger();
        Logger pkgLogger = rootLogger.getLoggerRepository().getLogger(packageName);
        if (pkgLogger != null) {
            level = pkgLogger.getEffectiveLevel().toInt();
        }
        return level;
    }

    @Override
    public void setModuleLogLevel(int level) {
        if (this.moduleLogLevel != level) {
            this.moduleLogLevel = level;
            this.updateRootLogger();
        }
    }

    @Override
    public int getModuleLogLevel() {
        return this.moduleLogLevel;
    }

    public void setModuleLogLevel(String name) {
        if (name != null && this.levelExists(name)) {
            Level level = Level.toLevel((String)name);
            this.setModuleLogLevel(level.toInt());
        }
    }

    private boolean levelExists(String name) {
        try {
            Level level = Level.toLevel((String)name);
            if (level != null) {
                return true;
            }
        }
        catch (Exception ex) {
            TRACE.error("Unknown log level '" + name + "', reason: " + ex.getMessage());
        }
        return false;
    }

    private void updateRootLogger() {
        TRACE.info("Updating root logger for: {}, package: {}, level: {}", new Object[]{this.name, this.rootPackage, Level.toLevel((int)this.moduleLogLevel)});
        Logger rootLogger = Logger.getRootLogger();
        this.updateAppender(rootLogger);
        Logger loggingLogger = rootLogger.getLoggerRepository().getLogger("com.evolveum.midpoint.logging");
        loggingLogger.setLevel(Level.INFO);
        Logger logger = rootLogger.getLoggerRepository().getLogger("com.evolveum.midpoint");
        logger.setLevel(Level.toLevel((int)this.moduleLogLevel));
    }

    private void updateAppender(Logger logger) {
    }
}

