/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.aspect;

import java.util.Arrays;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StopWatch;

@Aspect
public abstract class ProfilingAspect {
    private static final Logger logger = LoggerFactory.getLogger(ProfilingAspect.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="methodsToBeProfiled()")
    public Object profile(ProceedingJoinPoint pjp) throws Throwable {
        if (logger.isTraceEnabled()) {
            StringBuilder message = new StringBuilder();
            message.append("Entry: ");
            message.append(this.getClassName(pjp));
            message.append(" ");
            message.append(pjp.getSignature().getName());
            message.append(", args: ");
            message.append(Arrays.toString(pjp.getArgs()));
            logger.trace(message.toString());
        }
        StopWatch sw = new StopWatch(this.getClass().getSimpleName());
        Object retValue = null;
        try {
            sw.start(pjp.getSignature().getName());
            Object object = retValue = pjp.proceed();
            return object;
        }
        finally {
            sw.stop();
            if (logger.isTraceEnabled()) {
                StringBuilder message = new StringBuilder();
                message.append("Exit: ");
                message.append(this.getClassName(pjp));
                message.append(", time: ");
                message.append(sw.getTotalTimeMillis());
                message.append(", value: ");
                message.append(retValue);
                logger.trace(message.toString());
            }
        }
    }

    private String getClassName(ProceedingJoinPoint pjp) {
        if (pjp.getThis() != null) {
            return pjp.getThis().getClass().getName();
        }
        return null;
    }

    @Pointcut
    public abstract void methodsToBeProfiled();
}

