/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.validator;

import com.evolveum.midpoint.validator.ValidationMessage;
import com.evolveum.midpoint.validator.Validator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;

public class Main {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args.length == 0) {
            Main.usage();
            return;
        }
        String filename = args[0];
        if (filename == null || filename.isEmpty()) {
            Main.usage();
            return;
        }
        FileInputStream fis = null;
        try {
            File file = new File(args[0]);
            fis = new FileInputStream(file);
            Validator validator = new Validator();
            validator.setVerbose(true);
            List<ValidationMessage> errors = validator.validate(fis);
            if (!errors.isEmpty()) {
                for (ValidationMessage error : errors) {
                    System.out.println("ERROR: " + error);
                }
            } else {
                System.out.println("No errors");
            }
        }
        catch (FileNotFoundException ex) {
            System.out.println("File not found " + ex);
        }
        finally {
            try {
                if (null != fis) {
                    fis.close();
                }
            }
            catch (IOException ex) {
                System.out.println("Error closing the file " + ex);
            }
        }
    }

    static void usage() {
        System.out.println("Usage: TODO");
    }
}

