/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.util.jaxb;

import com.evolveum.midpoint.api.logging.Trace;
import com.evolveum.midpoint.logging.TraceManager;
import com.evolveum.midpoint.util.DOMUtil;
import com.evolveum.midpoint.util.jaxb.XMLMarshallerPool;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ObjectFactory;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ObjectType;
import com.evolveum.midpoint.xml.schema.SchemaConstants;
import com.evolveum.midpoint.xml.util.XMLMarshaller;
import java.io.File;
import java.io.InputStream;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class JAXBUtil {
    private static final transient Trace logger = TraceManager.getTrace(JAXBUtil.class);
    public static final String code_id = "$Id$";
    private static XMLMarshallerPool _marshallerPool = new XMLMarshallerPool();

    public static final ObjectType clone(ObjectType object) throws JAXBException {
        if (object == null) {
            return null;
        }
        ObjectFactory of = new ObjectFactory();
        JAXBElement obj = of.createObject(object);
        obj = (JAXBElement)JAXBUtil.unmarshal(JAXBUtil.marshal(obj));
        return (ObjectType)obj.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String marshal(Object xmlObject) throws JAXBException {
        XMLMarshaller m = (XMLMarshaller)_marshallerPool.checkout();
        String result = null;
        try {
            result = m.marshal(xmlObject);
        }
        finally {
            _marshallerPool.checkin(m);
        }
        return result;
    }

    public static final <T> String marshalWrap(T jaxbObject, QName elementQName) throws JAXBException {
        JAXBElement jaxbElement = new JAXBElement(elementQName, jaxbObject.getClass(), jaxbObject);
        return JAXBUtil.marshal(jaxbElement);
    }

    public static final String silentMarshal(Object xmlObject) {
        try {
            return JAXBUtil.marshal(xmlObject);
        }
        catch (JAXBException ex) {
            logger.debug("Failed to marshal object {}", xmlObject, (Object)ex);
            return null;
        }
    }

    public static final <T> String silentMarshalWrap(T jaxbObject, QName elementQName) {
        try {
            JAXBElement jaxbElement = new JAXBElement(elementQName, jaxbObject.getClass(), jaxbObject);
            return JAXBUtil.marshal(jaxbElement);
        }
        catch (JAXBException ex) {
            logger.debug("Failed to marshal object {}", jaxbObject, (Object)ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void marshal(Object xmlObject, Element element) throws JAXBException {
        XMLMarshaller m = (XMLMarshaller)_marshallerPool.checkout();
        try {
            m.marshal(xmlObject, (Node)element);
        }
        finally {
            _marshallerPool.checkin(m);
        }
    }

    public static final void silentMarshal(Object xmlObject, Element element) {
        try {
            JAXBUtil.marshal(xmlObject, element);
        }
        catch (JAXBException ex) {
            logger.debug("Failed to marshal object {}", xmlObject, (Object)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Object unmarshal(String xmlString) throws JAXBException {
        Object result = null;
        XMLMarshaller m = (XMLMarshaller)_marshallerPool.checkout();
        try {
            result = m.unmarshal(xmlString);
        }
        finally {
            _marshallerPool.checkin(m);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Object unmarshal(InputStream input) throws JAXBException {
        Object result = null;
        XMLMarshaller m = (XMLMarshaller)_marshallerPool.checkout();
        try {
            result = m.unmarshal(input);
        }
        finally {
            _marshallerPool.checkin(m);
        }
        return result;
    }

    public static final Object silentUnmarshal(String xmlString) {
        try {
            return JAXBUtil.unmarshal(xmlString);
        }
        catch (JAXBException ex) {
            logger.debug("Failed to unmarshal xml string {}", (Object)xmlString, (Object)ex);
            return null;
        }
    }

    public static final Object silentUnmarshal(File file) {
        try {
            return JAXBUtil.unmarshal(file);
        }
        catch (JAXBException ex) {
            logger.debug("Failed to unmarshal file {}", (Object)file, (Object)ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Object unmarshal(File file) throws JAXBException {
        Object result = null;
        XMLMarshaller m = (XMLMarshaller)_marshallerPool.checkout();
        try {
            result = m.unmarshal(file);
        }
        finally {
            _marshallerPool.checkin(m);
        }
        return result;
    }

    public static final <T> Element jaxbToDom(T jaxbObject, QName elementQName, Document doc) throws JAXBException {
        if (doc == null) {
            doc = DOMUtil.getDocument();
        }
        JAXBElement jaxbElement = new JAXBElement(elementQName, jaxbObject.getClass(), jaxbObject);
        Element element = doc.createElementNS(elementQName.getNamespaceURI(), elementQName.getLocalPart());
        JAXBUtil.marshal(jaxbElement, element);
        return (Element)element.getFirstChild();
    }

    public static <T> Element objectTypeToDom(T jaxbObject, Document doc) throws JAXBException {
        QName qname;
        if (doc == null) {
            doc = DOMUtil.getDocument();
        }
        if ((qname = SchemaConstants.getElementByObjectType(jaxbObject.getClass())) == null) {
            throw new IllegalArgumentException("Cannot find element for class " + jaxbObject.getClass());
        }
        return JAXBUtil.jaxbToDom(jaxbObject, qname, doc);
    }
}

