/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.util.diff;

import com.evolveum.midpoint.util.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.custommonkey.xmlunit.XpathNodeTracker;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MidPointXpathNodeTracker
extends XpathNodeTracker {
    private final List indentationList = new ArrayList();
    private TrackingEntry currentEntry;

    public MidPointXpathNodeTracker() {
        this.newLevel();
    }

    public void reset() {
        this.indentationList.clear();
        this.indent();
    }

    public void indent() {
        if (this.currentEntry != null) {
            this.currentEntry.clearTrackedAttribute();
        }
        this.newLevel();
    }

    private void newLevel() {
        this.currentEntry = new TrackingEntry();
        this.indentationList.add(this.currentEntry);
    }

    public void clearTrackedAttribute() {
        if (this.currentEntry != null) {
            this.currentEntry.clearTrackedAttribute();
        }
    }

    public void outdent() {
        int last = this.indentationList.size() - 1;
        this.indentationList.remove(last);
        if (--last >= 0) {
            this.currentEntry = (TrackingEntry)this.indentationList.get(last);
        }
    }

    public void visited(Node node) {
        switch (node.getNodeType()) {
            case 2: {
                String prefix;
                String nodeName = ((Attr)node).getLocalName();
                if (nodeName == null || nodeName.length() == 0) {
                    nodeName = node.getNodeName();
                }
                if (!StringUtils.isEmpty((String)(prefix = ((Attr)node).getPrefix()))) {
                    nodeName = prefix + ":" + nodeName;
                }
                this.visitedAttribute(nodeName);
                break;
            }
            case 1: {
                String prefix;
                String nodeName = ((Element)node).getLocalName();
                if (nodeName == null || nodeName.length() == 0) {
                    nodeName = node.getNodeName();
                }
                if (!StringUtils.isEmpty((String)(prefix = ((Element)node).getPrefix()))) {
                    nodeName = prefix + ":" + nodeName;
                }
                this.visitedNode(node, nodeName);
                break;
            }
            case 8: {
                this.visitedNode(node, "comment()");
                break;
            }
            case 7: {
                this.visitedNode(node, "processing-instruction()");
                break;
            }
            case 3: 
            case 4: {
                this.visitedNode(node, "text()");
                break;
            }
        }
    }

    protected void visitedNode(Node visited, String value) {
        this.currentEntry.trackNode(visited, value);
    }

    protected void visitedAttribute(String visited) {
        this.currentEntry.trackAttribute(visited);
    }

    public void preloadNodeList(NodeList nodeList) {
        this.currentEntry.trackNodesAsWellAsValues(true);
        int length = nodeList.getLength();
        for (int i = 0; i < length; ++i) {
            this.visited(nodeList.item(i));
        }
        this.currentEntry.trackNodesAsWellAsValues(false);
    }

    public void preloadChildList(List nodeList) {
        this.currentEntry.trackNodesAsWellAsValues(true);
        int length = nodeList.size();
        for (int i = 0; i < length; ++i) {
            this.visited((Node)nodeList.get(i));
        }
        this.currentEntry.trackNodesAsWellAsValues(false);
    }

    public String toXpathString() {
        StringBuffer buf = new StringBuffer();
        for (TrackingEntry nextEntry : this.indentationList) {
            nextEntry.appendEntryTo(buf);
        }
        return buf.toString();
    }

    private static final class TrackingEntry {
        private final Map valueMap = new HashMap();
        private String currentValue;
        private String currentAttribute;
        private Map nodeReferenceMap;
        private boolean trackNodeReferences = false;
        private String oid;

        private TrackingEntry() {
        }

        private Int lookup(String value) {
            return (Int)this.valueMap.get(value);
        }

        public void trackNode(Node visited, String value) {
            if (this.nodeReferenceMap == null || this.trackNodeReferences) {
                Int occurrence = this.lookup(value);
                if (occurrence == null) {
                    occurrence = new Int(1);
                    this.valueMap.put(value, occurrence);
                } else {
                    occurrence.increment();
                }
                if (this.trackNodeReferences) {
                    this.nodeReferenceMap.put(visited, occurrence.toInteger());
                }
            }
            this.currentValue = value;
            this.oid = Utils.getNodeOid(visited);
            this.clearTrackedAttribute();
        }

        public void trackAttribute(String visited) {
            this.currentAttribute = visited;
        }

        public void clearTrackedAttribute() {
            this.currentAttribute = null;
        }

        public void appendEntryTo(StringBuffer buf) {
            if (this.currentValue == null) {
                return;
            }
            buf.append("/").append(this.currentValue);
            if (null != this.oid) {
                buf.append("[").append("@").append("oid").append("=\"").append(this.oid).append("\"").append("]");
            }
            if (this.currentAttribute != null) {
                buf.append("/").append("@").append(this.currentAttribute);
            }
        }

        public void trackNodesAsWellAsValues(boolean yesNo) {
            this.trackNodeReferences = yesNo;
            if (yesNo) {
                this.nodeReferenceMap = new HashMap();
            }
        }
    }

    private static final class Int {
        private int value;

        public Int(int startAt) {
            this.value = startAt;
        }

        public void increment() {
            ++this.value;
        }

        public int getValue() {
            return this.value;
        }

        public Integer toInteger() {
            return this.value;
        }
    }
}

