/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.util.diff;

import com.evolveum.midpoint.logging.TraceManager;
import com.evolveum.midpoint.util.DOMUtil;
import com.evolveum.midpoint.util.DebugUtil;
import com.evolveum.midpoint.util.ObjectTypeUtil;
import com.evolveum.midpoint.util.Utils;
import com.evolveum.midpoint.util.diff.DiffConstants;
import com.evolveum.midpoint.util.diff.DiffException;
import com.evolveum.midpoint.util.diff.MidPointDifferenceEngine;
import com.evolveum.midpoint.util.diff.MidPointDifferenceListener;
import com.evolveum.midpoint.util.diff.OidQualifier;
import com.evolveum.midpoint.util.jaxb.JAXBUtil;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ObjectFactory;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ObjectModificationType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ObjectType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.PropertyModificationType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.PropertyModificationTypeType;
import com.evolveum.midpoint.xml.schema.XPathSegment;
import com.evolveum.midpoint.xml.schema.XPathType;
import com.sun.org.apache.xerces.internal.dom.AttrNSImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.custommonkey.xmlunit.ComparisonController;
import org.custommonkey.xmlunit.DetailedDiff;
import org.custommonkey.xmlunit.Diff;
import org.custommonkey.xmlunit.Difference;
import org.custommonkey.xmlunit.DifferenceEngine;
import org.custommonkey.xmlunit.DifferenceListener;
import org.custommonkey.xmlunit.ElementQualifier;
import org.custommonkey.xmlunit.XMLUnit;
import org.slf4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class CalculateXmlDiff {
    private static final Logger logger = TraceManager.getTrace(CalculateXmlDiff.class);

    private static PropertyModificationTypeType decideModificationTypeForChildNodeNotFound(Difference diff) {
        String newObjectOid = Utils.getNodeOid(diff.getTestNodeDetail().getNode());
        PropertyModificationTypeType changeType = StringUtils.isEmpty((String)newObjectOid) || StringUtils.contains((String)diff.getTestNodeDetail().getNode().getNodeName(), (String)"Ref") ? PropertyModificationTypeType.add : PropertyModificationTypeType.replace;
        return changeType;
    }

    private static void setupXmlUnit() {
        XMLUnit.setCompareUnmatched((boolean)false);
        XMLUnit.setIgnoreAttributeOrder((boolean)true);
        XMLUnit.setIgnoreWhitespace((boolean)true);
        XMLUnit.setNormalize((boolean)true);
        XMLUnit.setNormalizeWhitespace((boolean)true);
    }

    private static List<Difference> calculateXmlUnitDifferences(InputStream inputStreamOld, InputStream inputStreamNew) throws DiffException {
        try {
            logger.trace("Calculate XmlUnit differences");
            ComparisonController controller = new ComparisonController(){

                public boolean haltComparison(Difference arg0) {
                    return false;
                }
            };
            MidPointDifferenceEngine comparator = new MidPointDifferenceEngine(controller);
            Diff d = new Diff(XMLUnit.buildControlDocument((InputSource)new InputSource(inputStreamOld)), XMLUnit.buildTestDocument((InputSource)new InputSource(inputStreamNew)), (DifferenceEngine)comparator);
            DetailedDiff dd = new DetailedDiff(d);
            dd.overrideElementQualifier((ElementQualifier)new OidQualifier());
            dd.overrideDifferenceListener((DifferenceListener)new MidPointDifferenceListener());
            List l = dd.getAllDifferences();
            logger.trace("XmlUnit Differences are ready");
            return l;
        }
        catch (SAXException ex) {
            logger.error("Error calculating differences", (Throwable)ex);
            throw new DiffException((Throwable)ex);
        }
        catch (IOException ex) {
            logger.error("Error calculating differences", (Throwable)ex);
            throw new DiffException((Throwable)ex);
        }
    }

    public static ObjectModificationType calculateChanges(ObjectType oldObject, ObjectType newObject) throws DiffException {
        Validate.notNull((Object)oldObject);
        Validate.notNull((Object)newObject);
        Validate.isTrue((boolean)oldObject.getOid().equals(newObject.getOid()));
        try {
            ObjectFactory of = new ObjectFactory();
            JAXBElement jaxbOld = of.createObject(oldObject);
            JAXBElement jaxbNew = of.createObject(newObject);
            String stringOld = JAXBUtil.marshal(jaxbOld);
            String stringNew = JAXBUtil.marshal(jaxbNew);
            logger.trace("Old Object {}", (Object)stringOld);
            logger.trace("New Object {}", (Object)stringNew);
            return CalculateXmlDiff.calculateChanges(IOUtils.toInputStream((String)stringOld, (String)"utf-8"), IOUtils.toInputStream((String)stringNew, (String)"utf-8"), oldObject.getOid());
        }
        catch (JAXBException ex) {
            throw new DiffException((Throwable)ex);
        }
        catch (IOException ex) {
            throw new DiffException((Throwable)ex);
        }
    }

    public static ObjectModificationType calculateChanges(File oldObjectFile, File newObjectFile) throws DiffException {
        try {
            JAXBElement jaxbObject = (JAXBElement)JAXBUtil.unmarshal(oldObjectFile);
            String objectOid = ((ObjectType)jaxbObject.getValue()).getOid();
            return CalculateXmlDiff.calculateChanges(new FileInputStream(oldObjectFile), new FileInputStream(newObjectFile), objectOid);
        }
        catch (JAXBException ex) {
            throw new DiffException((Throwable)ex);
        }
        catch (FileNotFoundException ex) {
            throw new DiffException((Throwable)ex);
        }
    }

    private static XPathType modifyXpath(String originalXpath, Node node) {
        XPathType xpathType = new XPathType(originalXpath, node);
        return CalculateXmlDiff.modifyXpath(xpathType);
    }

    private static XPathType modifyXpath(XPathType originalXpath) {
        logger.trace("XPath generated by XMLUnit {}", (Object)originalXpath);
        List segments = originalXpath.toSegments();
        List modifiedSegments = new ArrayList();
        if (segments.size() > 2) {
            modifiedSegments = segments.subList(1, segments.size() - 1);
        }
        XPathType modifiedXpath = new XPathType(modifiedSegments);
        logger.trace("XPath modified for midPoint functionality {}", (Object)modifiedXpath.getXPath());
        return modifiedXpath;
    }

    private static Node getReplacePropertyNode(Node testNode, XPathType xpathForChange, String replacePropertyName) {
        Node node = testNode;
        List segments = xpathForChange.toSegments();
        for (int j = segments.size() - 1; j >= 0; --j) {
            XPathSegment segment = (XPathSegment)segments.get(j);
            if (replacePropertyName.equals(segment.getQName().getLocalPart())) {
                return node;
            }
            node = node instanceof AttrNSImpl ? ((AttrNSImpl)node).getOwnerElement() : node.getParentNode();
        }
        throw new IllegalArgumentException("Error getting node for replace property");
    }

    private static XPathType getXPathTypeForReplaceProperty(XPathType xpathForChange, String replacePropertyName) {
        List segments = xpathForChange.toSegments();
        int segmentWithReplaceProperty = 0;
        for (int j = segments.size() - 1; j >= 0; --j) {
            XPathSegment segment = (XPathSegment)segments.get(j);
            if (!replacePropertyName.equals(segment.getQName().getLocalPart())) continue;
            segmentWithReplaceProperty = j;
            break;
        }
        List modifiedSegments = segments.subList(0, segmentWithReplaceProperty + 1);
        return new XPathType(modifiedSegments);
    }

    private static boolean isReplacePropertyModificationRegistrered(ObjectModificationType changes, XPathType xpathType, String replacePropertyName) {
        for (PropertyModificationType change : changes.getPropertyModification()) {
            if (!PropertyModificationTypeType.replace.equals((Object)change.getModificationType())) continue;
            XPathType registeredXPath = new XPathType(change.getPath());
            if (!xpathType.getXPath().equals(registeredXPath.getXPath()) || !replacePropertyName.equals(((Element)change.getValue().getAny().get(0)).getLocalName())) continue;
            return true;
        }
        return false;
    }

    private static ObjectModificationType calculateChanges(InputStream inputStreamOld, InputStream inputStreamNew, String objectOid) throws DiffException {
        CalculateXmlDiff.setupXmlUnit();
        List<Difference> l = CalculateXmlDiff.calculateXmlUnitDifferences(inputStreamOld, inputStreamNew);
        ObjectModificationType changes = new ObjectModificationType();
        if (null == l || l.isEmpty()) {
            logger.trace("No differences found. Returning empty list of differences");
            return changes;
        }
        changes.setOid(objectOid);
        logger.trace("Iterate through differences and create relative changes out of them");
        PropertyModificationType change = null;
        for (Difference diff : l) {
            XPathType xpathType;
            logger.trace("Start processing of difference: {}", (Object)diff.getDescription());
            if (DiffConstants.isForReplaceProperty((Difference)diff)) {
                String replacePropertyName = DiffConstants.getReplacePropertyName((Difference)diff);
                if (null != diff.getTestNodeDetail().getXpathLocation()) {
                    XPathType differenceXpath = new XPathType(diff.getTestNodeDetail().getXpathLocation(), diff.getTestNodeDetail().getNode());
                    xpathType = CalculateXmlDiff.getXPathTypeForReplaceProperty(differenceXpath, replacePropertyName);
                    if (CalculateXmlDiff.isReplacePropertyModificationRegistrered(changes, CalculateXmlDiff.modifyXpath(xpathType), replacePropertyName)) continue;
                    Node testNodeWithReplaceProperty = CalculateXmlDiff.getReplacePropertyNode(diff.getTestNodeDetail().getNode(), differenceXpath, replacePropertyName);
                    change = ObjectTypeUtil.createPropertyModificationType(PropertyModificationTypeType.replace, CalculateXmlDiff.modifyXpath(xpathType), testNodeWithReplaceProperty);
                    changes.getPropertyModification().add(change);
                    continue;
                }
            }
            switch (diff.getId()) {
                case 18: 
                case 22: {
                    if (StringUtils.isEmpty((String)diff.getTestNodeDetail().getXpathLocation())) {
                        xpathType = CalculateXmlDiff.modifyXpath(diff.getControlNodeDetail().getXpathLocation(), diff.getControlNodeDetail().getNode());
                        change = ObjectTypeUtil.createPropertyModificationType(PropertyModificationTypeType.delete, xpathType, (Element)diff.getControlNodeDetail().getNode());
                        break;
                    }
                    PropertyModificationTypeType changeType = CalculateXmlDiff.decideModificationTypeForChildNodeNotFound(diff);
                    xpathType = CalculateXmlDiff.modifyXpath(diff.getTestNodeDetail().getXpathLocation(), diff.getTestNodeDetail().getNode());
                    change = ObjectTypeUtil.createPropertyModificationType(changeType, xpathType, (Element)diff.getTestNodeDetail().getNode());
                    break;
                }
                case 14: {
                    String generatedXpath = diff.getTestNodeDetail().getXpathLocation();
                    String modifiedPath = StringUtils.substring((String)generatedXpath, (int)0, (int)generatedXpath.lastIndexOf("/"));
                    xpathType = CalculateXmlDiff.modifyXpath(modifiedPath, diff.getTestNodeDetail().getNode().getParentNode());
                    change = ObjectTypeUtil.createPropertyModificationType(PropertyModificationTypeType.replace, xpathType, (Element)diff.getTestNodeDetail().getNode().getParentNode());
                }
            }
            if (null == change) continue;
            changes.getPropertyModification().add(change);
            logger.trace("Finished processing of difference {}. Relative change for difference is change = {}", (Object)diff.getDescription(), (Object)DebugUtil.prettyPrint(change));
            if (null != change.getValue()) {
                logger.trace("Relative change value= {}", (Object)DOMUtil.serializeDOMToString((Node)change.getValue().getAny().get(0)));
                continue;
            }
            logger.trace("Relative change value was null");
        }
        logger.trace("Finished relative changes processing");
        logger.debug("Returning differences stored as relative changes = {}", (Object)changes);
        return changes;
    }
}

