/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.util;

import com.evolveum.midpoint.xml.schema.SchemaConstants;
import com.evolveum.midpoint.xml.schema.XPathType;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.Validate;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class QueryUtil {
    public static Element createTypeFilter(Document doc, String uri) {
        Validate.notNull((Object)doc);
        Validate.notNull((Object)uri);
        Validate.notEmpty((String)uri);
        Element type = doc.createElementNS(SchemaConstants.C_FILTER_TYPE.getNamespaceURI(), SchemaConstants.C_FILTER_TYPE.getLocalPart());
        type.setAttributeNS(SchemaConstants.C_FILTER_TYPE_URI.getNamespaceURI(), SchemaConstants.C_FILTER_TYPE_URI.getLocalPart(), uri);
        return type;
    }

    public static Element createEqualFilter(Document doc, XPathType xpath, List<Element> values) {
        Validate.notNull((Object)doc);
        Validate.notNull(values);
        Validate.notEmpty(values);
        Element equal = doc.createElementNS(SchemaConstants.C_FILTER_EQUAL.getNamespaceURI(), SchemaConstants.C_FILTER_EQUAL.getLocalPart());
        Element value = doc.createElementNS(SchemaConstants.C_FILTER_VALUE.getNamespaceURI(), SchemaConstants.C_FILTER_VALUE.getLocalPart());
        for (Element val : values) {
            value.appendChild(doc.importNode(val, true));
        }
        if (xpath != null) {
            Element path = xpath.toElement(SchemaConstants.C_FILTER_PATH, doc);
            equal.appendChild(doc.importNode(path, true));
        }
        equal.appendChild(doc.importNode(value, true));
        return equal;
    }

    public static Element createEqualFilter(Document doc, XPathType xpath, Element value) {
        Validate.notNull((Object)doc);
        Validate.notNull((Object)value);
        ArrayList<Element> values = new ArrayList<Element>();
        values.add(value);
        return QueryUtil.createEqualFilter(doc, xpath, values);
    }

    public static Element createAndFilter(Document doc, Element el1, Element el2) {
        Validate.notNull((Object)doc);
        Validate.notNull((Object)el1);
        Validate.notNull((Object)el2);
        Element and = doc.createElementNS(SchemaConstants.C_FILTER_AND.getNamespaceURI(), SchemaConstants.C_FILTER_AND.getLocalPart());
        and.appendChild(el1);
        and.appendChild(el2);
        return and;
    }
}

