/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.access.hierarchicalroles;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.access.hierarchicalroles.CycleInRoleHierarchyException;
import org.springframework.security.access.hierarchicalroles.RoleHierarchy;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.authority.GrantedAuthorityImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoleHierarchyImpl
implements RoleHierarchy {
    private static final Log logger = LogFactory.getLog(RoleHierarchyImpl.class);
    private String roleHierarchyStringRepresentation = null;
    private Map<GrantedAuthority, Set<GrantedAuthority>> rolesReachableInOneStepMap = null;
    private Map<GrantedAuthority, Set<GrantedAuthority>> rolesReachableInOneOrMoreStepsMap = null;

    public void setHierarchy(String roleHierarchyStringRepresentation) {
        this.roleHierarchyStringRepresentation = roleHierarchyStringRepresentation;
        logger.debug((Object)("setHierarchy() - The following role hierarchy was set: " + roleHierarchyStringRepresentation));
        this.buildRolesReachableInOneStepMap();
        this.buildRolesReachableInOneOrMoreStepsMap();
    }

    @Override
    public Collection<GrantedAuthority> getReachableGrantedAuthorities(Collection<GrantedAuthority> authorities) {
        if (authorities == null || authorities.isEmpty()) {
            return AuthorityUtils.NO_AUTHORITIES;
        }
        HashSet<GrantedAuthority> reachableRoles = new HashSet<GrantedAuthority>();
        for (GrantedAuthority authority : authorities) {
            this.addReachableRoles(reachableRoles, authority);
            Set<GrantedAuthority> additionalReachableRoles = this.getRolesReachableInOneOrMoreSteps(authority);
            if (additionalReachableRoles == null) continue;
            reachableRoles.addAll(additionalReachableRoles);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("getReachableGrantedAuthorities() - From the roles " + authorities + " one can reach " + reachableRoles + " in zero or more steps."));
        }
        ArrayList<GrantedAuthority> reachableRoleList = new ArrayList<GrantedAuthority>(reachableRoles.size());
        reachableRoleList.addAll(reachableRoles);
        return reachableRoleList;
    }

    private void addReachableRoles(Set<GrantedAuthority> reachableRoles, GrantedAuthority authority) {
        for (GrantedAuthority testAuthority : reachableRoles) {
            String testKey = testAuthority.getAuthority();
            if (testKey == null || !testKey.equals(authority.getAuthority())) continue;
            return;
        }
        reachableRoles.add(authority);
    }

    private Set<GrantedAuthority> getRolesReachableInOneOrMoreSteps(GrantedAuthority authority) {
        if (authority.getAuthority() == null) {
            return null;
        }
        for (GrantedAuthority testAuthority : this.rolesReachableInOneOrMoreStepsMap.keySet()) {
            String testKey = testAuthority.getAuthority();
            if (testKey == null || !testKey.equals(authority.getAuthority())) continue;
            return this.rolesReachableInOneOrMoreStepsMap.get(testAuthority);
        }
        return null;
    }

    private void buildRolesReachableInOneStepMap() {
        Pattern pattern = Pattern.compile("(\\s*([^\\s>]+)\\s*\\>\\s*([^\\s>]+))");
        Matcher roleHierarchyMatcher = pattern.matcher(this.roleHierarchyStringRepresentation);
        this.rolesReachableInOneStepMap = new HashMap<GrantedAuthority, Set<GrantedAuthority>>();
        while (roleHierarchyMatcher.find()) {
            GrantedAuthorityImpl higherRole = new GrantedAuthorityImpl(roleHierarchyMatcher.group(2));
            GrantedAuthorityImpl lowerRole = new GrantedAuthorityImpl(roleHierarchyMatcher.group(3));
            HashSet<GrantedAuthority> rolesReachableInOneStepSet = null;
            if (!this.rolesReachableInOneStepMap.containsKey(higherRole)) {
                rolesReachableInOneStepSet = new HashSet();
                this.rolesReachableInOneStepMap.put(higherRole, rolesReachableInOneStepSet);
            } else {
                rolesReachableInOneStepSet = this.rolesReachableInOneStepMap.get(higherRole);
            }
            this.addReachableRoles(rolesReachableInOneStepSet, lowerRole);
            logger.debug((Object)("buildRolesReachableInOneStepMap() - From role " + higherRole + " one can reach role " + lowerRole + " in one step."));
        }
    }

    private void buildRolesReachableInOneOrMoreStepsMap() {
        this.rolesReachableInOneOrMoreStepsMap = new HashMap<GrantedAuthority, Set<GrantedAuthority>>();
        for (GrantedAuthority role : this.rolesReachableInOneStepMap.keySet()) {
            HashSet<GrantedAuthority> rolesToVisitSet = new HashSet<GrantedAuthority>();
            if (this.rolesReachableInOneStepMap.containsKey(role)) {
                rolesToVisitSet.addAll((Collection)this.rolesReachableInOneStepMap.get(role));
            }
            HashSet<GrantedAuthority> visitedRolesSet = new HashSet<GrantedAuthority>();
            while (!rolesToVisitSet.isEmpty()) {
                GrantedAuthority aRole = (GrantedAuthority)rolesToVisitSet.iterator().next();
                rolesToVisitSet.remove(aRole);
                this.addReachableRoles(visitedRolesSet, aRole);
                if (!this.rolesReachableInOneStepMap.containsKey(aRole)) continue;
                Set<GrantedAuthority> newReachableRoles = this.rolesReachableInOneStepMap.get(aRole);
                if (rolesToVisitSet.contains(role) || visitedRolesSet.contains(role)) {
                    throw new CycleInRoleHierarchyException();
                }
                rolesToVisitSet.addAll(newReachableRoles);
            }
            this.rolesReachableInOneOrMoreStepsMap.put(role, visitedRolesSet);
            logger.debug((Object)("buildRolesReachableInOneOrMoreStepsMap() - From role " + role + " one can reach " + visitedRolesSet + " in one or more steps."));
        }
    }
}

