/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.renderkit.dom_html_basic;

import com.icesoft.faces.context.DOMContext;
import com.icesoft.faces.renderkit.dom_html_basic.DomBasicRenderer;
import java.io.IOException;
import java.util.Iterator;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIMessages;
import javax.faces.context.FacesContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class MessagesRenderer
extends DomBasicRenderer {
    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        MessagesRenderer.validateParameters(facesContext, uiComponent, UIMessages.class);
    }

    public void encodeChildren(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        MessagesRenderer.validateParameters(facesContext, uiComponent, UIMessages.class);
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        UIComponent uiform;
        Boolean visible;
        boolean isVisible;
        String lang;
        String dir;
        MessagesRenderer.validateParameters(facesContext, uiComponent, UIMessages.class);
        boolean renderLater = uiComponent.getAttributes().containsKey("$render-later$");
        DOMContext domContext = null;
        domContext = !renderLater ? DOMContext.attachDOMContext(facesContext, uiComponent) : DOMContext.reattachDOMContext(facesContext, uiComponent);
        Iterator messagesIterator = null;
        boolean retrieveGlobalMessagesOnly = ((UIMessages)uiComponent).isGlobalOnly();
        messagesIterator = retrieveGlobalMessagesOnly ? facesContext.getMessages(null) : facesContext.getMessages();
        Element parentTarget = null;
        boolean tableLayout = false;
        String layout = (String)uiComponent.getAttributes().get("layout");
        if (layout != null && layout.toLowerCase().equals("table")) {
            tableLayout = true;
            parentTarget = domContext.createElement("table");
        } else {
            parentTarget = domContext.createElement("ul");
        }
        if (!domContext.isInitialized()) {
            domContext.setRootNode(parentTarget);
            MessagesRenderer.setRootElementId(facesContext, parentTarget, uiComponent);
        }
        if ((dir = (String)uiComponent.getAttributes().get("dir")) != null) {
            parentTarget.setAttribute("dir", dir);
        }
        if ((lang = (String)uiComponent.getAttributes().get("lang")) != null) {
            parentTarget.setAttribute("lang", lang);
        }
        boolean bl = isVisible = (visible = (Boolean)uiComponent.getAttributes().get("visible")) == null || visible != false;
        if (!isVisible || !messagesIterator.hasNext()) {
            parentTarget.setAttribute("style", "display:none;");
        }
        if (renderLater && (uiform = MessagesRenderer.findForm(uiComponent)) != null) {
            uiform.getAttributes().remove("$ice-msgs$");
            uiComponent.getAttributes().remove("$render-later$");
        }
        if (!messagesIterator.hasNext()) {
            Element emptyChild = null;
            emptyChild = tableLayout ? (Element)domContext.createElement("tr").appendChild(domContext.createElement("td")) : domContext.createElement("li");
            parentTarget.appendChild(emptyChild);
            UIComponent uiform2 = MessagesRenderer.findForm(uiComponent);
            if (!renderLater && uiform2 != null) {
                uiform2.getAttributes().put("$ice-msgs$", uiComponent);
                uiComponent.getAttributes().put("$render-later$", "true");
            }
            domContext.stepOver();
            return;
        }
        FacesMessage nextFacesMessage = null;
        while (messagesIterator.hasNext()) {
            Text textNode;
            nextFacesMessage = (FacesMessage)messagesIterator.next();
            if (nextFacesMessage.isRendered() && !((UIMessages)uiComponent).isRedisplay()) {
                return;
            }
            nextFacesMessage.rendered();
            String[] styleAndStyleClass = MessagesRenderer.getStyleAndStyleClass(uiComponent, nextFacesMessage);
            String style = styleAndStyleClass[0];
            String styleClass = styleAndStyleClass[1];
            String[] summaryAndDetail = this.getSummaryAndDetail(nextFacesMessage);
            String summary = summaryAndDetail[0];
            String detail = summaryAndDetail[1];
            boolean showSummary = ((UIMessages)uiComponent).isShowSummary();
            boolean showDetail = ((UIMessages)uiComponent).isShowDetail();
            Node nextTableData = null;
            if (tableLayout) {
                Element tr = domContext.createElement("tr");
                Element td = domContext.createElement("td");
                tr.appendChild(td);
                parentTarget.appendChild(tr);
                nextTableData = td;
            }
            Element nextMessageSpan = domContext.createElement("span");
            if (tableLayout) {
                nextTableData.appendChild(nextMessageSpan);
            } else {
                Element li = domContext.createElement("li");
                parentTarget.appendChild(li);
                li.appendChild(nextMessageSpan);
            }
            if (null != styleClass) {
                nextMessageSpan.setAttribute("class", styleClass);
            }
            if (style != null && style.length() > 0) {
                nextMessageSpan.setAttribute("style", style);
            } else {
                nextMessageSpan.removeAttribute("style");
            }
            boolean tooltip = this.getToolTipAttribute(uiComponent);
            String title = (String)uiComponent.getAttributes().get("title");
            if (title == null && tooltip && showSummary) {
                title = summary;
            }
            if (title == null && tooltip && showDetail) {
                title = detail;
            }
            if (title != null) {
                nextMessageSpan.setAttribute("title", title);
            }
            if (showSummary && showDetail && tooltip) {
                textNode = domContext.getDocument().createTextNode(detail);
                nextMessageSpan.appendChild(textNode);
                continue;
            }
            if (showSummary) {
                textNode = domContext.createTextNode(summary);
                nextMessageSpan.appendChild(textNode);
            }
            if (!showDetail) continue;
            textNode = domContext.createTextNode(detail);
            nextMessageSpan.appendChild(textNode);
        }
        domContext.stepOver();
    }

    private void writeStream(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        String sstyle;
        DOMContext domContext = DOMContext.getDOMContext(facesContext, uiComponent);
        Element root = domContext.createRootElement("span");
        Text text = domContext.createTextNode("List of Messages");
        Object style = uiComponent.getAttributes().get("style");
        String string = sstyle = style == null ? null : style.toString();
        if (sstyle != null && sstyle.length() > 0) {
            root.setAttribute("style", sstyle);
        } else {
            root.removeAttribute("style");
        }
        root.appendChild(text);
        domContext.stepOver();
    }
}

