/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.spml;

import java.util.HashMap;
import java.util.List;
import org.identityconnectors.common.script.ScriptExecutor;
import org.identityconnectors.common.script.ScriptExecutorFactory;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.Uid;
import org.identityconnectors.framework.common.objects.filter.AbstractFilterTranslator;
import org.identityconnectors.framework.common.objects.filter.ContainsFilter;
import org.identityconnectors.framework.common.objects.filter.EndsWithFilter;
import org.identityconnectors.framework.common.objects.filter.EqualsFilter;
import org.identityconnectors.framework.common.objects.filter.GreaterThanOrEqualFilter;
import org.identityconnectors.framework.common.objects.filter.LessThanOrEqualFilter;
import org.identityconnectors.framework.common.objects.filter.StartsWithFilter;
import org.identityconnectors.spml.SpmlConfiguration;
import org.identityconnectors.spml.SpmlConnection;
import org.openspml.v2.profiles.dsml.And;
import org.openspml.v2.profiles.dsml.DSMLProfileException;
import org.openspml.v2.profiles.dsml.DSMLValue;
import org.openspml.v2.profiles.dsml.EqualityMatch;
import org.openspml.v2.profiles.dsml.FilterItem;
import org.openspml.v2.profiles.dsml.GreaterOrEqual;
import org.openspml.v2.profiles.dsml.LessOrEqual;
import org.openspml.v2.profiles.dsml.Or;
import org.openspml.v2.profiles.dsml.Substrings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpmlFilterTranslator
extends AbstractFilterTranslator<FilterItem> {
    private ScriptExecutorFactory _factory;
    private SpmlConnection _connection;
    private SpmlConfiguration _configuration;
    private ScriptExecutor _mapQueryNameExecutor;

    public SpmlFilterTranslator(SpmlConfiguration configuration, SpmlConnection connection) {
        this._connection = connection;
        this._configuration = configuration;
        this._factory = ScriptExecutorFactory.newInstance((String)configuration.getScriptingLanguage());
        try {
            String mapQueryNameCommand = this._configuration.getMapQueryNameCommand();
            if (mapQueryNameCommand != null && mapQueryNameCommand.length() > 0) {
                this._mapQueryNameExecutor = this._factory.newScriptExecutor(((Object)((Object)this)).getClass().getClassLoader(), mapQueryNameCommand, true);
            }
        }
        catch (Exception e) {
            throw new ConnectorException(this._configuration.getMessage("MAPQUERYNAME_SCRIPT_ERROR"), (Throwable)e);
        }
    }

    protected FilterItem createAndExpression(FilterItem leftExpression, FilterItem rightExpression) {
        if (leftExpression != null && rightExpression != null) {
            And and = new And(new FilterItem[]{leftExpression, rightExpression});
            return and;
        }
        if (leftExpression != null) {
            return leftExpression;
        }
        if (rightExpression != null) {
            return rightExpression;
        }
        return (FilterItem)super.createAndExpression((Object)leftExpression, (Object)rightExpression);
    }

    protected FilterItem createOrExpression(FilterItem leftExpression, FilterItem rightExpression) {
        if (leftExpression != null && rightExpression != null) {
            Or or = new Or(new FilterItem[]{leftExpression, rightExpression});
            return or;
        }
        return (FilterItem)super.createOrExpression((Object)leftExpression, (Object)rightExpression);
    }

    protected FilterItem createStartsWithExpression(StartsWithFilter filter, boolean not) {
        Attribute attribute = filter.getAttribute();
        List value = attribute.getValue();
        try {
            if (!not && this.isSingleString(value)) {
                return new Substrings(this.mapQueryName(attribute.getName()), new DSMLValue((String)value.get(0)), new DSMLValue[0], null);
            }
            return (FilterItem)super.createStartsWithExpression(filter, not);
        }
        catch (DSMLProfileException e) {
            throw ConnectorException.wrap((Throwable)e);
        }
    }

    protected FilterItem createContainsExpression(ContainsFilter filter, boolean not) {
        Attribute attribute = filter.getAttribute();
        List value = attribute.getValue();
        try {
            if (!not && this.isSingleString(value)) {
                return new Substrings(this.mapQueryName(attribute.getName()), null, new DSMLValue[]{new DSMLValue((String)value.get(0))}, null);
            }
            return (FilterItem)super.createContainsExpression(filter, not);
        }
        catch (DSMLProfileException e) {
            throw ConnectorException.wrap((Throwable)e);
        }
    }

    protected FilterItem createEndsWithExpression(EndsWithFilter filter, boolean not) {
        Attribute attribute = filter.getAttribute();
        List value = attribute.getValue();
        try {
            if (!not && this.isSingleString(value)) {
                return new Substrings(this.mapQueryName(attribute.getName()), null, new DSMLValue[0], new DSMLValue((String)value.get(0)));
            }
            return (FilterItem)super.createEndsWithExpression(filter, not);
        }
        catch (DSMLProfileException e) {
            throw ConnectorException.wrap((Throwable)e);
        }
    }

    protected FilterItem createEqualsExpression(EqualsFilter filter, boolean not) {
        Attribute attribute = filter.getAttribute();
        List value = attribute.getValue();
        try {
            if (!not && this.isSingleString(value)) {
                return new EqualityMatch(this.mapQueryName(attribute.getName()), new DSMLValue((String)value.get(0)));
            }
            return (FilterItem)super.createEqualsExpression(filter, not);
        }
        catch (DSMLProfileException e) {
            throw ConnectorException.wrap((Throwable)e);
        }
    }

    protected FilterItem createGreaterThanOrEqualExpression(GreaterThanOrEqualFilter filter, boolean not) {
        Attribute attribute = filter.getAttribute();
        List value = attribute.getValue();
        try {
            if (!not && this.isSingleString(value)) {
                GreaterOrEqual goe = new GreaterOrEqual();
                goe.setName(this.mapQueryName(attribute.getName()));
                goe.setValue(new DSMLValue((String)value.get(0)));
                return goe;
            }
            return (FilterItem)super.createGreaterThanOrEqualExpression(filter, not);
        }
        catch (DSMLProfileException e) {
            throw ConnectorException.wrap((Throwable)e);
        }
    }

    protected FilterItem createLessThanOrEqualExpression(LessThanOrEqualFilter filter, boolean not) {
        Attribute attribute = filter.getAttribute();
        List value = attribute.getValue();
        try {
            if (!not && this.isSingleString(value)) {
                LessOrEqual loe = new LessOrEqual();
                loe.setName(this.mapQueryName(attribute.getName()));
                loe.setValue(new DSMLValue((String)value.get(0)));
                return loe;
            }
            return (FilterItem)super.createLessThanOrEqualExpression(filter, not);
        }
        catch (DSMLProfileException e) {
            throw ConnectorException.wrap((Throwable)e);
        }
    }

    private String mapQueryName(String name) {
        if (Uid.NAME.equals(name)) {
            return "psoID";
        }
        try {
            if (this._mapQueryNameExecutor != null) {
                HashMap<String, Object> arguments = new HashMap<String, Object>();
                arguments.put("name", name);
                arguments.put("configuration", (Object)this._configuration);
                arguments.put("memory", this._connection.getMemory());
                return (String)this._mapQueryNameExecutor.execute(arguments);
            }
        }
        catch (Exception e) {
            throw new ConnectorException(this._configuration.getMessage("MAPQUERYNAME_SCRIPT_ERROR"), (Throwable)e);
        }
        return name;
    }

    private boolean isSingleString(List<Object> value) {
        return value != null && value.size() == 1 && value.get(0) instanceof String;
    }
}

