/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.spml;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.common.script.ScriptExecutor;
import org.identityconnectors.common.script.ScriptExecutorFactory;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.spml.SpmlConfiguration;
import org.openspml.v2.client.Spml2Client;
import org.openspml.v2.msg.spml.ErrorCode;
import org.openspml.v2.msg.spml.ExecutionMode;
import org.openspml.v2.msg.spml.LookupRequest;
import org.openspml.v2.msg.spml.LookupResponse;
import org.openspml.v2.msg.spml.PSOIdentifier;
import org.openspml.v2.msg.spml.Request;
import org.openspml.v2.msg.spml.Response;
import org.openspml.v2.msg.spml.ReturnData;
import org.openspml.v2.msg.spml.StatusCode;
import org.openspml.v2.util.Spml2Exception;
import org.openspml.v2.util.Spml2ExceptionWithResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpmlConnection {
    private ScriptExecutorFactory _factory;
    private Log log = Log.getLog(SpmlConnection.class);
    private Spml2Client _client;
    private SpmlConfiguration _configuration;
    private Map<Object, Object> _memory;
    private ScriptExecutor _preSendExecutor;
    private ScriptExecutor _postReceiveExecutor;

    public SpmlConnection(Spml2Client client, SpmlConfiguration configuration) {
        this._client = client;
        this._configuration = configuration;
        this._factory = ScriptExecutorFactory.newInstance((String)configuration.getScriptingLanguage());
        String preCommand = this._configuration.getPreSendCommand();
        String postCommand = this._configuration.getPostReceiveCommand();
        try {
            if (preCommand != null && preCommand.length() > 0) {
                this._preSendExecutor = this._factory.newScriptExecutor(this.getClass().getClassLoader(), preCommand, true);
            }
        }
        catch (Exception e) {
            throw new ConnectorException(this._configuration.getMessage("PRESEND_SCRIPT_ERROR"), (Throwable)e);
        }
        try {
            if (postCommand != null && postCommand.length() > 0) {
                this._postReceiveExecutor = this._factory.newScriptExecutor(this.getClass().getClassLoader(), postCommand, true);
            }
        }
        catch (Exception e) {
            throw new ConnectorException(this._configuration.getMessage("POSTRECEIVE_SCRIPT_ERROR"), (Throwable)e);
        }
        this._memory = new HashMap<Object, Object>();
        String postConnectCommand = this._configuration.getPostConnectCommand();
        try {
            if (postConnectCommand != null && postConnectCommand.length() > 0) {
                ScriptExecutor executor = this._factory.newScriptExecutor(this.getClass().getClassLoader(), postConnectCommand, true);
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("connection", this);
                map.put("username", this._configuration.getUserName());
                map.put("password", this._configuration.getPassword());
                map.put("memory", this.getMemory());
                executor.execute(map);
            }
        }
        catch (Exception e) {
            this.log.error((Throwable)e, "error in SpmlConnection constructor", new Object[0]);
            throw new ConnectorException(this._configuration.getMessage("POSTCONNECT_SCRIPT_ERROR"), (Throwable)e);
        }
        this.log.info("created SpmlConnection", new Object[0]);
    }

    protected Map<Object, Object> getMemory() {
        return this._memory;
    }

    private String toString(Request request) {
        return MessageFormat.format("Request Type=''{0}'',ID=''{1}'',Mode=''{2}''", request.getElementName(), request.getRequestID(), request.getExecutionMode());
    }

    public Response send(Request req) throws Spml2ExceptionWithResponse, Spml2Exception {
        this.log.info("send(''{0}'')", new Object[]{this.toString(req)});
        try {
            if (this._preSendExecutor != null) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("request", req);
                map.put("memory", this._memory);
                this._preSendExecutor.execute(map);
            }
        }
        catch (Exception e) {
            this.log.error((Throwable)e, "error in send", new Object[0]);
            throw new ConnectorException(this._configuration.getMessage("PRESEND_SCRIPT_ERROR"), (Throwable)e);
        }
        Response response = this._client.send(req);
        try {
            if (this._postReceiveExecutor != null) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("response", response);
                map.put("memory", this._memory);
                this._postReceiveExecutor.execute(map);
            }
        }
        catch (Exception e) {
            this.log.error((Throwable)e, "error in receive", new Object[0]);
            throw new ConnectorException(this._configuration.getMessage("POSTRECEIVE_SCRIPT_ERROR"), (Throwable)e);
        }
        return response;
    }

    public void dispose() {
        String preCommand = this._configuration.getPreDisconnectCommand();
        if (preCommand != null && preCommand.length() > 0) {
            ScriptExecutor executor = this._factory.newScriptExecutor(this.getClass().getClassLoader(), preCommand, true);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("connection", this);
            map.put("username", this._configuration.getUserName());
            map.put("password", this._configuration.getPassword());
            map.put("memory", this._memory);
            try {
                executor.execute(map);
            }
            catch (Exception e) {
                throw new ConnectorException(this._configuration.getMessage("PREDISCONNECT_SCRIPT_ERROR"), (Throwable)e);
            }
        }
    }

    public void test() {
        try {
            if (this._configuration.getTargetNames() == null || this._configuration.getTargetNames().length == 0) {
                throw new ConnectorException(this._configuration.getMessage("MAPPING_REQUIRED"));
            }
            this.get("random name", this._configuration.getTargetNames()[0]);
        }
        catch (Exception e) {
            throw ConnectorException.wrap((Throwable)e);
        }
    }

    private void get(String uid, String targetId) {
        try {
            LookupRequest request = new LookupRequest();
            PSOIdentifier psoId = new PSOIdentifier();
            psoId.setTargetID(targetId);
            psoId.setID(uid);
            this.log.info("get(''{0}'')", new Object[]{uid});
            request.setPsoID(psoId);
            request.setRequestID(uid);
            request.setReturnData(ReturnData.EVERYTHING);
            request.setExecutionMode(ExecutionMode.SYNCHRONOUS);
            LookupResponse response = (LookupResponse)this.send((Request)request);
            if (!response.getStatus().equals(StatusCode.SUCCESS) && response.getError() != ErrorCode.NO_SUCH_IDENTIFIER) {
                throw new ConnectorException(this.asString(response.getErrorMessages()));
            }
        }
        catch (Spml2ExceptionWithResponse e) {
            this.log.error((Throwable)e, "get failed:''{0}''", new Object[]{e.getResponse().getError()});
            if (e.getResponse().getError() != ErrorCode.NO_SUCH_IDENTIFIER) {
                throw new ConnectorException(this.asString(e.getResponse().getErrorMessages()));
            }
        }
        catch (Exception e) {
            this.log.error((Throwable)e, "get failed", new Object[0]);
            throw ConnectorException.wrap((Throwable)e);
        }
    }

    protected String asString(String[] strings) {
        if (strings.length == 0) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        for (String string : strings) {
            buffer.append("\n" + string);
        }
        return buffer.toString().substring(1);
    }
}

