/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.spml;

import java.util.Arrays;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.spi.AbstractConfiguration;
import org.identityconnectors.framework.spi.ConfigurationProperty;
import org.identityconnectors.spml.GuardedStringAccessor;

public class SpmlConfiguration
extends AbstractConfiguration {
    private String _userName;
    private GuardedString _password;
    private String _url;
    private String[] _objectClassNames;
    private String[] _spmlClassNames;
    private String[] _targetNames;
    private String[] _nameAttributes;
    private String _preSendCommand;
    private String _postReceiveCommand;
    private String _preDisconnectCommand;
    private String _postConnectCommand;
    private String _mapSetNameCommand;
    private String _mapAttributeCommand;
    private String _mapQueryNameCommand;
    private String _schemaCommand;
    private String _scriptingLanguage;

    public SpmlConfiguration() {
    }

    public SpmlConfiguration(String url, String[] connectorObjectClass, String[] spmlObjectClass, String[] targetClass, String[] nameAttributes, String userName, GuardedString password) {
        this();
        this._url = url;
        this._userName = userName;
        this._nameAttributes = this.arrayCopy(nameAttributes);
        this._password = password;
        this._objectClassNames = this.arrayCopy(connectorObjectClass);
        this._spmlClassNames = this.arrayCopy(spmlObjectClass);
        this._targetNames = this.arrayCopy(targetClass);
    }

    public String getMessage(String key) {
        return this.getConnectorMessages().format(key, key, new Object[0]);
    }

    public String getMessage(String key, Object ... objects) {
        return this.getConnectorMessages().format(key, key, objects);
    }

    private boolean isNull(String string) {
        return string == null || string.length() == 0;
    }

    private boolean isNull(GuardedString string) {
        if (string == null) {
            return true;
        }
        GuardedStringAccessor accessor = new GuardedStringAccessor();
        string.access((GuardedString.Accessor)accessor);
        char[] password = accessor.getArray();
        boolean isNull = password.length == 0;
        Arrays.fill(password, ' ');
        return isNull;
    }

    public void validate() {
        if (this.isNull(this._url)) {
            throw new ConnectorException(this.getMessage("URL_NULL"));
        }
        if (this.isNull(this._userName)) {
            throw new ConnectorException(this.getMessage("USERNAME_NULL"));
        }
        if (this.isNull(this._password)) {
            throw new ConnectorException(this.getMessage("PASSWORD_NULL"));
        }
        if (this._objectClassNames == null) {
            throw new ConnectorException(this.getMessage("OBJECT_CLASS_NULL"));
        }
        if (this._spmlClassNames == null) {
            throw new ConnectorException(this.getMessage("SPML_CLASS_NULL"));
        }
        if (this._targetNames == null) {
            throw new ConnectorException(this.getMessage("TARGET_NULL"));
        }
        if (this._nameAttributes == null) {
            throw new ConnectorException(this.getMessage("NAME_NULL"));
        }
        if (this._scriptingLanguage == null) {
            throw new ConnectorException(this.getMessage("LANGUAGE_NULL"));
        }
        if (this._objectClassNames.length != this._spmlClassNames.length || this._objectClassNames.length != this._targetNames.length || this._objectClassNames.length != this._nameAttributes.length) {
            throw new ConnectorException(this.getMessage("SPML_CLASS_LENGTH"));
        }
    }

    @ConfigurationProperty(order=1, required=true)
    public String getUserName() {
        return this._userName;
    }

    public void setUserName(String userName) {
        this._userName = userName;
    }

    @ConfigurationProperty(order=2, confidential=true, required=true)
    public GuardedString getPassword() {
        return this._password;
    }

    public void setPassword(GuardedString password) {
        this._password = password;
    }

    @ConfigurationProperty(order=3, required=true)
    public String getUrl() {
        return this._url;
    }

    public void setUrl(String url) {
        this._url = url;
    }

    @ConfigurationProperty(order=8)
    public String getScriptingLanguage() {
        return this._scriptingLanguage;
    }

    public void setScriptingLanguage(String language) {
        this._scriptingLanguage = language;
    }

    @ConfigurationProperty(order=9)
    public String getPostConnectCommand() {
        return this._postConnectCommand;
    }

    public void setPostConnectCommand(String loginCommand) {
        this._postConnectCommand = loginCommand;
    }

    @ConfigurationProperty(order=10)
    public String getPreDisconnectCommand() {
        return this._preDisconnectCommand;
    }

    public void setPreDisconnectCommand(String loginCommand) {
        this._preDisconnectCommand = loginCommand;
    }

    @ConfigurationProperty(order=11)
    public String getPreSendCommand() {
        return this._preSendCommand;
    }

    public void setPreSendCommand(String sendCommand) {
        this._preSendCommand = sendCommand;
    }

    @ConfigurationProperty(order=12)
    public String getPostReceiveCommand() {
        return this._postReceiveCommand;
    }

    public void setPostReceiveCommand(String receiveCommand) {
        this._postReceiveCommand = receiveCommand;
    }

    @ConfigurationProperty(order=13)
    public String getMapSetNameCommand() {
        return this._mapSetNameCommand;
    }

    public void setMapSetNameCommand(String setNameCommand) {
        this._mapSetNameCommand = setNameCommand;
    }

    @ConfigurationProperty(order=14)
    public String getMapAttributeCommand() {
        return this._mapAttributeCommand;
    }

    public void setMapAttributeCommand(String attributeCommand) {
        this._mapAttributeCommand = attributeCommand;
    }

    @ConfigurationProperty(order=15)
    public String getMapQueryNameCommand() {
        return this._mapQueryNameCommand;
    }

    public void setMapQueryNameCommand(String queryNameCommand) {
        this._mapQueryNameCommand = queryNameCommand;
    }

    @ConfigurationProperty(order=16)
    public String getSchemaCommand() {
        return this._schemaCommand;
    }

    public void setSchemaCommand(String schemaCommand) {
        this._schemaCommand = schemaCommand;
    }

    @ConfigurationProperty(order=17)
    public String[] getNameAttributes() {
        return this.arrayCopy(this._nameAttributes);
    }

    public void setNameAttributes(String[] attribute) {
        this._nameAttributes = this.arrayCopy(attribute);
    }

    @ConfigurationProperty(order=18)
    public String[] getObjectClassNames() {
        return this.arrayCopy(this._objectClassNames);
    }

    public void setObjectClassNames(String[] classNames) {
        this._objectClassNames = this.arrayCopy(classNames);
    }

    @ConfigurationProperty(order=19)
    public String[] getSpmlClassNames() {
        return this.arrayCopy(this._spmlClassNames);
    }

    public void setSpmlClassNames(String[] classNames) {
        this._spmlClassNames = this.arrayCopy(classNames);
    }

    @ConfigurationProperty(order=20)
    public String[] getTargetNames() {
        return this.arrayCopy(this._targetNames);
    }

    public void setTargetNames(String[] targetNames) {
        this._targetNames = this.arrayCopy(targetNames);
    }

    String[] arrayCopy(String[] array) {
        if (array == null) {
            return null;
        }
        String[] result = new String[array.length];
        System.arraycopy(array, 0, result, 0, result.length);
        return result;
    }
}

