/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.impl.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.logging.Logger;
import java.util.zip.GZIPOutputStream;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import org.icefaces.impl.renderkit.html_basic.SingleSubmitRenderer;

public class Util {
    private static Logger log = Logger.getLogger(Util.class.getName());
    private static List DEFAULT_EXCLUSIONS = Arrays.asList("image/gif", "image/png", "image/jpeg", "image/tiff", "application/pdf", "application/zip", "application/x-compress", "application/x-gzip ", "application/java-archive", "video/x-sgi-movie", "audio/x-mpeg ", "video/mp4", "video/mpeg");
    public static final DateFormat HTTP_DATE = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.ENGLISH);

    public static void copyStream(InputStream in, OutputStream out) throws IOException {
        byte[] buf = new byte[1000];
        int l = 1;
        while (l > 0) {
            l = in.read(buf);
            if (l <= 0) continue;
            out.write(buf, 0, l);
        }
    }

    public static void compressStream(InputStream in, OutputStream out) throws IOException {
        GZIPOutputStream gzip = new GZIPOutputStream(out);
        Util.copyStream(in, gzip);
        gzip.finish();
    }

    public static boolean acceptGzip(ExternalContext externalContext) {
        String acceptHeader = (String)externalContext.getRequestHeaderMap().get("Accept-Encoding");
        boolean acceptGzip = null != acceptHeader && acceptHeader.indexOf("gzip") >= 0;
        return acceptGzip;
    }

    public static boolean shouldCompress(String contentType) {
        return !DEFAULT_EXCLUSIONS.contains(contentType);
    }

    public static boolean withinSingleSubmit(UIComponent component) {
        for (UIComponent parent = component; null != parent; parent = parent.getParent()) {
            if (!parent.getAttributes().containsKey(SingleSubmitRenderer.SINGLE_SUBMIT_MARKER)) continue;
            return true;
        }
        return false;
    }
}

