/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.model.xpath;

import com.evolveum.midpoint.api.logging.Trace;
import com.evolveum.midpoint.logging.TraceManager;
import com.evolveum.midpoint.model.filter.Filter;
import com.evolveum.midpoint.model.filter.FilterManager;
import com.evolveum.midpoint.model.xpath.SchemaHandlingException;
import com.evolveum.midpoint.provisioning.schema.ResourceAttributeDefinition;
import com.evolveum.midpoint.provisioning.schema.ResourceObjectDefinition;
import com.evolveum.midpoint.provisioning.schema.ResourceSchema;
import com.evolveum.midpoint.provisioning.schema.util.DOMToSchemaParser;
import com.evolveum.midpoint.util.DOMUtil;
import com.evolveum.midpoint.util.DebugUtil;
import com.evolveum.midpoint.util.ObjectTypeUtil;
import com.evolveum.midpoint.util.Variable;
import com.evolveum.midpoint.util.XPathUtil;
import com.evolveum.midpoint.util.jaxb.JAXBUtil;
import com.evolveum.midpoint.util.patch.PatchException;
import com.evolveum.midpoint.util.patch.PatchXml;
import com.evolveum.midpoint.xml.ns._public.common.common_1.AccountConstructionType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.AccountShadowType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.AttributeDescriptionType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ObjectFactory;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ObjectModificationType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ObjectReferenceType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ObjectType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.PropertyConstructionType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.PropertyModificationType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.PropertyModificationTypeType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.PropertyReferenceListType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ResourceObjectShadowType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ResourceType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.SchemaHandlingType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.UserTemplateType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.UserType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ValueConstructionType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ValueFilterType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.VariableDefinitionType;
import com.evolveum.midpoint.xml.ns._public.model.model_1.FaultMessage;
import com.evolveum.midpoint.xml.ns._public.model.model_1.ModelPortType;
import com.evolveum.midpoint.xml.schema.ExpressionHolder;
import com.evolveum.midpoint.xml.schema.SchemaConstants;
import com.evolveum.midpoint.xml.schema.UserTypeUtil;
import com.evolveum.midpoint.xml.schema.ValueAssignmentHolder;
import com.evolveum.midpoint.xml.schema.XPathSegment;
import com.evolveum.midpoint.xml.schema.XPathType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Component
public class SchemaHandling
extends XPathUtil {
    private static final Trace TRACE = TraceManager.getTrace(SchemaHandling.class);
    public static final String TAG_VALUE_EXPRESSION = "valueExpression";
    public static final String TAG_VALUE = "value";
    public static final String TAG_ATTRIBUTE_REF = "ref";
    @Autowired
    private ModelPortType model;
    @Autowired
    private FilterManager filterManager;

    private ResourceSchema createResourceSchema(ResourceType resourceType) throws SchemaHandlingException {
        DOMToSchemaParser parser = new DOMToSchemaParser();
        Element elementResourceSchema = null;
        if (null != resourceType.getSchema() && !resourceType.getSchema().getAny().isEmpty()) {
            for (Element e : resourceType.getSchema().getAny()) {
                if (!"http://www.w3.org/2001/XMLSchema".equals(e.getNamespaceURI()) || !"schema".equals(e.getLocalName())) continue;
                elementResourceSchema = e;
                break;
            }
        }
        ResourceSchema resourceSchema = parser.getSchema(elementResourceSchema);
        return resourceSchema;
    }

    private void evaluateAndApplyOutboundExpressionValues(UserType user, AccountShadowType accountShadow, ResourceType resource) throws SchemaHandlingException {
        TRACE.debug("SCHEMA HANDLING: Account before processing of schema handling: {}", (Object)DebugUtil.prettyPrint((ObjectType)accountShadow));
        TRACE.trace("Account before processing of schema handling: {}", (Object)JAXBUtil.silentMarshalWrap((Object)accountShadow, (QName)SchemaConstants.I_ACCOUNT_TYPE));
        Validate.notNull((Object)user, (String)"user is null");
        Validate.notNull((Object)accountShadow, (String)"accountShadow is null");
        SchemaHandlingType.AccountType accountType = ObjectTypeUtil.getAccountTypeDefinitionFromSchemaHandling((ResourceObjectShadowType)accountShadow, (ResourceType)resource);
        List attributesHandling = accountType.getAttribute();
        Map<QName, Variable> variables = this.getDefaultXPathVariables(user, (ResourceObjectShadowType)accountShadow);
        ResourceObjectDefinition objectDefinition = this.getResourceObjectDefinition(resource);
        for (AttributeDescriptionType attributeHandling : attributesHandling) {
            ResourceAttributeDefinition attributeDefinition = objectDefinition.getAttributeDefinition(attributeHandling.getRef());
            if (null != attributeDefinition) {
                this.insertUserDefinedVariables(attributeHandling, variables);
                this.processOutboundSection(attributeHandling, variables, accountShadow);
                continue;
            }
            TRACE.warn("Attribute {} defined in schema handling is not defined in the resource schema (oid={}). Attribute was not processed", (Object)attributeHandling.getRef(), (Object)resource.getOid());
        }
        TRACE.debug("SCHEMA HANDLING: Account with applied schema handling: {}", (Object)DebugUtil.prettyPrint((ObjectType)accountShadow));
        TRACE.trace("Account with applied schema handling: {}", (Object)JAXBUtil.silentMarshalWrap((Object)accountShadow, (QName)SchemaConstants.I_ACCOUNT_TYPE));
    }

    private UserType evaluateAndApplyInboundExpressionValues(UserType user, ResourceObjectShadowType accountShadow) throws SchemaHandlingException {
        TRACE.debug("INBOUND: User before processing of inbound expressions: {}", (Object)DebugUtil.prettyPrint((ObjectType)user, (boolean)true));
        TRACE.trace("User before processing of inbound expressions: {}", (Object)JAXBUtil.silentMarshalWrap((Object)user, (QName)SchemaConstants.I_USER_TYPE));
        Validate.notNull((Object)user, (String)"user is null");
        Validate.notNull((Object)accountShadow, (String)"accountShadow is null");
        Element domUser = null;
        try {
            domUser = JAXBUtil.objectTypeToDom((Object)user, null);
        }
        catch (JAXBException ex) {
            throw new SchemaHandlingException(ex);
        }
        ResourceType resource = accountShadow.getResource();
        SchemaHandlingType.AccountType accountType = ObjectTypeUtil.getAccountTypeDefinitionFromSchemaHandling((ResourceObjectShadowType)accountShadow, (ResourceType)resource);
        List attributesHandling = accountType.getAttribute();
        Map<QName, Variable> variables = this.getDefaultXPathVariables(user, accountShadow);
        ResourceObjectDefinition objectDefinition = this.getResourceObjectDefinition(resource);
        for (AttributeDescriptionType attributeHandling : attributesHandling) {
            ResourceAttributeDefinition attributeDefinition = objectDefinition.getAttributeDefinition(attributeHandling.getRef());
            if (null != attributeDefinition) {
                domUser = (Element)this.processInboundSection(attributeHandling, variables, accountShadow, domUser, user);
                continue;
            }
            TRACE.warn("Attribute {} defined in schema handling is not defined in the resource schema (oid={}). Attribute was not processed", (Object)attributeHandling.getRef(), (Object)resource.getOid());
        }
        try {
            JAXBElement jaxbUser = (JAXBElement)JAXBUtil.unmarshal((String)DOMUtil.serializeDOMToString((Node)domUser));
            user = (UserType)jaxbUser.getValue();
        }
        catch (JAXBException ex) {
            throw new SchemaHandlingException(ex);
        }
        TRACE.debug("INBOUND: User with applied inbound expressions: {}", (Object)DebugUtil.prettyPrint((ObjectType)user, (boolean)true));
        TRACE.trace("User with applied inbound expressions: {}", (Object)JAXBUtil.silentMarshalWrap((Object)user, (QName)SchemaConstants.I_USER_TYPE));
        return user;
    }

    private String evaluateExpression(Map<QName, Variable> variables, ExpressionHolder expressionHolder) {
        return (String)this.evaluateExpr(variables, expressionHolder, XPathConstants.STRING);
    }

    private void applyValue(AccountShadowType account, QName accountAttributeName, String accountAttributeValue) {
        Validate.notNull((Object)account, (String)"account is null");
        Validate.notNull((Object)accountAttributeName, (String)"accountAttributeName is null");
        TRACE.trace("Account's attribute '{}' assign value '{}'", (Object)accountAttributeName, (Object)accountAttributeValue);
        String namespace = accountAttributeName.getNamespaceURI();
        String localName = accountAttributeName.getLocalPart();
        TRACE.trace("Account's attribute namespace = '{}' and name = '{}'", new Object[]{namespace, localName});
        ResourceObjectShadowType.Attributes attrs = account.getAttributes();
        if (null == attrs) {
            attrs = new ResourceObjectShadowType.Attributes();
            account.setAttributes(attrs);
        }
        List attributes = attrs.getAny();
        for (Element attribute : attributes) {
            TRACE.trace("attribute: namespaceURI = '{}', localName = '{}'", (Object)attribute.getNamespaceURI(), (Object)attribute.getLocalName());
            if (!localName.equals(attribute.getLocalName()) || !namespace.equals(attribute.getNamespaceURI())) continue;
            attribute.setTextContent(accountAttributeValue);
            TRACE.trace("Changed account's attribute '{}' value to '{}'", (Object)accountAttributeName, (Object)accountAttributeValue);
            return;
        }
        TRACE.trace("Account's attribute '{}' was not set, yet", (Object)accountAttributeName);
        Document doc = DOMUtil.getDocument();
        Element element = StringUtils.isNotEmpty((String)accountAttributeName.getNamespaceURI()) ? doc.createElementNS(namespace, localName) : doc.createElementNS("http://midpoint.evolveum.com/xml/ns/public/common/common-1.xsd", accountAttributeName.getLocalPart());
        element.setTextContent(accountAttributeValue);
        attributes.add(element);
        TRACE.trace("Created account's attribute '{}' with value '{}'", (Object)accountAttributeName, (Object)accountAttributeValue);
    }

    private Map<QName, Variable> getDefaultXPathVariables(UserType user, ResourceObjectShadowType account) {
        HashMap<QName, Variable> variables = new HashMap<QName, Variable>();
        try {
            ObjectFactory of = new ObjectFactory();
            if (user != null) {
                JAXBElement userJaxb = of.createObject((ObjectType)user);
                Document userDoc = DOMUtil.parseDocument((String)JAXBUtil.marshal((Object)userJaxb));
                variables.put(SchemaConstants.I_USER, new Variable((Object)userDoc.getFirstChild(), false));
            }
            if (account != null) {
                JAXBElement accountJaxb = of.createObject((ObjectType)account);
                Element accountEl = JAXBUtil.objectTypeToDom((Object)accountJaxb.getValue(), null);
                variables.put(SchemaConstants.I_ACCOUNT, new Variable((Object)accountEl, false));
            }
            if (account != null && account.getResource() != null) {
                JAXBElement resourceJaxb = of.createObject((ObjectType)account.getResource());
                Element resourceEl = JAXBUtil.objectTypeToDom((Object)resourceJaxb.getValue(), null);
                variables.put(SchemaConstants.I_RESOURCE, new Variable((Object)resourceEl, false));
            }
        }
        catch (JAXBException ex) {
            throw new IllegalArgumentException(ex);
        }
        return variables;
    }

    private ValueConstructionType getOutbound(AttributeDescriptionType attribute) {
        Validate.notNull((Object)attribute, (String)"attribute is null");
        return attribute.getOutbound();
    }

    private List<ValueAssignmentHolder> getInbound(AttributeDescriptionType attribute) {
        Validate.notNull((Object)attribute, (String)"attribute is null");
        ArrayList<ValueAssignmentHolder> result = new ArrayList<ValueAssignmentHolder>();
        for (Element e : attribute.getInbound()) {
            result.add(new ValueAssignmentHolder(e));
        }
        return result;
    }

    private ExpressionHolder extractExpressionHolder(ValueConstructionType outbound) {
        Validate.notNull((Object)outbound, (String)"outbound is null");
        if (null == outbound.getValueExpression()) {
            return null;
        }
        ExpressionHolder expression = new ExpressionHolder(outbound.getValueExpression());
        return expression;
    }

    private String extractValue(AttributeDescriptionType attributeWithValueElement) {
        Validate.notNull((Object)attributeWithValueElement, (String)"attributeWithValueElement is null");
        JAXBElement jaxbValue = attributeWithValueElement.getOutbound().getValue();
        if (null == jaxbValue) {
            return null;
        }
        StringBuffer serializedContent = new StringBuffer();
        for (Object content : ((ValueConstructionType.Value)jaxbValue.getValue()).getContent()) {
            if (content instanceof String) {
                serializedContent.append(content);
                continue;
            }
            throw new IllegalArgumentException("Unsupported content for value element in attribute's handling outbound section for attribute: " + attributeWithValueElement.getRef());
        }
        return serializedContent.toString();
    }

    private QName extractAttributeName(AttributeDescriptionType attribute) {
        Validate.notNull((Object)attribute, (String)"attribute is null");
        QName attributeName = attribute.getRef();
        return attributeName;
    }

    private ResourceObjectDefinition getResourceObjectDefinition(ResourceType resource) throws SchemaHandlingException {
        QName objectDefinitionQName;
        ResourceSchema resourceSchema = this.createResourceSchema(resource);
        ResourceObjectDefinition objectDefinition = resourceSchema.getObjectDefinition(objectDefinitionQName = new QName(resourceSchema.getResourceNamespace(), "Account"));
        if (null == objectDefinition) {
            TRACE.error("Object definition with QName {} not found in the resource schema (oid={})", (Object)objectDefinitionQName, (Object)resource.getOid());
            throw new SchemaHandlingException("Object definition with QName " + objectDefinitionQName + " not found in the resource schema (oid=" + resource.getOid() + ")");
        }
        return objectDefinition;
    }

    private XPathType getXPathForAccountsAttribute(QName accountAttributeName) {
        Validate.notNull((Object)accountAttributeName, (String)"accountAttributeName is null");
        ArrayList<XPathSegment> segments = new ArrayList<XPathSegment>();
        XPathSegment segment = new XPathSegment(SchemaConstants.I_ATTRIBUTES);
        segments.add(segment);
        segment = new XPathSegment(accountAttributeName);
        segments.add(segment);
        XPathType xpathType = new XPathType(segments);
        return xpathType;
    }

    private void processOutboundSection(AttributeDescriptionType attributeHandling, Map<QName, Variable> variables, AccountShadowType accountShadow) throws SchemaHandlingException {
        Validate.notNull((Object)attributeHandling, (String)"attributeHandling is null");
        Validate.notNull(variables, (String)"variables are null");
        Validate.notEmpty(variables, (String)"variables are empty");
        Validate.notNull((Object)accountShadow, (String)"accountShadow is null");
        QName accountAttributeName = this.extractAttributeName(attributeHandling);
        TRACE.trace("Start outbound processing of attribute handling for attribute '{}'", (Object)accountAttributeName);
        ValueConstructionType outbound = this.getOutbound(attributeHandling);
        if (null == outbound) {
            return;
        }
        ExpressionHolder expressionHolder = this.extractExpressionHolder(outbound);
        XPathType xpathType = this.getXPathForAccountsAttribute(accountAttributeName);
        if (this.isApplicablePropertyConstruction(attributeHandling.getOutbound().isDefault(), xpathType, variables, (ObjectType)accountShadow)) {
            String accountAttributeValue;
            if (null != expressionHolder && !StringUtils.isEmpty((String)expressionHolder.getExpressionAsString())) {
                accountAttributeValue = this.evaluateExpression(variables, expressionHolder);
                if (TRACE.isDebugEnabled()) {
                    TRACE.debug("OUTBOUND: expression '{}' for attribute {}, resource {}, was evaluated to '{}'", new Object[]{expressionHolder.getExpressionAsString(), accountAttributeName, DebugUtil.resourceFromShadow((ResourceObjectShadowType)accountShadow), accountAttributeValue});
                    if (variables != null) {
                        for (Map.Entry<QName, Variable> entry : variables.entrySet()) {
                            TRACE.debug("OUTBOUND:  variable {}: {}", (Object)entry.getKey(), (Object)entry.getValue());
                        }
                    }
                }
            } else {
                accountAttributeValue = this.extractValue(attributeHandling);
                TRACE.trace("Account's attribute value is '{}'", (Object)accountAttributeValue);
            }
            this.applyValue(accountShadow, accountAttributeName, accountAttributeValue);
        }
        TRACE.trace("Finished outbound processing of attribute handling for attribute '{}'", (Object)accountAttributeName);
    }

    private List<Element> extractAttributeValuesFromAccountShadow(ResourceObjectShadowType accountShadow, AttributeDescriptionType attributeHandling) {
        Validate.notNull((Object)accountShadow, (String)"accountShadow is null");
        Validate.notNull((Object)attributeHandling, (String)"attributeHandling is null");
        QName attributeName = this.extractAttributeName(attributeHandling);
        ResourceObjectShadowType.Attributes attributes = accountShadow.getAttributes();
        ArrayList<Element> result = new ArrayList<Element>();
        if (null == attributes) {
            return result;
        }
        for (Element accountAttribute : attributes.getAny()) {
            if (!StringUtils.equals((String)attributeName.getNamespaceURI(), (String)accountAttribute.getNamespaceURI()) || !StringUtils.equals((String)attributeName.getLocalPart(), (String)accountAttribute.getLocalName())) continue;
            result.add(accountAttribute);
        }
        return result;
    }

    private XPathType constructParentXpath(XPathType xpathType) {
        Validate.notNull((Object)xpathType, (String)"xpathType is null");
        List segments = xpathType.toSegments();
        List parentSegments = segments.subList(0, segments.size() - 1);
        XPathType parentXpath = new XPathType(parentSegments);
        return parentXpath;
    }

    private QName getUserPropertyQNameFromXPathType(XPathType xpathType) {
        Validate.notNull((Object)xpathType, (String)"xpathType is null");
        List segments = xpathType.toSegments();
        XPathSegment lastSegment = (XPathSegment)segments.get(segments.size() - 1);
        return lastSegment.getQName();
    }

    private Node processInboundSection(AttributeDescriptionType attributeHandling, Map<QName, Variable> variables, ResourceObjectShadowType accountShadow, Node domUser, UserType user) throws SchemaHandlingException {
        Validate.notNull((Object)attributeHandling, (String)"attributeHandling is null");
        Validate.notNull(variables, (String)"variables are null");
        Validate.notEmpty(variables, (String)"variables are empty");
        Validate.notNull((Object)accountShadow, (String)"accountShadow is null");
        Validate.notNull((Object)domUser, (String)"domUser is null");
        QName accountAttributeName = this.extractAttributeName(attributeHandling);
        TRACE.trace("Start inbound processing of attribute handling for attribute '{}'", (Object)accountAttributeName);
        List<ValueAssignmentHolder> inbounds = this.getInbound(attributeHandling);
        if (null == inbounds || inbounds.size() == 0) {
            TRACE.trace("Finished inbound processing of attribute handling for attribute '{}' - nothing to process", (Object)accountAttributeName);
            return domUser;
        }
        for (ValueAssignmentHolder inbound : inbounds) {
            QName userPropertyQName;
            Node parentNode;
            NodeList matchedNodes;
            if (null != inbound.getSource()) {
                throw new SchemaHandlingException("Inbound attribute where source is not null is not supported yet (OPENIDM-285)");
            }
            List filters = inbound.getFilter();
            XPathType xpathType = inbound.getTarget();
            try {
                matchedNodes = this.matchedNodesByXPath(xpathType, variables, domUser);
            }
            catch (XPathExpressionException ex) {
                throw new SchemaHandlingException(ex);
            }
            List<Element> nodesAttributesFromAccountShadow = this.extractAttributeValuesFromAccountShadow(accountShadow, attributeHandling);
            if (matchedNodes.getLength() == 0) {
                TRACE.warn("No nodes were matched by xpath '{}' in context of namespaces '{}' and variables '{}'", new Object[]{xpathType.getXPath(), xpathType.getNamespaceMap(), variables});
                XPathType parentXpath = this.constructParentXpath(xpathType);
                try {
                    matchedNodes = this.matchedNodesByXPath(parentXpath, variables, domUser);
                    parentNode = matchedNodes.item(0);
                    if (null == parentNode) {
                        List segments = parentXpath.toSegments();
                        XPathType relativeParentXPath = null;
                        if (segments != null && !segments.isEmpty() && ((XPathSegment)segments.get(0)).isVariable()) {
                            relativeParentXPath = new XPathType(segments.subList(1, segments.size()));
                            Document doc = DOMUtil.getDocument();
                            doc.adoptNode(domUser);
                            doc.appendChild(domUser);
                            DOMUtil.createNodesDefinedByXPath((Document)doc, (XPathType)relativeParentXPath);
                            domUser = doc.getFirstChild();
                            Validate.notNull((Object)domUser, (String)"null value assigned to domUser");
                            variables.put(SchemaConstants.I_USER, new Variable((Object)domUser, false));
                            matchedNodes = this.matchedNodesByXPath(parentXpath, variables, domUser);
                        }
                    }
                }
                catch (XPathExpressionException ex) {
                    throw new SchemaHandlingException(ex);
                }
                parentNode = matchedNodes.item(0);
                boolean wasEmpty = false;
                if (null == parentNode) {
                    parentNode = domUser;
                    wasEmpty = true;
                }
                userPropertyQName = this.getUserPropertyQNameFromXPathType(xpathType);
                List<Element> newNodes = this.transformAccountAttributeToUserProperty(nodesAttributesFromAccountShadow, userPropertyQName, filters);
                DOMUtil.addChildNodes((Node)parentNode, newNodes);
                if (wasEmpty) {
                    domUser = parentNode;
                    Validate.notNull((Object)domUser, (String)"null value assigned to domUser");
                } else {
                    domUser = parentNode.getOwnerDocument().getFirstChild();
                    Validate.notNull((Object)domUser, (String)"null value assigned to domUser");
                }
                TRACE.debug("INBOUND: expression [attribute:{}] =(new)=> [user:{},path:{}] {}", new Object[]{attributeHandling.getName(), DebugUtil.prettyPrint((ObjectType)user), xpathType, DebugUtil.prettyPrint(newNodes)});
                continue;
            }
            userPropertyQName = new QName(matchedNodes.item(0).getNamespaceURI(), matchedNodes.item(0).getLocalName());
            parentNode = matchedNodes.item(0).getParentNode();
            Validate.notNull((Object)parentNode, (String)"parentNode is null");
            List<Element> newNodes = this.transformAccountAttributeToUserProperty(nodesAttributesFromAccountShadow, userPropertyQName, filters);
            DOMUtil.replaceChildNodes((Node)parentNode, newNodes);
            domUser = parentNode.getOwnerDocument().getFirstChild();
            TRACE.debug("INBOUND: expression [attribute:{}] =(replace)=> [user:{},path:{}] {}", new Object[]{attributeHandling.getName(), DebugUtil.prettyPrint((ObjectType)user), xpathType, DebugUtil.prettyPrint(newNodes)});
            Validate.notNull((Object)domUser, (String)"null value assigned to domUser");
        }
        TRACE.trace("Finished inbound processing of attribute handling for attribute '{}'", (Object)accountAttributeName);
        return domUser;
    }

    private Node applyFilters(List<ValueFilterType> filters, Node node) {
        if (null == filters || filters.isEmpty()) {
            TRACE.trace("No filters defined");
            return node;
        }
        Node returnNode = node;
        for (ValueFilterType filterType : filters) {
            Filter filter = this.filterManager.getFilterInstance(filterType.getType(), filterType.getAny());
            if (null != filter) {
                returnNode = filter.apply(returnNode);
                continue;
            }
            TRACE.warn("Filter not found for uri {}", (Object)filterType.getType());
        }
        return returnNode;
    }

    private List<Element> transformAccountAttributeToUserProperty(List<Element> nodes, QName propertyQName, List<ValueFilterType> filters) throws DOMException {
        Validate.notNull(nodes, (String)"nodes are null");
        Validate.notNull((Object)propertyQName, (String)"propertyQName are null");
        ArrayList<Element> newNodes = new ArrayList<Element>();
        Document doc = DOMUtil.getDocument();
        for (Element element : nodes) {
            Element transformedElement = doc.createElementNS(propertyQName.getNamespaceURI(), propertyQName.getLocalPart());
            if (StringUtils.isNotEmpty((String)propertyQName.getPrefix())) {
                transformedElement.setPrefix(propertyQName.getPrefix());
            } else {
                transformedElement.setPrefix(propertyQName.getLocalPart());
            }
            Node valueNode = this.applyFilters(filters, element.getFirstChild());
            if (null != valueNode) {
                transformedElement.getOwnerDocument().adoptNode(valueNode);
                transformedElement.appendChild(valueNode);
            }
            newNodes.add(transformedElement);
        }
        return newNodes;
    }

    private boolean isApplicablePropertyConstruction(boolean isDefault, XPathType xpathType, Map<QName, Variable> variables, ObjectType objectType) throws SchemaHandlingException {
        Validate.notNull((Object)xpathType, (String)"xpathType is null");
        Validate.notNull(variables, (String)"variables are null");
        Validate.notNull((Object)objectType, (String)"objectType is null");
        if (isDefault) {
            QName elementQName = null;
            if (objectType instanceof UserType) {
                elementQName = SchemaConstants.I_USER_TYPE;
            } else if (objectType instanceof AccountShadowType) {
                elementQName = SchemaConstants.I_ACCOUNT_TYPE;
            } else {
                throw new SchemaHandlingException("Provided unsupported object type: " + objectType.getClass());
            }
            try {
                NodeList nodes;
                Element domObject = JAXBUtil.jaxbToDom((Object)objectType, (QName)elementQName, (Document)DOMUtil.getDocument());
                try {
                    nodes = this.matchedNodesByXPath(xpathType, variables, domObject);
                }
                catch (XPathExpressionException ex) {
                    throw new SchemaHandlingException(ex);
                }
                if (null != nodes && nodes.getLength() > 0) {
                    return false;
                }
            }
            catch (JAXBException ex) {
                throw new SchemaHandlingException("Couldn't transform jaxb object '" + objectType + "' to dom.", ex);
            }
        }
        return true;
    }

    public UserType applyUserTemplate(UserType user, UserTemplateType userTemplate) throws PatchException, SchemaHandlingException {
        Validate.notNull((Object)user, (String)"user is null");
        Validate.notNull((Object)userTemplate, (String)"userTemplate is null");
        TRACE.debug("USER TEMPLATE: Processing template {} for user {}", (Object)DebugUtil.prettyPrint((ObjectType)userTemplate), (Object)DebugUtil.prettyPrint((ObjectType)user));
        ObjectModificationType objectModifications = new ObjectModificationType();
        objectModifications.setOid(user.getOid());
        ArrayList<PropertyModificationType> changes = new ArrayList<PropertyModificationType>();
        for (PropertyConstructionType pct : userTemplate.getPropertyConstruction()) {
            XPathType xpathType = new XPathType(pct.getProperty());
            XPathType parentXpathType = this.constructParentXpath(xpathType);
            QName propertyQName = this.getUserPropertyQNameFromXPathType(xpathType);
            ExpressionHolder expression = new ExpressionHolder(pct.getValueConstruction().getValueExpression());
            Map<QName, Variable> variables = this.getDefaultXPathVariables(user, null);
            String evaluatedExpression = this.evaluateExpression(variables, expression);
            if (!this.isApplicablePropertyConstruction(pct.getValueConstruction().isDefault(), xpathType, variables, (ObjectType)user)) continue;
            PropertyModificationType change = ObjectTypeUtil.createPropertyModificationType((PropertyModificationTypeType)PropertyModificationTypeType.replace, (XPathType)parentXpathType, (QName)propertyQName, (Object)evaluatedExpression);
            changes.add(change);
        }
        for (AccountConstructionType accountConstr : userTemplate.getAccountConstruction()) {
            String resourceOid;
            if (accountConstr.getResource() != null) {
                resourceOid = accountConstr.getResource().getOid();
            } else if (accountConstr.getResourceRef() != null) {
                resourceOid = accountConstr.getResourceRef().getOid();
            } else {
                TRACE.error("Account construction in user template (OID:{}) must have resource or resourceRef dedined.", (Object)userTemplate.getOid());
                throw new IllegalArgumentException("Account construction in user template (OID:" + userTemplate.getOid() + ") must have resource or resourceRef dedined.");
            }
            if (UserTypeUtil.findAccountRef((UserType)user, (String)resourceOid) != null) {
                TRACE.debug("USER TEMPLATE: Account on resource {} already exists for user {}, skipping", (Object)resourceOid, (Object)user.getOid());
                continue;
            }
            AccountShadowType account = new AccountShadowType();
            ObjectReferenceType resourceRef = new ObjectReferenceType();
            resourceRef.setOid(resourceOid);
            resourceRef.setType(SchemaConstants.I_RESOURCE_TYPE);
            account.setResourceRef(resourceRef);
            PropertyModificationType change = ObjectTypeUtil.createPropertyModificationType((PropertyModificationTypeType)PropertyModificationTypeType.add, null, (QName)SchemaConstants.I_ACCOUNT, (Object)account);
            changes.add(change);
        }
        objectModifications.getPropertyModification().addAll(changes);
        String stringUser = new PatchXml().applyDifferences(objectModifications, (ObjectType)user);
        try {
            return (UserType)((JAXBElement)JAXBUtil.unmarshal((String)stringUser)).getValue();
        }
        catch (JAXBException ex) {
            throw new SchemaHandlingException("Couldn't create unmarshall UserType from string.", ex);
        }
    }

    public UserType applyInboundSchemaHandlingOnUser(UserType user, ResourceObjectShadowType resourceObjectShadow) throws SchemaHandlingException {
        Validate.notNull((Object)user, (String)"user object is null");
        Validate.notNull((Object)resourceObjectShadow, (String)"resourceObjectShadow is null");
        Validate.notNull((Object)resourceObjectShadow.getResource(), (String)"resourceObjectShadow.getResource() is null");
        user = this.evaluateAndApplyInboundExpressionValues(user, resourceObjectShadow);
        return user;
    }

    public ResourceObjectShadowType applyOutboundSchemaHandlingOnAccount(UserType user, ResourceObjectShadowType resourceObjectShadow, ResourceType resource) throws SchemaHandlingException {
        Validate.notNull((Object)user, (String)"user is null");
        Validate.notNull((Object)resourceObjectShadow, (String)"resourceObjectShadow is null");
        if (resourceObjectShadow instanceof AccountShadowType) {
            AccountShadowType accountShadow = (AccountShadowType)resourceObjectShadow;
            this.evaluateAndApplyOutboundExpressionValues(user, accountShadow, resource);
            return accountShadow;
        }
        throw new SchemaHandlingException("Parameter resourceObjectShadow is instance of unsupported subclass: " + resourceObjectShadow.getClass());
    }

    public boolean confirmUser(UserType user, ResourceObjectShadowType resourceObjectShadow, ExpressionHolder expression) {
        Validate.notNull((Object)user, (String)"user object is null");
        Validate.notNull((Object)resourceObjectShadow, (String)"resourceObjectShadow is null");
        Validate.notNull((Object)expression, (String)"expression is null");
        Map<QName, Variable> variables = this.getDefaultXPathVariables(user, resourceObjectShadow);
        String confirmed = this.evaluateExpression(variables, expression);
        return Boolean.valueOf(confirmed);
    }

    public String evaluateCorrelationExpression(ResourceObjectShadowType resourceObjectShadow, ExpressionHolder expression) {
        Validate.notNull((Object)resourceObjectShadow);
        Validate.notNull((Object)expression);
        Map<QName, Variable> variables = this.getDefaultXPathVariables(null, resourceObjectShadow);
        if (TRACE.isDebugEnabled()) {
            for (Map.Entry<QName, Variable> entry : variables.entrySet()) {
                TRACE.debug("CORRELATION: Variable {}: {}", (Object)entry.getKey(), (Object)entry.getValue());
            }
        }
        return this.evaluateExpression(variables, expression);
    }

    private void insertUserDefinedVariables(AttributeDescriptionType attributeHandling, Map<QName, Variable> variables) throws SchemaHandlingException {
        Iterator<Map.Entry<QName, Variable>> i = variables.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<QName, Variable> entry = i.next();
            if (!entry.getValue().isUserDefined()) continue;
            i.remove();
        }
        if (attributeHandling.getOutbound() == null) {
            return;
        }
        List variableDefinitions = attributeHandling.getOutbound().getVariable();
        for (VariableDefinitionType varDef : variableDefinitions) {
            ObjectReferenceType reference;
            ObjectType objectType;
            Object object = varDef.getValue();
            if (object == null && (objectType = this.findObjectByOid((reference = varDef.getObjectRef()).getOid())) != null) {
                try {
                    object = JAXBUtil.objectTypeToDom((Object)objectType, null);
                }
                catch (JAXBException ex) {
                    TRACE.warn("Variable '{}' couldn't be serialized to XML, skipping. Error: {}", (Object)varDef.getName(), (Object)ex.getMessage());
                    continue;
                }
            }
            if (object != null) {
                variables.put(varDef.getName(), new Variable(object));
                continue;
            }
            TRACE.warn("Variable '{}' couldn't be resolved, skipping.", (Object)varDef.getName());
        }
    }

    private ObjectType findObjectByOid(String oid) throws SchemaHandlingException {
        if (oid == null) {
            return null;
        }
        if (this.model == null) {
            return null;
        }
        try {
            return this.model.getObject(oid, new PropertyReferenceListType()).getObject();
        }
        catch (FaultMessage ex) {
            throw new SchemaHandlingException("Couldn't resolve oid '" + oid + "', reason: " + ex.getMessage(), ex, ex.getFaultInfo());
        }
    }
}

