/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.model.filter;

import com.evolveum.midpoint.api.logging.Trace;
import com.evolveum.midpoint.logging.TraceManager;
import com.evolveum.midpoint.model.filter.AbstractFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class PatternFilter
extends AbstractFilter {
    private static final QName ELEMENT_REPLACE = new QName("http://midpoint.evolveum.com/xml/ns/public/common/value-filter-1.xsd", "replace");
    private static final QName ELEMENT_PATTERN = new QName("http://midpoint.evolveum.com/xml/ns/public/common/value-filter-1.xsd", "pattern");
    private static final QName ELEMENT_REPLACEMENT = new QName("http://midpoint.evolveum.com/xml/ns/public/common/value-filter-1.xsd", "replacement");
    private static transient Trace logger = TraceManager.getTrace(PatternFilter.class);
    private List<Replace> replaces;

    @Override
    public Node apply(Node node) {
        String value = null;
        if (node.getNodeType() == 3) {
            value = ((Text)node).getData();
        } else if (node.getNodeType() == 1) {
            value = ((Element)node).getTextContent();
        } else {
            throw new IllegalArgumentException("PatternFilter can only work with text or element nodes, got node type " + node.getNodeType() + " (" + node + ")");
        }
        if (value == null) {
            return node;
        }
        List<Replace> repls = this.getReplaces();
        for (Replace repl : repls) {
            Matcher matcher = repl.getPattern().matcher(value);
            value = matcher.replaceAll(repl.getReplacement());
        }
        Node newNode = node.cloneNode(false);
        if (node.getNodeType() == 3) {
            newNode.setTextContent(value);
        } else {
            ((Element)newNode).setTextContent(value);
        }
        return newNode;
    }

    private List<Replace> getReplaces() {
        if (this.replaces != null) {
            return this.replaces;
        }
        this.replaces = new ArrayList<Replace>();
        List<Object> parameters = this.getParameters();
        for (Object o : parameters) {
            if (!(o instanceof Element)) continue;
            Element e = (Element)o;
            if (ELEMENT_REPLACE.getLocalPart().equals(e.getLocalName())) {
                NodeList patternNodeList = e.getElementsByTagNameNS(ELEMENT_PATTERN.getNamespaceURI(), ELEMENT_PATTERN.getLocalPart());
                if (patternNodeList.getLength() != 1) {
                    throw new IllegalArgumentException("Wrong number of " + ELEMENT_PATTERN + " elements (" + patternNodeList.getLength() + ")");
                }
                String patternStr = ((Element)patternNodeList.item(0)).getTextContent();
                Pattern pattern = Pattern.compile(patternStr);
                NodeList replacementNodeList = e.getElementsByTagNameNS(ELEMENT_REPLACEMENT.getNamespaceURI(), ELEMENT_REPLACEMENT.getLocalPart());
                if (replacementNodeList.getLength() != 1) {
                    throw new IllegalArgumentException("Wrong number of " + ELEMENT_REPLACEMENT + " elements (" + replacementNodeList.getLength() + ")");
                }
                String replacement = ((Element)replacementNodeList.item(0)).getTextContent();
                this.replaces.add(new Replace(pattern, replacement));
                continue;
            }
            logger.debug("Ignoring unknown parameter {} in PatternFilter", (Object)e.getLocalName());
        }
        return this.replaces;
    }

    private static class Replace {
        private String replacement;
        private Pattern pattern;

        public Replace(Pattern pattern, String replacement) {
            this.replacement = replacement;
            this.pattern = pattern;
        }

        public String getReplacement() {
            return this.replacement;
        }

        public void setReplacement(String replacement) {
            this.replacement = replacement;
        }

        public Pattern getPattern() {
            return this.pattern;
        }

        public void setPattern(Pattern pattern) {
            this.pattern = pattern;
        }
    }
}

