/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.model.filter;

import com.evolveum.midpoint.api.logging.Trace;
import com.evolveum.midpoint.logging.TraceManager;
import com.evolveum.midpoint.model.filter.Filter;
import com.evolveum.midpoint.model.filter.FilterManager;
import java.util.List;
import java.util.Map;

public class FilterManagerImpl<T extends Filter>
implements FilterManager<T> {
    private static final Trace TRACE = TraceManager.getTrace(FilterManagerImpl.class);
    private Map<String, Class<T>> filterMap;

    @Override
    public void setFilterMapping(Map<String, Class<T>> filterMap) {
        this.filterMap = filterMap;
    }

    @Override
    public Filter getFilterInstance(String uri) {
        return this.getFilterInstance(uri, null);
    }

    @Override
    public Filter getFilterInstance(String uri, List<Object> parameters) {
        Class<T> clazz = this.filterMap.get(uri);
        if (clazz == null) {
            return null;
        }
        Filter filter = null;
        try {
            filter = (Filter)clazz.newInstance();
            filter.setParameters(parameters);
        }
        catch (InstantiationException ex) {
            TRACE.error("Couln't create filter instance, reason: {}.", (Object)ex.getMessage());
            TRACE.debug("Couln't create filter instance.", (Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            TRACE.error("Couln't create filter instance, reason: {}.", (Object)ex.getMessage());
            TRACE.debug("Couln't create filter instance.", (Throwable)ex);
        }
        return filter;
    }
}

