/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.model.action;

import com.evolveum.midpoint.api.logging.Trace;
import com.evolveum.midpoint.logging.TraceManager;
import com.evolveum.midpoint.model.SynchronizationException;
import com.evolveum.midpoint.model.action.BaseAction;
import com.evolveum.midpoint.model.xpath.SchemaHandlingException;
import com.evolveum.midpoint.util.diff.CalculateXmlDiff;
import com.evolveum.midpoint.util.diff.DiffException;
import com.evolveum.midpoint.util.jaxb.JAXBUtil;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ObjectChangeDeletionType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ObjectContainerType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ObjectFactory;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ObjectModificationType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ObjectType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ResourceObjectShadowChangeDescriptionType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ResourceObjectShadowType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.SynchronizationSituationType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.UserType;
import com.evolveum.midpoint.xml.ns._public.model.model_1.FaultMessage;
import javax.xml.bind.JAXBException;

public class ModifyUserAction
extends BaseAction {
    private static transient Trace logger = TraceManager.getTrace(ModifyUserAction.class);

    @Override
    public String executeChanges(String userOid, ResourceObjectShadowChangeDescriptionType change, SynchronizationSituationType situation, ResourceObjectShadowType shadowAfterChange) throws SynchronizationException {
        UserType userType = this.getUser(userOid);
        if (userType == null) {
            throw new SynchronizationException("Can't find user with oid '" + userOid + "'.");
        }
        if (change.getObjectChange() instanceof ObjectChangeDeletionType) {
            throw new SynchronizationException("The modifyUser action cannot be applied to deletion.");
        }
        try {
            UserType oldUserType = (UserType)JAXBUtil.clone((ObjectType)userType);
            userType = this.getSchemaHandling().applyInboundSchemaHandlingOnUser(userType, shadowAfterChange);
            ObjectFactory of = new ObjectFactory();
            ObjectContainerType userContainer = of.createObjectContainerType();
            userContainer.setObject((ObjectType)userType);
            ObjectModificationType modification = CalculateXmlDiff.calculateChanges((ObjectType)oldUserType, (ObjectType)userType);
            if (modification != null && modification.getOid() != null) {
                this.getModel().modifyObject(modification);
            } else {
                logger.warn("Diff returned null for changes of user {}, caused by shadow {}", (Object)userType.getOid(), (Object)shadowAfterChange.getOid());
            }
        }
        catch (SchemaHandlingException ex) {
            throw new SynchronizationException("Can't handle inbound section in schema handling", ex);
        }
        catch (FaultMessage ex) {
            throw new SynchronizationException("Can't save user", ex, ex.getFaultInfo());
        }
        catch (DiffException ex) {
            throw new SynchronizationException("Can't save user. Unexpected error: Couldn't create create diff.", ex, null);
        }
        catch (JAXBException ex) {
            throw new SynchronizationException("Couldn't clone user object '" + userOid + "', reason: " + ex.getMessage(), ex);
        }
        return userOid;
    }
}

