/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.model.action;

import com.evolveum.midpoint.api.logging.Trace;
import com.evolveum.midpoint.logging.TraceManager;
import com.evolveum.midpoint.model.SynchronizationException;
import com.evolveum.midpoint.model.action.BaseAction;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ResourceObjectShadowChangeDescriptionType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ResourceObjectShadowType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.SynchronizationSituationType;
import com.evolveum.midpoint.xml.ns._public.model.model_1.FaultMessage;

public class DeleteUserAction
extends BaseAction {
    private static Trace trace = TraceManager.getTrace(DeleteUserAction.class);

    @Override
    public String executeChanges(String userOid, ResourceObjectShadowChangeDescriptionType change, SynchronizationSituationType situation, ResourceObjectShadowType shadowAfterChange) throws SynchronizationException {
        if (userOid == null) {
            throw new SynchronizationException("Can't delete user, because user oid is null.");
        }
        try {
            this.getModel().deleteObject(userOid);
        }
        catch (FaultMessage ex) {
            String message = ex.getFaultInfo() == null ? ex.getMessage() : ex.getFaultInfo().getMessage();
            trace.error("Couldn't delete user {}, reason: {}", (Object)userOid, (Object)message);
            throw new SynchronizationException("Couldn't delete user '" + userOid + "'.", ex, ex.getFaultInfo());
        }
        return null;
    }
}

