/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.model.action;

import com.evolveum.midpoint.model.ModelService;
import com.evolveum.midpoint.model.SynchronizationException;
import com.evolveum.midpoint.model.action.Action;
import com.evolveum.midpoint.model.xpath.SchemaHandling;
import com.evolveum.midpoint.provisioning.service.ProvisioningService;
import com.evolveum.midpoint.xml.ns._public.common.common_1.FaultType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ObjectContainerType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ObjectNotFoundFaultType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.PropertyReferenceListType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ResourceType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ScriptsType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.UserType;
import com.evolveum.midpoint.xml.ns._public.model.model_1.FaultMessage;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseAction
implements Action {
    private ModelService model;
    private ProvisioningService provisioning;
    private SchemaHandling schemaHandling;
    private List<Object> parameters;

    @Override
    public List<Object> getParameters() {
        if (this.parameters == null) {
            this.parameters = new ArrayList<Object>();
        }
        return this.parameters;
    }

    @Override
    public void setParameters(List<Object> parameters) {
        this.parameters = parameters;
    }

    protected UserType getUser(String oid) throws SynchronizationException {
        if (oid == null) {
            return null;
        }
        try {
            ObjectContainerType container = this.model.getObject(oid, new PropertyReferenceListType());
            if (container == null) {
                return null;
            }
            if (container.getObject() == null || !(container.getObject() instanceof UserType)) {
                throw new SynchronizationException("Returned object is null or not type of " + UserType.class.getName() + ".");
            }
            return (UserType)container.getObject();
        }
        catch (FaultMessage ex) {
            FaultType info = ex.getFaultInfo();
            if (info == null || !(info instanceof ObjectNotFoundFaultType)) {
                throw new SynchronizationException("Can't get user. Unknown error occured.", ex, ex.getFaultInfo());
            }
            return null;
        }
    }

    public void setModel(ModelService model) {
        this.model = model;
    }

    protected ModelService getModel() {
        return this.model;
    }

    public ProvisioningService getProvisioning() {
        return this.provisioning;
    }

    public void setProvisioning(ProvisioningService provisioning) {
        this.provisioning = provisioning;
    }

    public SchemaHandling getSchemaHandling() {
        return this.schemaHandling;
    }

    public void setSchemaHandling(SchemaHandling schemaHandling) {
        this.schemaHandling = schemaHandling;
    }

    protected ScriptsType getScripts(ResourceType resource) {
        ScriptsType scripts = resource.getScripts();
        if (scripts == null) {
            scripts = new ScriptsType();
        }
        return scripts;
    }
}

