/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.model.action;

import com.evolveum.midpoint.api.logging.Trace;
import com.evolveum.midpoint.logging.TraceManager;
import com.evolveum.midpoint.model.SynchronizationException;
import com.evolveum.midpoint.model.action.BaseAction;
import com.evolveum.midpoint.model.xpath.SchemaHandlingException;
import com.evolveum.midpoint.util.DebugUtil;
import com.evolveum.midpoint.util.patch.PatchException;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ObjectContainerType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ObjectFactory;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ObjectType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.PropertyReferenceListType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ResourceObjectShadowChangeDescriptionType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ResourceObjectShadowType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.SynchronizationSituationType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.UserTemplateType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.UserType;
import com.evolveum.midpoint.xml.ns._public.model.model_1.FaultMessage;
import java.util.List;
import org.w3c.dom.Element;

public class AddUserAction
extends BaseAction {
    private static Trace trace = TraceManager.getTrace(AddUserAction.class);

    @Override
    public String executeChanges(String userOid, ResourceObjectShadowChangeDescriptionType change, SynchronizationSituationType situation, ResourceObjectShadowType shadowAfterChange) throws SynchronizationException {
        UserType userType = this.getUser(userOid);
        ObjectFactory of = new ObjectFactory();
        if (userType == null) {
            userType = of.createUserType();
            UserTemplateType userTemplate = this.getUserTemplate();
            try {
                if (trace.isDebugEnabled()) {
                    trace.debug("Action:addUser: Resource Object Shadow before action: {}", (Object)DebugUtil.toReadableString((ResourceObjectShadowType)shadowAfterChange));
                }
                userType = this.getSchemaHandling().applyInboundSchemaHandlingOnUser(userType, shadowAfterChange);
                if (trace.isDebugEnabled()) {
                    trace.debug("Action:addUser: User after processing of inbound expressions: {}", (Object)DebugUtil.toReadableString((UserType)userType));
                }
                userType = this.getSchemaHandling().applyUserTemplate(userType, userTemplate);
                if (trace.isDebugEnabled()) {
                    trace.debug("Action:addUser: User after processing of user template: {}", (Object)DebugUtil.toReadableString((UserType)userType));
                }
                ObjectContainerType userContainer = of.createObjectContainerType();
                userContainer.setObject((ObjectType)userType);
                userOid = this.getModel().addObject(userContainer);
            }
            catch (FaultMessage ex) {
                throw new SynchronizationException("Can't save user", ex, ex.getFaultInfo());
            }
            catch (SchemaHandlingException ex) {
                throw new SynchronizationException("Couldn't apply user template '" + userTemplate.getOid() + "' on user '" + userOid + "'.", ex, ex.getFaultType());
            }
            catch (PatchException ex) {
                throw new SynchronizationException("Couldn't apply user template '" + userTemplate.getOid() + "' on user '" + userOid + "'.", ex, null);
            }
        } else {
            trace.debug("User already exists ({}), skipping create.", (Object)userType.getOid());
        }
        return userOid;
    }

    private String getUserTemplateOid() {
        List<Object> parameters = this.getParameters();
        Element userTemplateRef = null;
        for (Object object : parameters) {
            Element element;
            if (!(object instanceof Element) || !"userTemplateRef".equals((element = (Element)object).getLocalName()) || !"http://midpoint.evolveum.com/xml/ns/public/common/common-1.xsd".equals(element.getNamespaceURI())) continue;
            userTemplateRef = element;
            break;
        }
        if (userTemplateRef != null) {
            return userTemplateRef.getAttribute("oid");
        }
        return null;
    }

    private UserTemplateType getUserTemplate() throws SynchronizationException {
        String userTemplateOid = this.getUserTemplateOid();
        if (userTemplateOid == null) {
            throw new SynchronizationException("User Template Oid not defined in parameters for this action.");
        }
        UserTemplateType userTemplate = null;
        try {
            ObjectContainerType container = this.getModel().getObject(userTemplateOid, new PropertyReferenceListType());
            userTemplate = (UserTemplateType)container.getObject();
        }
        catch (FaultMessage ex) {
            throw new SynchronizationException("Couldn't get user template with oid '" + userTemplateOid + "'.", ex, ex.getFaultInfo());
        }
        return userTemplate;
    }
}

