/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.model;

import com.evolveum.midpoint.api.logging.Trace;
import com.evolveum.midpoint.logging.TraceManager;
import com.evolveum.midpoint.model.xpath.SchemaHandling;
import com.evolveum.midpoint.model.xpath.SchemaHandlingException;
import com.evolveum.midpoint.util.DOMUtil;
import com.evolveum.midpoint.util.DebugUtil;
import com.evolveum.midpoint.util.ObjectTypeUtil;
import com.evolveum.midpoint.util.QNameUtil;
import com.evolveum.midpoint.util.RandomString;
import com.evolveum.midpoint.util.Utils;
import com.evolveum.midpoint.util.diff.CalculateXmlDiff;
import com.evolveum.midpoint.util.diff.DiffException;
import com.evolveum.midpoint.util.jaxb.JAXBUtil;
import com.evolveum.midpoint.util.patch.PatchException;
import com.evolveum.midpoint.util.patch.PatchXml;
import com.evolveum.midpoint.xml.ns._public.common.common_1.AccountShadowType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.CredentialsType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.EmptyType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.FaultType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.IllegalArgumentFaultType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.InapplicableOperationFaultType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ObjectContainerType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ObjectFactory;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ObjectListType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ObjectModificationType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ObjectReferenceType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ObjectType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.OperationalResultType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.PagingType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.PropertyAvailableValuesListType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.PropertyModificationType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.PropertyModificationTypeType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.PropertyReferenceListType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.PropertyReferenceType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.QueryType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ResourceObjectShadowListType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ResourceObjectShadowType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ResourceTestResultType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ResourceType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.SchemaHandlingType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.SchemaViolationFaultType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ScriptsType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.SystemFaultType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.TaskStatusType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.UserContainerType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.UserType;
import com.evolveum.midpoint.xml.ns._public.model.model_1.ModelPortType;
import com.evolveum.midpoint.xml.ns._public.provisioning.provisioning_1.FaultMessage;
import com.evolveum.midpoint.xml.ns._public.provisioning.provisioning_1.ProvisioningPortType;
import com.evolveum.midpoint.xml.ns._public.repository.repository_1.RepositoryPortType;
import com.evolveum.midpoint.xml.schema.SchemaConstants;
import com.evolveum.midpoint.xml.schema.XPathSegment;
import com.evolveum.midpoint.xml.schema.XPathType;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import javax.xml.ws.Holder;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Service
public class ModelService
implements ModelPortType {
    @Autowired(required=true)
    private ProvisioningPortType provisioningService;
    @Autowired(required=true)
    private RepositoryPortType repositoryService;
    private static final transient Trace logger = TraceManager.getTrace(ModelService.class);
    @Autowired(required=true)
    private SchemaHandling schemaHandling;

    public String addObject(ObjectContainerType objectContainer) throws com.evolveum.midpoint.xml.ns._public.model.model_1.FaultMessage {
        String result;
        if (objectContainer == null || objectContainer.getObject() == null) {
            throw new IllegalArgumentException("Object container and object in container must not be null.");
        }
        logger.info("### MODEL # Enter addObject({})", (Object)DebugUtil.prettyPrint((ObjectContainerType)objectContainer));
        ObjectType object = objectContainer.getObject();
        String name = object.getName();
        if (name == null || name.isEmpty()) {
            throw this.createFaultMessage("Object (" + object.getClass().getSimpleName() + ") with oid '" + object.getOid() + "' doesn't have required 'name' attribute defined.", IllegalArgumentFaultType.class, false, null, null);
        }
        if (this.isManagedByProvisioning(object)) {
            result = this.addProvisioningObject(object);
        } else {
            if (object instanceof UserType) {
                UserType user = (UserType)object;
                this.preprocessUserType(user);
            }
            try {
                result = this.repositoryService.addObject(objectContainer);
            }
            catch (com.evolveum.midpoint.xml.ns._public.repository.repository_1.FaultMessage ex) {
                logger.error("### MODEL # Fault addObject(..): Repository failed for method addObject : ", (Throwable)ex);
                throw this.createFaultMessage("Repository invocation failed (addObject)", ex.getFaultInfo(), (Exception)((Object)ex), null);
            }
            catch (Exception ex) {
                logger.error("### MODEL # Fault addObject(..): Repository failed for method addObject : ", (Throwable)ex);
                throw this.createFaultMessage("Repository invocation failed (addObject)", (FaultType)new InapplicableOperationFaultType(), ex, null);
            }
        }
        logger.info("### MODEL # Exit addObject(..): {}", (Object)result);
        return result;
    }

    private void preprocessUserType(UserType user) throws com.evolveum.midpoint.xml.ns._public.model.model_1.FaultMessage {
        List accounts = user.getAccount();
        ArrayList<ObjectReferenceType> references = new ArrayList<ObjectReferenceType>();
        ArrayList<AccountShadowType> accountsToCreate = new ArrayList<AccountShadowType>();
        for (AccountShadowType account : accounts) {
            ObjectReferenceType ref = account.getResourceRef();
            if (account.getName() != null || account.getOid() != null || ref == null || !SchemaConstants.I_RESOURCE_TYPE.equals(ref.getType())) continue;
            references.add(ref);
            accountsToCreate.add(account);
        }
        user.getAccount().removeAll(accountsToCreate);
        ArrayList<ObjectReferenceType> newAccountRefs = new ArrayList<ObjectReferenceType>();
        for (ObjectReferenceType ref : references) {
            try {
                AccountShadowType account;
                account = new AccountShadowType();
                account.setName(ref.getOid() + "-" + user.getName());
                account.setResourceRef(ref);
                ResourceType resource = this.resolveResource(ref.getOid());
                account.setObjectClass(new QName(resource.getNamespace(), "Account"));
                account = (AccountShadowType)this.schemaHandling.applyOutboundSchemaHandlingOnAccount(user, (ResourceObjectShadowType)account, resource);
                ObjectContainerType container = new ObjectContainerType();
                container.setObject((ObjectType)account);
                String oid = this.addObject(container);
                ObjectReferenceType accountRef = new ObjectReferenceType();
                accountRef.setOid(oid);
                accountRef.setType(SchemaConstants.I_ACCOUNT_TYPE);
                newAccountRefs.add(accountRef);
            }
            catch (FaultMessage ex) {
                String message = ex.getMessage();
                if (ex.getFaultInfo() != null && ex.getFaultInfo().getMessage() != null) {
                    message = ex.getFaultInfo().getMessage();
                }
                logger.error("### MODEL # preprocessUserType(), couldnt' create account on resource {}, provisioning problem, reason: {}", new Object[]{ref.getOid(), message});
            }
            catch (SchemaHandlingException ex) {
                logger.error("### MODEL # preprocessUserType(), couldnt' create account on resource {}, outbound schema handling problem, reason: {}", new Object[]{ref.getOid(), ex.getMessage()});
            }
        }
        user.getAccountRef().addAll(newAccountRefs);
    }

    private String addProvisioningObject(ObjectType object) throws com.evolveum.midpoint.xml.ns._public.model.model_1.FaultMessage {
        try {
            AccountShadowType account;
            int randomPasswordLength;
            if (object instanceof AccountShadowType && (randomPasswordLength = this.getRandomPasswordLength(account = (AccountShadowType)object)) != -1) {
                this.generatePassword(account, randomPasswordLength);
            }
            OperationalResultType operationalResult = new OperationalResultType();
            Holder holder = new Holder((Object)operationalResult);
            ScriptsType scripts = this.getScripts(object);
            ObjectContainerType container = new ObjectContainerType();
            container.setObject(object);
            String result = this.provisioningService.addObject(container, scripts, holder);
            return result;
        }
        catch (FaultMessage ex) {
            logger.error("### MODEL # Fault addObject(..): Provisioning WS client failed for method addObject : ", (Throwable)ex);
            throw this.createFaultMessage("Provisioning invocation failed (addObject)", ex.getFaultInfo(), (Exception)((Object)ex), null);
        }
    }

    private int getRandomPasswordLength(AccountShadowType account) throws FaultMessage {
        ResourceType resource = account.getResource();
        if (resource == null) {
            resource = this.resolveResource(account.getResourceRef().getOid());
        }
        if (resource == null || resource.getSchemaHandling() == null) {
            return -1;
        }
        SchemaHandlingType.AccountType accountType = ObjectTypeUtil.getAccountTypeDefinitionFromSchemaHandling((ResourceObjectShadowType)account, (ResourceType)resource);
        if (accountType == null || accountType.getCredentials() == null) {
            return -1;
        }
        SchemaHandlingType.AccountType.Credentials credentials = accountType.getCredentials();
        if (credentials.getRandomPasswordLength() != null) {
            return credentials.getRandomPasswordLength().intValue();
        }
        return -1;
    }

    private void generatePassword(AccountShadowType account, int length) {
        CredentialsType.Password password;
        String pwd = "";
        if (length > 0) {
            pwd = new RandomString(length).nextString();
        }
        if ((password = ModelService.getPassword(account)).getAny() != null) {
            return;
        }
        Document document = DOMUtil.getDocument();
        Element hash = document.createElementNS("http://midpoint.evolveum.com/xml/ns/public/common/common-1.xsd", "c:base64");
        hash.setTextContent(Base64.encodeBase64String((byte[])pwd.getBytes()));
        password.setAny((Object)hash);
    }

    public UserType listAccountShadowOwnerSilent(String accountOid) {
        try {
            UserContainerType container = this.listAccountShadowOwner(accountOid);
            return container.getUser();
        }
        catch (com.evolveum.midpoint.xml.ns._public.model.model_1.FaultMessage ex) {
            logger.error("Couldn't find owner for account with oid {}, reason: {}", (Object)accountOid, (Object)ex.getMessage());
            return null;
        }
    }

    private ScriptsType getScripts(ObjectType object) throws FaultMessage {
        ScriptsType scripts = new ScriptsType();
        if (object instanceof ResourceType) {
            ResourceType resource = (ResourceType)object;
            scripts = resource.getScripts();
        } else if (object instanceof ResourceObjectShadowType) {
            ResourceObjectShadowType resourceObject = (ResourceObjectShadowType)object;
            if (resourceObject.getResource() != null) {
                scripts = resourceObject.getResource().getScripts();
            } else {
                ObjectReferenceType reference = resourceObject.getResourceRef();
                ResourceType resource = this.resolveResource(reference.getOid());
                if (resource != null) {
                    scripts = resource.getScripts();
                }
            }
        }
        return scripts;
    }

    private void processAddAccount(ObjectModificationType objectChange, String operation) throws com.evolveum.midpoint.xml.ns._public.model.model_1.FaultMessage {
        logger.debug("Start search for new accounts in object changes");
        logger.trace("ObjectChange = {}", (Object)DebugUtil.prettyPrint((ObjectModificationType)objectChange));
        for (PropertyModificationType change : objectChange.getPropertyModification()) {
            JAXBElement accountShadowJaxb;
            if (!PropertyModificationTypeType.add.equals((Object)change.getModificationType())) continue;
            Node node = (Node)change.getValue().getAny().get(0);
            String newValue = DOMUtil.serializeDOMToString((Node)node);
            if (!"account".equals(node.getLocalName())) continue;
            logger.debug("Found new account");
            logger.trace("New account is: {}", (Object)newValue);
            try {
                accountShadowJaxb = (JAXBElement)JAXBUtil.unmarshal((String)newValue);
            }
            catch (JAXBException ex) {
                logger.error("### MODEL # Fault {}(..): Parsing of account failed : {}", (Object)operation, (Object)ex);
                throw this.createFaultMessage("Parsing of account failed (" + operation + "): " + ex.getMessage(), SystemFaultType.class, false, (Exception)((Object)ex), null);
            }
            ObjectContainerType userContainer = this.getObject(objectChange.getOid(), Utils.getResolveResourceList());
            AccountShadowType account = (AccountShadowType)accountShadowJaxb.getValue();
            ResourceType resource = account.getResource();
            if (resource == null) {
                try {
                    resource = this.resolveResource(account.getResourceRef().getOid());
                }
                catch (FaultMessage ex) {
                    throw this.createFaultMessage("Resolving resource " + account.getResourceRef().getOid() + " failed: " + ex.getMessage(), (FaultType)new IllegalArgumentFaultType(), (Exception)((Object)ex), null);
                }
            }
            try {
                this.schemaHandling.applyOutboundSchemaHandlingOnAccount((UserType)userContainer.getObject(), (ResourceObjectShadowType)account, resource);
            }
            catch (SchemaHandlingException ex) {
                logger.error("### MODEL # Fault {}(..): Parsing outbound schema hadling failed : {}", (Object)operation, (Object)ex);
                throw this.createFaultMessage("Parsing outbound schema hadling failed (" + operation + "): " + ex.getMessage(), ex.getFaultType(), ex, null);
            }
            logger.trace("JAXBObject for account: {}", (Object)JAXBUtil.silentMarshal((Object)accountShadowJaxb));
            ObjectContainerType accountContainer = new ObjectFactory().createObjectContainerType();
            logger.trace("ObjectCOntainer for account: {}", (Object)JAXBUtil.silentMarshalWrap((Object)accountContainer, (QName)new QName("http://midpoint.evolveum.com/xml/ns/public/common/common-1.xsd", "ObjectContainerType")));
            accountContainer.setObject((ObjectType)accountShadowJaxb.getValue());
            logger.trace("Account in ObjectCOntainer with applied schema handling: {}", (Object)JAXBUtil.silentMarshalWrap((Object)accountContainer, (QName)new QName("http://midpoint.evolveum.com/xml/ns/public/common/common-1.xsd", "ObjectContainerType")));
            String accountOid = this.addObject(accountContainer);
            ObjectReferenceType accountRef = new ObjectReferenceType();
            accountRef.setOid(accountOid);
            accountRef.setType(QNameUtil.uriToQName((String)Utils.getObjectType((String)"AccountType")));
            Element accountRefElement = null;
            try {
                accountRefElement = JAXBUtil.jaxbToDom((Object)accountRef, (QName)SchemaConstants.I_ACCOUNT_REF, (Document)DOMUtil.getDocument());
            }
            catch (JAXBException ex) {
                logger.error("### MODEL # Fault {}(..): Parsing of account reference failed : {}", (Object)operation, (Object)ex);
                throw this.createFaultMessage("Parsing of account reference failed (" + operation + "): " + ex.getMessage(), SystemFaultType.class, false, (Exception)((Object)ex), null);
            }
            change.getValue().getAny().clear();
            change.getValue().getAny().add(accountRefElement);
        }
        logger.debug("End search for new accounts in object changes");
    }

    private AccountShadowType resolveAccount(String accountOid) throws FaultMessage {
        OperationalResultType operationalResult = new OperationalResultType();
        Holder holder = new Holder((Object)operationalResult);
        PropertyReferenceListType resolve = new PropertyReferenceListType();
        ObjectContainerType result = this.provisioningService.getObject(accountOid, resolve, holder);
        logger.trace("resolveAccount result = {}", (Object)result);
        return (AccountShadowType)result.getObject();
    }

    private ResourceType resolveResource(String resourceOid) throws FaultMessage {
        OperationalResultType operationalResult = new OperationalResultType();
        Holder holder = new Holder((Object)operationalResult);
        PropertyReferenceListType resolve = new PropertyReferenceListType();
        ObjectContainerType result = this.provisioningService.getObject(resourceOid, resolve, holder);
        logger.trace("resolveResource result = {}", (Object)result);
        return (ResourceType)result.getObject();
    }

    public ObjectContainerType getObject(String oid, PropertyReferenceListType resolve) throws com.evolveum.midpoint.xml.ns._public.model.model_1.FaultMessage {
        ObjectType objectType;
        if (oid == null || oid.isEmpty()) {
            throw new IllegalArgumentException("Oid must not be null or empty.");
        }
        if (resolve == null) {
            throw new IllegalArgumentException("Property reference list type must not be null.");
        }
        logger.info("### MODEL # Enter getObject({},{})", (Object)oid, (Object)DebugUtil.prettyPrint((PropertyReferenceListType)resolve));
        if (logger.isDebugEnabled()) {
            for (PropertyReferenceType property : resolve.getProperty()) {
                XPathType xpath = new XPathType(property.getProperty());
                logger.trace("Resolve XPath = " + xpath);
            }
        }
        ObjectContainerType result = null;
        try {
            result = this.repositoryService.getObject(oid, resolve);
        }
        catch (com.evolveum.midpoint.xml.ns._public.repository.repository_1.FaultMessage ex) {
            logger.error("### MODEL # Fault getObject(..): Repository invocation failed (getObject) : ", (Throwable)ex);
            throw this.createFaultMessage("Repository invocation failed (getObject)", ex.getFaultInfo(), (Exception)((Object)ex), null);
        }
        catch (RuntimeException ex) {
            logger.error("### MODEL # Fault getObject(..): Repository invocation failed (getObject) : ", (Throwable)ex);
            throw this.createFaultMessage("Repository invocation failed (getObject)", SystemFaultType.class, false, ex, null);
        }
        if (this.isManagedByProvisioning(result.getObject())) {
            try {
                OperationalResultType operationalResult = new OperationalResultType();
                Holder holder = new Holder((Object)operationalResult);
                result = this.provisioningService.getObject(oid, resolve, holder);
            }
            catch (FaultMessage ex) {
                logger.error("### MODEL # Fault getObject(..): Provisioning invocation failed (getObject) : ", (Throwable)ex);
                throw this.createFaultMessage("Provisioning invocation failed (getObject)", ex.getFaultInfo(), (Exception)((Object)ex), null);
            }
            catch (RuntimeException ex) {
                logger.error("### MODEL # Fault getObject(..): Provisioning invocation failed (getObject) : ", (Throwable)ex);
                throw this.createFaultMessage("Provisioning invocation failed (getObject)", SystemFaultType.class, false, ex, null);
            }
        }
        if ((objectType = result.getObject()) instanceof UserType) {
            UserType userType = (UserType)objectType;
            if (Utils.toResolve((String)"Account", (PropertyReferenceListType)resolve)) {
                for (ObjectReferenceType accountRef : userType.getAccountRef()) {
                    AccountShadowType account;
                    try {
                        account = this.resolveAccount(accountRef.getOid());
                    }
                    catch (FaultMessage ex) {
                        logger.error("### MODEL # Fault getObject(..): Provisioning invocation failed (getObject) : ", (Throwable)ex);
                        throw this.createFaultMessage("Provisioning invocation failed (getObject)", ex.getFaultInfo(), (Exception)((Object)ex), null);
                    }
                    catch (RuntimeException ex) {
                        logger.error("### MODEL # Fault getObject(..): Provisioning invocation failed (getObject) : ", (Throwable)ex);
                        throw this.createFaultMessage("Provisioning invocation failed (getObject)", SystemFaultType.class, false, ex, null);
                    }
                    userType.getAccount().add(account);
                }
                userType.getAccountRef().clear();
                if (Utils.toResolve((String)"Resource", (PropertyReferenceListType)resolve)) {
                    for (AccountShadowType account : userType.getAccount()) {
                        ResourceType resourceType;
                        try {
                            resourceType = this.resolveResource(account.getResourceRef().getOid());
                        }
                        catch (RuntimeException ex) {
                            logger.error("### MODEL # Fault getObject(..): Provisioning invocation failed (getObject) : ", (Throwable)ex);
                            throw this.createFaultMessage("Provisioning invocation failed (getObject)", SystemFaultType.class, false, ex, null);
                        }
                        catch (FaultMessage ex) {
                            logger.error("### MODEL # Fault getObject(..): Provisioning invocation failed (getObject) : ", (Throwable)ex);
                            throw this.createFaultMessage("Provisioning invocation failed (getObject)", ex.getFaultInfo(), (Exception)((Object)ex), null);
                        }
                        account.setResource(resourceType);
                        account.setResourceRef(null);
                    }
                }
            }
        }
        if (objectType instanceof AccountShadowType) {
            AccountShadowType accountShadowType = (AccountShadowType)objectType;
            if (Utils.toResolve((String)"Resource", (PropertyReferenceListType)resolve)) {
                ResourceType resourceType;
                try {
                    resourceType = this.resolveResource(accountShadowType.getResourceRef().getOid());
                }
                catch (FaultMessage ex) {
                    logger.error("### MODEL # Fault getObject(..): Provisioning invocation failed (getObject) : ", (Throwable)ex);
                    throw this.createFaultMessage("Provisioning invocation failed (getObject)", ex.getFaultInfo(), (Exception)((Object)ex), null);
                }
                catch (RuntimeException ex) {
                    logger.error("### MODEL # Fault getObject(..): Provisioning invocation failed (getObject) : ", (Throwable)ex);
                    throw this.createFaultMessage("Provisioning invocation failed (getObject) : ", SystemFaultType.class, false, ex, null);
                }
                accountShadowType.setResource(resourceType);
                accountShadowType.setResourceRef(null);
            }
        }
        logger.info("### MODEL # Exit getObject({},..): {}", (Object)oid, (Object)DebugUtil.prettyPrint((ObjectContainerType)result));
        logger.trace("Method getObject() returned: {}", (Object)JAXBUtil.silentMarshalWrap((Object)result, (QName)new QName("http://midpoint.evolveum.com/xml/ns/public/common/common-1.xsd", "ObjectContainerType")));
        return result;
    }

    public ObjectListType listObjects(String objectType, PagingType paging) throws com.evolveum.midpoint.xml.ns._public.model.model_1.FaultMessage {
        if (objectType == null || objectType.isEmpty()) {
            throw new IllegalArgumentException("Object type must not be null.");
        }
        if (paging == null) {
            throw new IllegalArgumentException("Paging must not be null.");
        }
        if (paging.getMaxSize() != null && paging.getMaxSize().longValue() < 0L) {
            throw new IllegalArgumentException("Paging max size must be more than 0.");
        }
        if (paging.getOffset() != null && paging.getOffset().longValue() < 0L) {
            throw new IllegalArgumentException("Paging offset index must be more than 0.");
        }
        logger.info("### MODEL # Enter listObjects({})", (Object)objectType);
        if (this.isObjectTypeManagedByProvisioning(objectType)) {
            try {
                OperationalResultType operationalResult = new OperationalResultType();
                Holder holder = new Holder((Object)operationalResult);
                ObjectListType result = this.provisioningService.listObjects(objectType, paging, holder);
                if (result.getObject().size() > 0) {
                    // empty if block
                }
                logger.info("### MODEL # Exit listObjects(..): {}", (Object)DebugUtil.prettyPrint((ObjectListType)result));
                return result;
            }
            catch (FaultMessage ex) {
                logger.error("### MODEL # Exception listObjects(..): Provisioning WS client failed for method listObjects", (Throwable)ex);
                throw this.createFaultMessage("Provisioning invocation failed (listObjects)", ex.getFaultInfo(), (Exception)((Object)ex), null);
            }
        }
        try {
            ObjectListType result = this.repositoryService.listObjects(objectType, paging);
            logger.info("### MODEL # Exit listObjects(..): {}", (Object)DebugUtil.prettyPrint((ObjectListType)result));
            return result;
        }
        catch (com.evolveum.midpoint.xml.ns._public.repository.repository_1.FaultMessage ex) {
            logger.error("### MODEL # Exception listObjects(..): Repository WS client failed for method listObjects", (Throwable)ex);
            throw this.createFaultMessage("Repository invocation failed (listObjects)", ex.getFaultInfo(), (Exception)((Object)ex), null);
        }
    }

    public ObjectListType searchObjects(QueryType filter, PagingType paging) throws com.evolveum.midpoint.xml.ns._public.model.model_1.FaultMessage {
        if (filter == null) {
            throw new IllegalArgumentException("Object type must not be null.");
        }
        if (paging == null) {
            throw new IllegalArgumentException("Paging must not be null.");
        }
        if (paging.getMaxSize() != null && paging.getMaxSize().longValue() < 0L) {
            throw new IllegalArgumentException("Paging max size must be more than 0.");
        }
        if (paging.getOffset() != null && paging.getOffset().longValue() < 0L) {
            throw new IllegalArgumentException("Paging offset index must be more than 0.");
        }
        logger.info("### MODEL # Enter searchObjects({})", (Object)filter);
        try {
            ObjectListType result = this.repositoryService.searchObjects(filter, paging);
            logger.info("### MODEL # Exit searchObjects(..): {}", (Object)DebugUtil.prettyPrint((ObjectListType)result));
            return result;
        }
        catch (com.evolveum.midpoint.xml.ns._public.repository.repository_1.FaultMessage ex) {
            logger.error("### MODEL # Exception searchObjects(..): Repository client failed for method searchObjects", (Throwable)ex);
            throw this.createFaultMessage("Repository invocation failed (searchObjects)", ex.getFaultInfo(), (Exception)((Object)ex), null);
        }
    }

    public void modifyObject(ObjectModificationType objectChange) throws com.evolveum.midpoint.xml.ns._public.model.model_1.FaultMessage {
        this.modifyObjectWithExclusion(objectChange, null);
    }

    /*
     * Unable to fully structure code
     */
    @Deprecated
    public void modifyObjectWithExclusion(ObjectModificationType objectChange, String accountOid) throws com.evolveum.midpoint.xml.ns._public.model.model_1.FaultMessage {
        if (objectChange == null) {
            throw new IllegalArgumentException("Object change must not be null.");
        }
        ModelService.logger.info("### MODEL # Enter modifyObjectWithExclusion({})", (Object)DebugUtil.prettyPrint((ObjectModificationType)objectChange));
        oid = objectChange.getOid();
        if (oid == null) {
            ModelService.logger.error("### MODEL # Fault modifyObjectWithExclusion(..): No OID specified");
            throw new com.evolveum.midpoint.xml.ns._public.model.model_1.FaultMessage("No OID specified", (FaultType)new IllegalArgumentFaultType());
        }
        if (objectChange.getPropertyModification().isEmpty()) {
            ModelService.logger.warn("Received empty changes in Model modifyObjectWithExclusion() for OID {}", (Object)oid);
            ModelService.logger.info("### MODEL # Exit modifyObjectWithExclusion(..)");
            return;
        }
        try {
            objectContainer = this.repositoryService.getObject(oid, new PropertyReferenceListType());
        }
        catch (com.evolveum.midpoint.xml.ns._public.repository.repository_1.FaultMessage ex) {
            ModelService.logger.error("### MODEL # Fault modifyObjectWithExclusion(..): Repository invocation failed (getObject) : {}", (Throwable)ex);
            throw this.createFaultMessage("Repository invocation failed (getObject)", ex.getFaultInfo(), (Exception)ex, null);
        }
        object = objectContainer.getObject();
        if (this.isManagedByProvisioning(object)) {
            operationalResult = new OperationalResultType();
            holder = new Holder((Object)operationalResult);
            try {
                if (object instanceof AccountShadowType && (userType = this.listAccountShadowOwnerSilent(object.getOid())) != null) {
                    provisioningObjectContainer = this.provisioningService.getObject(oid, new PropertyReferenceListType(), new Holder());
                    originalAccount = (AccountShadowType)provisioningObjectContainer.getObject();
                    changedAccount = (AccountShadowType)JAXBUtil.clone((ObjectType)originalAccount);
                    xmlPatchTool = new PatchXml();
                    xmlObject = xmlPatchTool.applyDifferences(objectChange, (ObjectType)changedAccount);
                    jaxb = (JAXBElement)JAXBUtil.unmarshal((String)xmlObject);
                    changedAccount = (AccountShadowType)jaxb.getValue();
                    resource = originalAccount.getResource();
                    if (resource == null) {
                        resource = this.resolveResource(originalAccount.getResourceRef().getOid());
                    }
                    object = this.schemaHandling.applyOutboundSchemaHandlingOnAccount(userType, (ResourceObjectShadowType)changedAccount, resource);
                    objectChange = CalculateXmlDiff.calculateChanges((ObjectType)originalAccount, (ObjectType)changedAccount);
                }
                if (objectChange == null || objectChange.getOid() == null || objectChange.getPropertyModification().isEmpty()) ** GOTO lbl81
                scripts = this.getScripts(object);
                this.provisioningService.modifyObject(objectChange, scripts, holder);
            }
            catch (FaultMessage ex) {
                ModelService.logger.error("### MODEL # Fault modifyObjectWithExclusion(..): Provisioning invocation failed (modifyObject) : {}", (Throwable)ex);
                throw this.createFaultMessage("Provisioning invocation failed (modifyObjectWithExclusion)", ex.getFaultInfo(), (Exception)ex, null);
            }
            catch (JAXBException ex) {
                throw this.createFaultMessage("Couldn't clone account '" + objectChange.getOid() + "'.", SystemFaultType.class, true, (Exception)ex, null);
            }
            catch (PatchException ex) {
                throw this.createFaultMessage("Couldn't patch account '" + objectChange.getOid() + "' xml.", SystemFaultType.class, true, (Exception)ex, null);
            }
            catch (SchemaHandlingException ex) {
                throw this.createFaultMessage("Couldn't apply outbound schema handling on account '" + objectChange.getOid() + "'.", SystemFaultType.class, true, ex, null);
            }
            catch (DiffException ex) {
                throw this.createFaultMessage("Couldn't create account '" + objectChange.getOid() + "' diff.", SystemFaultType.class, true, (Exception)ex, null);
            }
        } else {
            this.processAddAccount(objectChange, "modifyObject");
            try {
                password = null;
                if (object instanceof UserType) {
                    password = this.getPasswordFromModification(objectChange);
                }
                this.repositoryService.modifyObject(objectChange);
                if (password != null) {
                    this.updateAccountPasswords((UserType)object, password, accountOid);
                }
                if (object instanceof UserType) {
                    container = this.getObject(object.getOid(), new PropertyReferenceListType());
                    userType = (UserType)container.getObject();
                    if (ModelService.logger.isDebugEnabled()) {
                        ModelService.logger.debug("User before accounts update - outbound schema handling\n{}", (Object)DebugUtil.prettyPrint((ObjectType)userType));
                    }
                    this.updateUserAccounts(userType, accountOid);
                }
            }
            catch (com.evolveum.midpoint.xml.ns._public.repository.repository_1.FaultMessage ex) {
                ModelService.logger.error("### MODEL # Fault modifyObjectWithExclusion(..): Repository invocation failed (modifyObjectWithExclusion): {}", (Throwable)ex);
                throw this.createFaultMessage("Repository invocation failed (modifyObjectWithExclusion)", ex.getFaultInfo(), (Exception)ex, null);
            }
            catch (FaultMessage ex) {
                ModelService.logger.error("### MODEL # Fault modifyObjectWithExclusion(..): Provisioning method invocation failed: {}", (Throwable)ex);
                throw this.createFaultMessage("Provisioning method invocation failed", ex.getFaultInfo(), (Exception)ex, null);
            }
            catch (PatchException ex) {
                ModelService.logger.error("### MODEL # Fault modifyObjectWithExclusion(..): Couldn't patch user xml: {}", (Throwable)ex);
                throw this.createFaultMessage("Couldn't patch user xml", null, (Exception)ex, null);
            }
            catch (JAXBException ex) {
                ModelService.logger.error("### MODEL # Fault modifyObjectWithExclusion(..): Couldn't parse user xml: {}", (Throwable)ex);
                throw this.createFaultMessage("Couldn't parse user xml", null, (Exception)ex, null);
            }
            catch (DiffException ex) {
                ModelService.logger.error("### MODEL # Fault modifyObjectWithExclusion(..): Couldn't generate xml diff from user changes: {}", (Throwable)ex);
                throw this.createFaultMessage("Couldn't generate xml diff from user changes", null, (Exception)ex, null);
            }
        }
lbl81:
        // 3 sources

        ModelService.logger.info("### MODEL # Exit modifyObjectWithExclusion(..)");
    }

    private void updateUserAccounts(UserType user, String accountOid) throws com.evolveum.midpoint.xml.ns._public.model.model_1.FaultMessage {
        logger.trace("updateUserAccounts::begin - {}, {}", (Object)(null != user ? user.getOid() : null), (Object)accountOid);
        if (user == null) {
            throw this.createFaultMessage("User object is null, skipping account updates.", IllegalArgumentFaultType.class, false, null, null);
        }
        List accountRefs = user.getAccountRef();
        ArrayList<AccountShadowType> accounts = new ArrayList<AccountShadowType>();
        for (ObjectReferenceType ref : accountRefs) {
            try {
                accounts.add(this.resolveAccount(ref.getOid()));
            }
            catch (FaultMessage ex) {
                String message = ex.getFaultInfo() == null ? ex.getMessage() : ex.getFaultInfo().getMessage();
                logger.error("Couldn't resolve account '{}', reason: {}.", (Object)ref.getOid(), (Object)message);
                logger.debug("Couldn't resolve account '{}'.", (Object)ref.getOid(), (Object)ex);
                throw this.createFaultMessage("Couldn't resolve account '" + ref.getOid() + "', reason: " + message + ".", ex.getFaultInfo(), (Exception)((Object)ex), null);
            }
        }
        for (AccountShadowType account : accounts) {
            if (accountOid != null && accountOid.equals(account.getOid())) {
                logger.trace("Skipping user ({}) account update for '{}'", new Object[]{user.getOid(), account.getOid()});
                continue;
            }
            ResourceType resourceType = this.getResource((ResourceObjectShadowType)account);
            ResourceObjectShadowType newAccount = null;
            try {
                logger.trace("Applying resource ({}) outbound schema handling on account {}.", new Object[]{resourceType.getOid(), account.getOid()});
                newAccount = this.schemaHandling.applyOutboundSchemaHandlingOnAccount(user, (ResourceObjectShadowType)((AccountShadowType)JAXBUtil.clone((ObjectType)account)), resourceType);
            }
            catch (SchemaHandlingException ex) {
                logger.error("Failed to parse outbound schema hanling for account '{}' reason: {}.", (Object)account.getName(), (Object)ex.getMessage());
                throw this.createFaultMessage("Failed to parse outbound schema hanling: " + ex.getMessage(), ex.getFaultType(), ex, null);
            }
            catch (JAXBException ex) {
                logger.error("Failed to clone account object ({}), reason: {}", new Object[]{account.getOid(), ex.getMessage()});
                throw this.createFaultMessage("Failed to clone account object (" + account.getOid() + "), reason: " + ex.getMessage(), SystemFaultType.class, false, (Exception)((Object)ex), null);
            }
            try {
                Holder holder = new Holder();
                ObjectModificationType changes = CalculateXmlDiff.calculateChanges((ObjectType)account, (ObjectType)newAccount);
                changes.setOid(account.getOid());
                ScriptsType scripts = resourceType.getScripts();
                if (scripts == null) {
                    scripts = new ScriptsType();
                }
                logger.trace("Sending object changes for account {} to provisioning.", (Object)account.getOid());
                this.provisioningService.modifyObject(changes, scripts, holder);
            }
            catch (FaultMessage ex) {
                String message = ex.getFaultInfo() == null ? ex.getMessage() : ex.getFaultInfo().getMessage();
                logger.error("Couldn't update account '{}', reason: {}.", (Object)account.getName(), (Object)message);
                logger.debug("Couldn't update account '{}'.", (Object)account.getOid(), (Object)ex);
                throw this.createFaultMessage("Provisioning couldn't update account, reason: " + message, ex.getFaultInfo(), (Exception)((Object)ex), null);
            }
            catch (DiffException ex) {
                logger.error("Couldn't create account diff for '{}', reason: {}.", (Object)account.getName(), (Object)ex.getMessage());
                logger.debug("Couldn't create account diff for '{}'.", (Object)account.getOid(), (Object)ex);
                throw this.createFaultMessage("Couldn't create diff for account, reason: " + ex.getMessage(), SystemFaultType.class, false, (Exception)((Object)ex), null);
            }
        }
        logger.trace("updateUserAccounts::end");
    }

    private ResourceType getResource(ResourceObjectShadowType resourceShadow) throws com.evolveum.midpoint.xml.ns._public.model.model_1.FaultMessage {
        ResourceType resource = resourceShadow.getResource();
        if (resource != null) {
            return resource;
        }
        ObjectReferenceType resourceRef = resourceShadow.getResourceRef();
        if (resourceRef == null) {
            SchemaViolationFaultType fault = new SchemaViolationFaultType();
            fault.setMessage("Resource nor resource ref is defined.");
            throw this.createFaultMessage(fault.getMessage(), (FaultType)fault, null, null);
        }
        try {
            OperationalResultType operationalResult = new OperationalResultType();
            Holder holder = new Holder((Object)operationalResult);
            ObjectContainerType container = this.provisioningService.getObject(resourceRef.getOid(), null, holder);
            ObjectType object = container.getObject();
            if (object == null) {
                throw this.createFaultMessage("Couldn't get resource with oid '" + resourceRef.getOid() + "', reason: object returned from provisioning is null.", IllegalArgumentFaultType.class, false, null, null);
            }
            if (!(object instanceof ResourceType)) {
                throw this.createFaultMessage("Couldn't get resource with oid '" + resourceRef.getOid() + "', reason: object type returned from provisioning was type '" + object.getClass() + "' and not '" + ResourceType.class + "'.", IllegalArgumentFaultType.class, false, null, null);
            }
            resource = (ResourceType)object;
        }
        catch (FaultMessage ex) {
            String message = ex.getFaultInfo() == null ? ex.getMessage() : ex.getFaultInfo().getMessage();
            logger.error("Couldn't get resource with oid '{}', reason: {}.", (Object)resourceRef.getOid(), (Object)message);
            throw this.createFaultMessage("Couldn't get resource with oid '" + resourceRef.getOid() + "'.", ex.getFaultInfo(), (Exception)((Object)ex), null);
        }
        return resource;
    }

    private void updateAccountPasswords(UserType user, PropertyModificationType password, String accountOid) throws FaultMessage, JAXBException, PatchException, DiffException, com.evolveum.midpoint.xml.ns._public.model.model_1.FaultMessage {
        ObjectModificationType changes;
        List accountRefs = user.getAccountRef();
        for (ObjectReferenceType reference : accountRefs) {
            AccountShadowType account = this.resolveAccount(reference.getOid());
            if (!this.updateAccountPassword(account, accountOid)) continue;
            logger.debug("### MODEL # updating password for account: " + account.getName());
            changes = this.createPasswordModification(account, password);
            this.modifyObject(changes);
        }
        List accounts = user.getAccount();
        for (AccountShadowType account : accounts) {
            if (!this.updateAccountPassword(account, accountOid)) continue;
            logger.debug("### MODEL # updating password for account: " + account.getName());
            changes = this.createPasswordModification(account, password);
            this.modifyObject(changes);
        }
    }

    private ObjectModificationType createPasswordModification(AccountShadowType account, PropertyModificationType password) {
        ObjectModificationType changes = new ObjectModificationType();
        changes.setOid(account.getOid());
        changes.getPropertyModification().add(password);
        return changes;
    }

    private boolean updateAccountPassword(AccountShadowType account, String accountOid) throws FaultMessage {
        SchemaHandlingType.AccountType handling;
        if (accountOid != null && accountOid.equals(account.getOid())) {
            return false;
        }
        ResourceType resource = account.getResource();
        if (resource == null) {
            resource = this.resolveResource(account.getResourceRef().getOid());
        }
        if ((handling = ObjectTypeUtil.getAccountTypeDefinitionFromSchemaHandling((ResourceObjectShadowType)account, (ResourceType)resource)) == null || handling.getCredentials() == null) {
            return false;
        }
        SchemaHandlingType.AccountType.Credentials credentials = handling.getCredentials();
        Boolean update = credentials.isOutboundPassword();
        if (update == null) {
            return false;
        }
        return update;
    }

    public static CredentialsType.Password getPassword(AccountShadowType account) {
        CredentialsType.Password password;
        CredentialsType credentials = account.getCredentials();
        ObjectFactory of = new ObjectFactory();
        if (credentials == null) {
            credentials = of.createCredentialsType();
            account.setCredentials(credentials);
        }
        if ((password = credentials.getPassword()) == null) {
            password = of.createCredentialsTypePassword();
            credentials.setPassword(password);
        }
        return password;
    }

    private PropertyModificationType getPasswordFromModification(ObjectModificationType objectChange) {
        List list = objectChange.getPropertyModification();
        for (PropertyModificationType propModification : list) {
            PropertyModificationType.Value value;
            XPathType path = new XPathType(propModification.getPath());
            List segments = path.toSegments();
            if (segments.size() == 0 || !((XPathSegment)segments.get(0)).getQName().equals(SchemaConstants.I_CREDENTIALS) || (value = propModification.getValue()) == null) continue;
            List elements = value.getAny();
            for (Element element : elements) {
                if (!SchemaConstants.I_PASSWORD.equals(new QName(element.getNamespaceURI(), element.getLocalName()))) continue;
                return propModification;
            }
        }
        return null;
    }

    public void deleteObject(String oid) throws com.evolveum.midpoint.xml.ns._public.model.model_1.FaultMessage {
        ObjectContainerType repositoryResult;
        logger.info("### MODEL # Enter deleteObject({})", (Object)oid);
        if (oid == null || oid.isEmpty()) {
            throw new IllegalArgumentException("Oid must not be null or empty.");
        }
        try {
            PropertyReferenceListType resolve = new PropertyReferenceListType();
            repositoryResult = this.repositoryService.getObject(oid, resolve);
        }
        catch (com.evolveum.midpoint.xml.ns._public.repository.repository_1.FaultMessage ex) {
            logger.error("### MODEL # Exception deleteObject(..): Repository WS client failed for method getObject", (Throwable)ex);
            throw this.createFaultMessage("Repository invocation failed (getObject)", ex.getFaultInfo(), (Exception)((Object)ex), null);
        }
        if (repositoryResult.getObject() instanceof ResourceObjectShadowType || repositoryResult.getObject() instanceof ResourceType) {
            try {
                OperationalResultType operationalResult = new OperationalResultType();
                Holder holder = new Holder((Object)operationalResult);
                ScriptsType scripts = this.getScripts(repositoryResult.getObject());
                this.provisioningService.deleteObject(oid, scripts, holder);
            }
            catch (FaultMessage ex) {
                logger.error("### MODEL # Exception deleteObject(..): Provisioning WS client failed for method deleteObject", (Throwable)ex);
                throw this.createFaultMessage("Provisioning invocation failed (deleteObject)", ex.getFaultInfo(), (Exception)((Object)ex), null);
            }
        }
        if (repositoryResult.getObject() instanceof UserType) {
            UserType user = (UserType)repositoryResult.getObject();
            List accountOids = ObjectTypeUtil.extractOids((List)user.getAccount(), (List)user.getAccountRef());
            OperationalResultType operationalResult = new OperationalResultType();
            Holder holder = new Holder((Object)operationalResult);
            FaultMessage lastProvisioningFault = null;
            com.evolveum.midpoint.xml.ns._public.repository.repository_1.FaultMessage lastRepositoryFault = null;
            ScriptsType scripts = null;
            for (String accountOid : accountOids) {
                try {
                    scripts = this.getScripts((ObjectType)this.resolveAccount(accountOid).getResource());
                    this.provisioningService.deleteObject(accountOid, scripts, holder);
                    ObjectReferenceType refToDelete = ObjectTypeUtil.findRef((String)accountOid, (List)user.getAccountRef());
                    PropertyModificationType propertyChangeType = ObjectTypeUtil.createPropertyModificationType((PropertyModificationTypeType)PropertyModificationTypeType.delete, null, (QName)new QName("http://midpoint.evolveum.com/xml/ns/public/common/common-1.xsd", "accountRef"), (Object)refToDelete);
                    ObjectModificationType objectChange = new ObjectModificationType();
                    objectChange.setOid(oid);
                    objectChange.getPropertyModification().add(propertyChangeType);
                    this.repositoryService.modifyObject(objectChange);
                }
                catch (FaultMessage ex) {
                    logger.error("Delete of account {} failed for user {} (OID: {}) : {}", new Object[]{accountOid, user.getName(), user.getOid(), ex.getMessage()});
                    lastProvisioningFault = ex;
                }
                catch (com.evolveum.midpoint.xml.ns._public.repository.repository_1.FaultMessage ex) {
                    logger.error("Delete of account {} failed for user {} (OID: {}) : {}", new Object[]{accountOid, user.getName(), user.getOid(), ex.getMessage()});
                    lastRepositoryFault = ex;
                }
            }
            if (lastProvisioningFault != null) {
                logger.error("### MODEL # Fault deleteObject(..): Provisioning WS client failed, last fault: {} ", (Object)lastProvisioningFault.getMessage());
                throw this.createFaultMessage("Provisioning invocation failed (deleteObject)", lastProvisioningFault.getFaultInfo(), (Exception)((Object)lastProvisioningFault), null);
            }
            if (lastRepositoryFault != null) {
                logger.error("### MODEL # Fault deleteObject(..): Repository WS client failed, last fault: {} ", (Object)lastRepositoryFault.getMessage());
                throw this.createFaultMessage("Repository invocation failed (deleteObject)", lastRepositoryFault.getFaultInfo(), (Exception)((Object)lastRepositoryFault), null);
            }
            try {
                this.repositoryService.deleteObject(oid);
            }
            catch (com.evolveum.midpoint.xml.ns._public.repository.repository_1.FaultMessage ex) {
                logger.error("### MODEL # Fault deleteObject(..): Delete user from repository failed : {} ", (Object)ex.getMessage());
                throw this.createFaultMessage("Repository invocation failed (deleteObject)", ex.getFaultInfo(), (Exception)((Object)ex), null);
            }
        }
        try {
            this.repositoryService.deleteObject(oid);
        }
        catch (com.evolveum.midpoint.xml.ns._public.repository.repository_1.FaultMessage ex) {
            logger.error("### MODEL # Fault deleteObject(..): Delete object from repository failed : {} ", (Object)ex.getMessage());
            throw this.createFaultMessage("Repository invocation failed (deleteObject)", ex.getFaultInfo(), (Exception)((Object)ex), null);
        }
    }

    public PropertyAvailableValuesListType getPropertyAvailableValues(String oid, PropertyReferenceListType properties) throws com.evolveum.midpoint.xml.ns._public.model.model_1.FaultMessage {
        if (oid == null || oid.isEmpty()) {
            throw new IllegalArgumentException("Oid must not be null.");
        }
        logger.info("### MODEL # Enter getPropertyAvailableValues({},{})", (Object)oid, (Object)DebugUtil.prettyPrint((PropertyReferenceListType)properties));
        PropertyAvailableValuesListType propertyAvailableValues = new PropertyAvailableValuesListType();
        logger.info("### MODEL # Enter getPropertyAvailableValues(..) : ", (Object)DebugUtil.prettyPrint((PropertyAvailableValuesListType)propertyAvailableValues));
        return propertyAvailableValues;
    }

    public UserContainerType listAccountShadowOwner(String accountOid) throws com.evolveum.midpoint.xml.ns._public.model.model_1.FaultMessage {
        if (accountOid == null || accountOid.isEmpty()) {
            throw new IllegalArgumentException("Account oid must not be null or empty.");
        }
        logger.info("### MODEL # Enter listAccountShadowOwner({})", (Object)accountOid);
        try {
            UserContainerType result = this.repositoryService.listAccountShadowOwner(accountOid);
            logger.info("### MODEL # Exit listAccountShadowOwner(..): {}", (Object)DebugUtil.prettyPrint((UserContainerType)result));
            return result;
        }
        catch (com.evolveum.midpoint.xml.ns._public.repository.repository_1.FaultMessage ex) {
            logger.error("### MODEL # Exception listAccountShadowOwner(..): Repository client failed for method listAccountShadowOwner", (Throwable)ex);
            throw this.createFaultMessage("Repository invocation failed (listAccountShadowOwner)", ex.getFaultInfo(), (Exception)((Object)ex), null);
        }
    }

    public ResourceObjectShadowListType listResourceObjectShadows(String resourceOid, String resourceObjectShadowType) throws com.evolveum.midpoint.xml.ns._public.model.model_1.FaultMessage {
        if (resourceOid == null || resourceOid.isEmpty()) {
            throw new IllegalArgumentException("Resource oid must not be null or empty.");
        }
        if (resourceObjectShadowType == null || resourceObjectShadowType.isEmpty()) {
            throw new IllegalArgumentException("Resource shadow type must not be null or empty.");
        }
        if (!Utils.getObjectType((String)"AccountType").equals(resourceObjectShadowType)) {
            throw new IllegalArgumentException("Currently model (repository) can list only resource objects of type AccountType.");
        }
        logger.info("### MODEL # Enter listResourceObjectShadows({},{})", (Object)resourceOid, (Object)resourceObjectShadowType);
        try {
            ResourceObjectShadowListType result = this.repositoryService.listResourceObjectShadows(resourceOid, resourceObjectShadowType);
            logger.info("### MODEL # Exit listResourceObjectShadows(..): {}", (Object)DebugUtil.prettyPrint((ResourceObjectShadowListType)result));
            return result;
        }
        catch (com.evolveum.midpoint.xml.ns._public.repository.repository_1.FaultMessage ex) {
            logger.error("### MODEL # Exception listResourceObjectShadows(..): Repository client failed for method listResourceObjectShadows", (Throwable)ex);
            throw this.createFaultMessage("Repository invocation failed (listResourceObjectShadows)", ex.getFaultInfo(), (Exception)((Object)ex), null);
        }
    }

    private boolean isManagedByProvisioning(ObjectType object) {
        if (object instanceof ResourceObjectShadowType) {
            return true;
        }
        return object instanceof ResourceType;
    }

    private boolean isObjectTypeManagedByProvisioning(String objectType) {
        return Utils.getObjectType((String)"ResourceType").equals(objectType) || Utils.getObjectType((String)"AccountType").equals(objectType);
    }

    private com.evolveum.midpoint.xml.ns._public.model.model_1.FaultMessage createFaultMessage(String message, FaultType faultType, Exception ex, OperationalResultType result) {
        StringBuilder builder = new StringBuilder();
        builder.append(message);
        boolean messageAdded = false;
        if (faultType != null && !StringUtils.isEmpty((String)faultType.getMessage())) {
            builder.append(": ");
            builder.append(faultType.getMessage());
            messageAdded = true;
        }
        if (!messageAdded && ex != null) {
            builder.append(": ");
            builder.append(ex.getMessage());
        }
        return new com.evolveum.midpoint.xml.ns._public.model.model_1.FaultMessage(builder.toString(), faultType, (Throwable)ex);
    }

    private com.evolveum.midpoint.xml.ns._public.model.model_1.FaultMessage createFaultMessage(String message, Class<? extends FaultType> faultTypeClass, boolean temporary, Exception exception, OperationalResultType result) {
        FaultType fault;
        try {
            fault = faultTypeClass.newInstance();
        }
        catch (InstantiationException ex) {
            throw new IllegalArgumentException("Cannot instantate " + faultTypeClass.getName(), ex);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalArgumentException("Cannot instantate " + faultTypeClass.getName(), ex);
        }
        if (exception instanceof RuntimeException) {
            fault.setMessage(message + " : " + exception.getClass().getSimpleName() + " : " + exception.getMessage());
        } else {
            fault.setMessage(message);
        }
        fault.setTemporary(temporary);
        return new com.evolveum.midpoint.xml.ns._public.model.model_1.FaultMessage(message, fault, (Throwable)exception);
    }

    public ResourceTestResultType testResource(String resourceOid) throws com.evolveum.midpoint.xml.ns._public.model.model_1.FaultMessage {
        logger.info("### MODEL # Enter testResource({})", (Object)resourceOid);
        ResourceTestResultType result = null;
        try {
            result = this.provisioningService.testResource(resourceOid);
        }
        catch (FaultMessage ex) {
            logger.error("### MODEL # Fault testResource(..): Provisioning invocation failed (getObject) : ", (Throwable)ex);
            throw this.createFaultMessage("Provisioning invocation failed (testResource), reason: ", ex.getFaultInfo(), (Exception)((Object)ex), null);
        }
        catch (RuntimeException ex) {
            logger.error("### MODEL # Fault testResource(..): Provisioning invocation failed (getObject) : ", (Throwable)ex);
            throw this.createFaultMessage("Provisioning invocation failed (testResource)", SystemFaultType.class, false, ex, null);
        }
        logger.info("### MODEL # Exit testResource({}): {}", (Object)resourceOid, (Object)result);
        return result;
    }

    public ObjectListType listResourceObjects(String resourceOid, String objectType, PagingType paging, Holder<OperationalResultType> resultHolder) throws com.evolveum.midpoint.xml.ns._public.model.model_1.FaultMessage {
        logger.info("### MODEL # Enter listResourceObjects({},{},...)", (Object)resourceOid, (Object)objectType);
        ObjectListType result = null;
        try {
            result = this.provisioningService.listResourceObjects(resourceOid, objectType, paging, resultHolder);
        }
        catch (FaultMessage ex) {
            logger.error("### MODEL # Fault listResourceObjects(..): Provisioning invocation failed (getObject) : ", (Throwable)ex);
            throw this.createFaultMessage("Provisioning invocation failed (getObject)", ex.getFaultInfo(), (Exception)((Object)ex), null);
        }
        catch (RuntimeException ex) {
            logger.error("### MODEL # Fault listResourceObjects(..): Provisioning invocation failed (getObject) : ", (Throwable)ex);
            throw this.createFaultMessage("Provisioning invocation failed (getObject)", SystemFaultType.class, false, ex, null);
        }
        logger.info("### MODEL # Exit listResourceObjects({},...): {}", (Object)resourceOid, (Object)result);
        return result;
    }

    public EmptyType launchImportFromResource(String resourceOid, String objectClass) throws com.evolveum.midpoint.xml.ns._public.model.model_1.FaultMessage {
        logger.info("### MODEL # Enter launchImportFromResource({},{})", (Object)resourceOid, (Object)objectClass);
        EmptyType result = null;
        try {
            result = this.provisioningService.launchImportFromResource(resourceOid, objectClass);
        }
        catch (FaultMessage ex) {
            logger.error("### MODEL # Fault launchImportFromResource(..): Provisioning invocation failed (launchImportFromResource) : ", (Throwable)ex);
            throw this.createFaultMessage("Provisioning invocation failed (launchImportFromResource)", ex.getFaultInfo(), (Exception)((Object)ex), null);
        }
        catch (RuntimeException ex) {
            logger.error("### MODEL # Fault launchImportFromResource(..): Provisioning invocation failed (launchImportFromResource) : ", (Throwable)ex);
            throw this.createFaultMessage("Provisioning invocation failed (launchImportFromResource)", SystemFaultType.class, false, ex, null);
        }
        logger.info("### MODEL # Exit launchImportFromResource(..): {}", (Object)result);
        return result;
    }

    public TaskStatusType getImportStatus(String resourceOid) throws com.evolveum.midpoint.xml.ns._public.model.model_1.FaultMessage {
        if (resourceOid == null || resourceOid.isEmpty()) {
            throw new IllegalArgumentException("Resource OID must not be null or empty.");
        }
        logger.info("### MODEL # Enter getImportStatus({})", (Object)resourceOid);
        TaskStatusType result = null;
        try {
            result = this.provisioningService.getImportStatus(resourceOid);
        }
        catch (FaultMessage ex) {
            logger.error("### MODEL # Fault getImportStatus(..): Provisioning invocation failed (getImportStatus) : ", (Throwable)ex);
            throw this.createFaultMessage("Provisioning invocation failed (getImportStatus)", ex.getFaultInfo(), (Exception)((Object)ex), null);
        }
        catch (RuntimeException ex) {
            logger.error("### MODEL # Fault getImportStatus(..): Provisioning invocation failed (getImportStatus) : ", (Throwable)ex);
            throw this.createFaultMessage("Provisioning invocation failed (getImportStatus)", SystemFaultType.class, false, ex, null);
        }
        logger.info("### MODEL # Exit getImportStatus({}): {}", (Object)resourceOid, (Object)result);
        return result;
    }
}

